/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.SystemErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMergeStorageChecker {
    private static final Logger logger = LoggerFactory.getLogger(SegmentMergeStorageChecker.class);
    private static final Path ROOT_PATH = new Path("/");
    private static final ThreadLocal<FileSystem> rootFileSystem = new ThreadLocal();

    public static void setRootFileSystem(FileSystem fileSystem) {
        rootFileSystem.set(fileSystem);
    }

    private static FileSystem getRootFileSystem(Configuration conf) {
        if (rootFileSystem.get() == null) {
            return HadoopUtil.getFileSystem(ROOT_PATH, conf);
        }
        return rootFileSystem.get();
    }

    public static void checkMergeSegmentThreshold(KylinConfig kylinConfig, String workingDir, long expectedSpaceByByte) throws KylinException {
        Double thresholdValue = kylinConfig.getMergeSegmentStorageThreshold();
        if (thresholdValue.equals(Double.parseDouble("0"))) {
            return;
        }
        logger.info("HDFS threshold check has been enabled, threshold value is {}", (Object)thresholdValue);
        Configuration hadoopConf = SegmentMergeStorageChecker.getHadoopConfiguration(kylinConfig, workingDir);
        int dfsReplication = SegmentMergeStorageChecker.getDfsReplication(workingDir, hadoopConf);
        try {
            SegmentMergeStorageChecker.checkClusterStorageThresholdValue(workingDir, hadoopConf, expectedSpaceByByte, thresholdValue, dfsReplication);
        }
        catch (Exception ex) {
            logger.error("Failed to check cluster storage threshold value.", (Throwable)ex);
            if (!(ex instanceof KylinException)) {
                throw (KylinException)ex;
            }
            throw new KylinException((ErrorCodeSupplier)SystemErrorCode.FAILED_MERGE_SEGMENT, MsgPicker.getMsg().getSegmentMergeStorageCheckError(), ex);
        }
    }

    public static Configuration getHadoopConfiguration(KylinConfig kylinConfig, String workingDir) {
        Configuration hadoopConf = HadoopUtil.getCurrentConfiguration();
        logger.info("build conf is {}, working dir is :{}", (Object)kylinConfig.getBuildConf(), (Object)workingDir);
        if (!kylinConfig.getBuildConf().isEmpty()) {
            hadoopConf = HadoopUtil.healSickConfig(new Configuration());
            hadoopConf.set("fs.defaultFS", workingDir);
        }
        return hadoopConf;
    }

    public static int getDfsReplication(String workingDir, Configuration hadoopConf) {
        Configuration conf = HadoopUtil.getHadoopConfFromSparkEngine();
        String replicationValue = conf.get("dfs.replication");
        if (replicationValue.isEmpty()) {
            FileSystem fileSystem = HadoopUtil.getFileSystem(new Path(workingDir), hadoopConf);
            return fileSystem.getDefaultReplication(new Path(workingDir));
        }
        return Integer.parseInt(replicationValue);
    }

    public static void checkClusterStorageThresholdValue(String workingDir, Configuration conf, Long expectedSpaceByByte, double thresholdValue, int replication) throws IOException {
        HadoopSpaceInfo spaceInfoStatus = HadoopSpaceInfo.getHadoopSpaceInfo(conf, workingDir);
        logger.info("HDFS cluster space usage: {} B total space, {} B used space, and {} B remaining space.", new Object[]{spaceInfoStatus.getTotalSpace(), spaceInfoStatus.getUsedSpace(), spaceInfoStatus.getRemainingSpace()});
        if (spaceInfoStatus.getTotalSpace() <= 0L) {
            logger.error("The HDFS cluster storage space is insufficient.");
            throw new KylinException((ErrorCodeSupplier)SystemErrorCode.FAILED_MERGE_SEGMENT, MsgPicker.getMsg().getSegmentMergeStorageCheckError());
        }
        if (SegmentMergeStorageChecker.isThresholdAlarms((expectedSpaceByByte = Long.valueOf(SegmentMergeStorageChecker.recountExpectedSpaceByte(expectedSpaceByByte, replication))).longValue(), spaceInfoStatus.getRemainingSpace(), spaceInfoStatus.getTotalSpace(), thresholdValue)) {
            logger.error("Failed to merge segment because the HDFS cluster usage exceeds the threshold after the merge.");
            throw new KylinException((ErrorCodeSupplier)SystemErrorCode.FAILED_MERGE_SEGMENT, MsgPicker.getMsg().getSegmentMergeStorageCheckError());
        }
    }

    public static long recountExpectedSpaceByte(long originalExpectedSpaceByte, int replication) {
        logger.info("Merging segments requires {} B space(original)", (Object)originalExpectedSpaceByte);
        logger.info("Replication is {}", (Object)replication);
        long expectedSpaceByByte = originalExpectedSpaceByte * (long)replication;
        logger.info("Merging segments requires {} B space after recount.", (Object)expectedSpaceByByte);
        return expectedSpaceByByte;
    }

    public static boolean isThresholdAlarms(double expectedSpaceByByte, double remainingSpace, double totalSpace, double thresholdValue) {
        logger.info("The space utilization is expected to be {}% after the merge.", (Object)((1.0 - (remainingSpace - expectedSpaceByByte) / totalSpace) * 100.0));
        return 1.0 - (remainingSpace - expectedSpaceByByte) / totalSpace >= thresholdValue;
    }

    public static Path getSpaceQuotaPath(FileSystem fileSystem, Path path) {
        try {
            if (path.getName().isEmpty()) {
                return null;
            }
            ContentSummary contentSummary = fileSystem.getContentSummary(path);
            long spaceQuota = contentSummary.getSpaceQuota();
            if (spaceQuota == -1L && path.getParent() != null) {
                return SegmentMergeStorageChecker.getSpaceQuotaPath(fileSystem, path.getParent());
            }
            if (spaceQuota != -1L) {
                return path;
            }
        }
        catch (IOException ex) {
            logger.error("Get space quota path error:{}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    static class HadoopSpaceInfo {
        private long usedSpace;
        private long totalSpace;
        private long remainingSpace;

        private HadoopSpaceInfo() {
        }

        public static HadoopSpaceInfo getHadoopSpaceInfo(Configuration conf, String workingDir) throws IOException {
            long totalSpace;
            long remainingSpace;
            long usedSpace;
            HadoopSpaceInfo hadoopSpaceInfo = new HadoopSpaceInfo();
            FileSystem fileSystem = SegmentMergeStorageChecker.getRootFileSystem(conf);
            FsStatus status = fileSystem.getStatus();
            if (fileSystem.exists(new Path(workingDir))) {
                Path spaceQuotaPath = SegmentMergeStorageChecker.getSpaceQuotaPath(fileSystem, new Path(workingDir));
                logger.info("The space quota path is {}", (Object)spaceQuotaPath);
                if (spaceQuotaPath != null) {
                    logger.info("Indicates that quota is configured.");
                    ContentSummary contentSummary = fileSystem.getContentSummary(spaceQuotaPath);
                    long spaceQuota = contentSummary.getSpaceQuota();
                    usedSpace = contentSummary.getSpaceConsumed();
                    remainingSpace = spaceQuota - contentSummary.getSpaceConsumed();
                    totalSpace = spaceQuota;
                } else {
                    logger.info("Indicates that quota is not configured.");
                    usedSpace = status.getUsed();
                    remainingSpace = status.getRemaining();
                    totalSpace = status.getCapacity();
                }
            } else {
                usedSpace = status.getUsed();
                remainingSpace = status.getRemaining();
                totalSpace = status.getCapacity();
            }
            hadoopSpaceInfo.setRemainingSpace(remainingSpace);
            hadoopSpaceInfo.setTotalSpace(totalSpace);
            hadoopSpaceInfo.setUsedSpace(usedSpace);
            return hadoopSpaceInfo;
        }

        public long getUsedSpace() {
            return this.usedSpace;
        }

        public long getTotalSpace() {
            return this.totalSpace;
        }

        public long getRemainingSpace() {
            return this.remainingSpace;
        }

        public void setUsedSpace(long usedSpace) {
            this.usedSpace = usedSpace;
        }

        public void setTotalSpace(long totalSpace) {
            this.totalSpace = totalSpace;
        }

        public void setRemainingSpace(long remainingSpace) {
            this.remainingSpace = remainingSpace;
        }
    }
}

