/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.kylin.common.util.HeadBuilder;
import org.apache.kylin.common.util.TailBuilder;

public class StringBuilderHelper {
    private final int totalSize;
    private final HeadBuilder headBuilder;
    private final TailBuilder tailBuilder;
    private int appendedSize = 0;

    public static StringBuilderHelper head(int headSize) {
        return new StringBuilderHelper(headSize, 0);
    }

    public static StringBuilderHelper tail(int tailSize) {
        return new StringBuilderHelper(0, tailSize);
    }

    public static StringBuilderHelper headTail(int headSize, int tailSize) {
        return new StringBuilderHelper(headSize, tailSize);
    }

    private StringBuilderHelper(int headSize, int tailSize) {
        this.headBuilder = new HeadBuilder(headSize);
        this.tailBuilder = new TailBuilder(tailSize);
        this.totalSize = headSize + tailSize;
    }

    public StringBuilderHelper append(CharSequence csq) {
        this.headBuilder.append(csq);
        this.tailBuilder.append(csq);
        this.appendedSize += csq.length();
        return this;
    }

    public StringBuilderHelper append(char c) {
        this.headBuilder.append(c);
        this.tailBuilder.append(c);
        ++this.appendedSize;
        return this;
    }

    private String merge() {
        if (this.appendedSize < this.totalSize) {
            char[] res = new char[this.appendedSize];
            this.headBuilder.toString().getChars(0, this.headBuilder.length(), res, 0);
            int least = this.appendedSize - this.headBuilder.length();
            this.tailBuilder.toString().getChars(this.tailBuilder.length() - least, this.tailBuilder.length(), res, this.headBuilder.length());
            return new String(res);
        }
        char[] res = new char[this.totalSize];
        int headLength = this.headBuilder.length();
        this.headBuilder.toString().getChars(0, headLength, res, 0);
        this.tailBuilder.toString().getChars(0, this.tailBuilder.length(), res, headLength);
        return new String(res);
    }

    public int length() {
        return Math.min(this.appendedSize, this.totalSize);
    }

    public String toString() {
        return this.merge();
    }
}

