/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.guava30.shaded.common.util.concurrent.ThreadFactoryBuilder;

public class ThreadUtils {
    private static final String NAME_SUFFIX = "-%d";

    public static ThreadFactory newDaemonThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat).build();
    }

    public static ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        ThreadFactory factory = ThreadUtils.newDaemonThreadFactory(threadName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, factory);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static ScheduledExecutorService newDaemonThreadScheduledExecutor(int corePoolSize, String threadName) {
        ThreadFactory factory = ThreadUtils.newDaemonThreadFactory(threadName);
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(corePoolSize, factory);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static ThreadPoolExecutor newDaemonScalableThreadPool(String prefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        LinkedTransferQueue<Runnable> queue = new LinkedTransferQueue<Runnable>(){

            @Override
            public boolean offer(Runnable r) {
                return this.tryTransfer(r);
            }
        };
        ThreadFactory factory = ThreadUtils.newDaemonThreadFactory(prefix + NAME_SUFFIX);
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)queue, factory);
        threadPool.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        return threadPool;
    }
}

