/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import springfox.documentation.schema.AlternateTypeRule;

public class AlternateTypeProvider {
    private List<AlternateTypeRule> rules = new ArrayList<AlternateTypeRule>();

    public AlternateTypeProvider(List<AlternateTypeRule> alternateTypeRules) {
        this.rules.addAll(alternateTypeRules);
    }

    public ResolvedType alternateFor(ResolvedType type) {
        Optional<AlternateTypeRule> matchingRule = this.rules.stream().filter(this.thatAppliesTo(type)).findFirst();
        if (matchingRule.isPresent()) {
            return matchingRule.get().alternateFor(type);
        }
        return type;
    }

    public void addRule(AlternateTypeRule rule) {
        this.rules.add(rule);
    }

    private Predicate<AlternateTypeRule> thatAppliesTo(ResolvedType type) {
        return input -> input.appliesTo(type);
    }
}

