/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.gluten.exception.GlutenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtil.class);

    public static List<String> getResources(String container, Pattern pattern) {
        Enumeration<URL> containerUrls;
        Preconditions.checkArgument((!container.isEmpty() ? 1 : 0) != 0, (Object)"Resource search should only be used under a certain container folder");
        Preconditions.checkArgument((!container.startsWith("/") && !container.endsWith("/") ? 1 : 0) != 0, (Object)"Resource container should not start or end with\"/\"");
        ArrayList<String> buffer = new ArrayList<String>();
        try {
            containerUrls = Thread.currentThread().getContextClassLoader().getResources(container);
        }
        catch (IOException e) {
            throw new GlutenException(e);
        }
        while (containerUrls.hasMoreElements()) {
            URL containerUrl = containerUrls.nextElement();
            ResourceUtil.getResources(containerUrl, pattern, buffer);
        }
        return Collections.unmodifiableList(buffer);
    }

    private static void getResources(URL containerUrl, Pattern pattern, List<String> buffer) {
        String protocol;
        switch (protocol = containerUrl.getProtocol()) {
            case "file": {
                File fileContainer = new File(containerUrl.getPath());
                Preconditions.checkState((fileContainer.exists() && fileContainer.isDirectory() ? 1 : 0) != 0, (Object)("Specified file container " + containerUrl + " is not a directory or not a file"));
                ResourceUtil.getResourcesFromDirectory(fileContainer, fileContainer, pattern, buffer);
                break;
            }
            case "jar": {
                String jarContainerPath = containerUrl.getPath();
                Pattern jarContainerPattern = Pattern.compile("file:([^!]+)!/(.+)");
                Matcher m = jarContainerPattern.matcher(jarContainerPath);
                if (!m.matches()) {
                    throw new GlutenException("Illegal Jar container URL: " + containerUrl);
                }
                String jarPath = m.group(1);
                File jarFile = new File(jarPath);
                Preconditions.checkState((jarFile.exists() && jarFile.isFile() ? 1 : 0) != 0, (Object)("Specified Jar container " + containerUrl + " is not a Jar file"));
                String dir = m.group(2);
                ResourceUtil.getResourcesFromJarFile(jarFile, dir, pattern, buffer);
                break;
            }
            default: {
                throw new GlutenException("Unrecognizable resource protocol: " + protocol);
            }
        }
    }

    private static void getResourcesFromJarFile(File jarFile, String dir, Pattern pattern, List<String> buffer) {
        ZipFile zf;
        try {
            zf = new ZipFile(jarFile);
        }
        catch (ZipException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            String relativeFileName;
            boolean accept;
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            if (!fileName.startsWith(dir) || !(accept = pattern.matcher(relativeFileName = new File(dir).toURI().relativize(new File(fileName).toURI()).getPath()).matches())) continue;
            buffer.add(relativeFileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private static void getResourcesFromDirectory(File root, File directory, Pattern pattern, List<String> buffer) {
        File[] fileList;
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                ResourceUtil.getResourcesFromDirectory(root, file, pattern, buffer);
                continue;
            }
            String relative = root.toURI().relativize(file.toURI()).getPath();
            boolean accept = pattern.matcher(relative).matches();
            if (!accept) continue;
            buffer.add(relative);
        }
    }
}

