/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.execution;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.collection.Iterator;

public class SparkRowIterator
implements java.util.Iterator<byte[]> {
    private final Iterator<byte[]> delegated;
    private final int defaultBufSize = 4096;
    private byte[] lastRowBuf;

    public SparkRowIterator(Iterator<byte[]> delegated) {
        this.delegated = delegated;
        this.lastRowBuf = null;
    }

    @Override
    public boolean hasNext() {
        return this.lastRowBuf != null || this.delegated.hasNext();
    }

    @Override
    public byte[] next() {
        return (byte[])this.delegated.next();
    }

    protected ByteBuffer createByteBuffer(int bufSize) {
        ByteBuffer buf = bufSize + 8 > 4096 ? ByteBuffer.allocateDirect(bufSize + 8) : ByteBuffer.allocateDirect(4096);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    public ByteBuffer nextBatch() {
        ByteBuffer buf = null;
        if (this.lastRowBuf != null) {
            buf = this.createByteBuffer(this.lastRowBuf.length);
            buf.putInt(this.lastRowBuf.length);
            buf.put(this.lastRowBuf);
            buf.putInt(-1);
            this.lastRowBuf = null;
            return buf;
        }
        while (this.delegated.hasNext()) {
            this.lastRowBuf = (byte[])this.delegated.next();
            if (buf == null) {
                buf = this.createByteBuffer(this.lastRowBuf.length);
            }
            if (buf.remaining() < this.lastRowBuf.length + 8) break;
            buf.putInt(this.lastRowBuf.length);
            buf.put(this.lastRowBuf);
            this.lastRowBuf = null;
        }
        buf.putInt(-1);
        return buf;
    }
}

