/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.gluten.execution.BroadCastHashJoinContext;
import org.apache.gluten.execution.JoinTypeTransform;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.utils.SubstraitUtil;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.JoinType;
import scala.collection.JavaConverters;

public class StorageJoinBuilder {
    public static native void nativeCleanBuildHashTable(String var0, long var1);

    public static native long nativeCloneBuildHashTable(long var0);

    private static native long nativeBuild(String var0, byte[] var1, long var2, String var4, int var5, boolean var6, boolean var7, byte[] var8, boolean var9, boolean var10);

    private StorageJoinBuilder() {
    }

    public static long build(byte[] batches, long rowCount, BroadCastHashJoinContext broadCastContext, List<Expression> newBuildKeys, List<Attribute> newOutput, boolean hasNullKeyValues) {
        int joinType;
        List output;
        List keys;
        ConverterUtils$ converter = ConverterUtils$.MODULE$;
        if (newBuildKeys.isEmpty()) {
            keys = JavaConverters.seqAsJavaList(broadCastContext.buildSideJoinKeys());
            output = JavaConverters.seqAsJavaList(broadCastContext.buildSideStructure());
        } else {
            keys = newBuildKeys;
            output = newOutput;
        }
        String joinKey = keys.stream().map(key -> {
            Attribute attr = converter.getAttrFromExpr(key);
            return converter.genColumnNameWithExprId(attr);
        }).collect(Collectors.joining(","));
        if (broadCastContext.buildHashTableId().startsWith("BuiltBNLJBroadcastTable-")) {
            joinType = SubstraitUtil.toCrossRelSubstrait((JoinType)broadCastContext.joinType()).ordinal();
        } else {
            boolean buildRight = broadCastContext.buildRight();
            joinType = JoinTypeTransform.toSubstraitJoinType(broadCastContext.joinType(), buildRight).ordinal();
        }
        return StorageJoinBuilder.nativeBuild(broadCastContext.buildHashTableId(), batches, rowCount, joinKey, joinType, broadCastContext.hasMixedFiltCondition(), broadCastContext.isExistenceJoin(), SubstraitUtil.toNameStruct((List)output).toByteArray(), broadCastContext.isNullAwareAntiJoin(), hasNullKeyValues);
    }
}

