/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime.plan;

import java.io.Serializable;
import java.sql.Date;
import java.util.Calendar;
import java.util.Locale;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.util.NlsString;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapWindowRel;
import org.apache.kylin.query.runtime.SparderRexVisitor;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.KapFunctions$;
import org.apache.spark.sql.SparkOperation$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class WindowPlan$
implements LogEx {
    public static WindowPlan$ MODULE$;
    private final List<String> sortSpecified;
    private final List<String> rowSpecified;
    private final List<String> nonRangeSpecified;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new WindowPlan$();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<String> sortSpecified() {
        return this.sortSpecified;
    }

    public List<String> rowSpecified() {
        return this.rowSpecified;
    }

    public List<String> nonRangeSpecified() {
        return this.nonRangeSpecified;
    }

    public LogicalPlan window(LogicalPlan plan, OlapWindowRel rel, DataContext datacontex) {
        long start = System.currentTimeMillis();
        IntRef windowCount = IntRef.create((int)0);
        RexWindowBound cfr_ignored_0 = ((Window.Group)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)rel.groups).asScala()).head()).upperBound;
        int columnSize = plan.output().size();
        Seq columns = (Seq)plan.output().map((Function1 & Serializable & scala.Serializable)c -> functions$.MODULE$.col(c.name()), Seq$.MODULE$.canBuildFrom());
        Map constantMap = ((TraversableOnce)((TraversableLike)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getConstants()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getValue(), Buffer$.MODULE$.canBuildFrom())).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)(entry._2$mcI$sp() + columnSize)), entry._1()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        SparderRexVisitor visitor = new SparderRexVisitor(plan, rel.getInput().getRowType(), datacontex);
        Buffer constants = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getConstants()).asScala()).map((Function1 & Serializable & scala.Serializable)constant -> KapFunctions$.MODULE$.k_lit(Literal$.MODULE$.apply(constant.accept((RexVisitor)visitor))), Buffer$.MODULE$.canBuildFrom());
        Seq columnsAndConstants = (Seq)columns.$plus$plus((GenTraversableOnce)constants, Seq$.MODULE$.canBuildFrom());
        Buffer windows = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)rel.groups).asScala()).flatMap((Function1 & Serializable & scala.Serializable)group -> {
            BooleanRef isDateTimeFamilyType = BooleanRef.create((boolean)false);
            Map fieldsNameToType = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getInput().getRowType().getFieldList()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                RelDataTypeField field = (RelDataTypeField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), (Object)field.getType().getSqlTypeName().toString());
                return tuple22;
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            fieldsNameToType.foreach((Function1 & Serializable & scala.Serializable)map -> {
                WindowPlan$.$anonfun$window$7(isDateTimeFamilyType, map);
                return BoxedUnit.UNIT;
            });
            ObjectRef orderByColumns = ObjectRef.create((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((RelCollationImpl)group.orderKeys).getFieldCollations()).asScala()).map((Function1 & Serializable & scala.Serializable)fieldIndex -> {
                RelFieldCollation.Direction direction;
                Column column = (Column)columns.apply(fieldIndex.getFieldIndex());
                if (!group$1.isRows && ((String)fieldsNameToType.apply((Object)BoxesRunTime.boxToInteger((int)fieldIndex.getFieldIndex()))).equalsIgnoreCase("timestamp")) {
                    column = column.cast((DataType)LongType$.MODULE$);
                }
                if (RelFieldCollation.Direction.DESCENDING.equals(direction = fieldIndex.direction)) {
                    column = column.desc();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RelFieldCollation.Direction.STRICTLY_DESCENDING.equals(direction)) {
                    column = column.desc();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RelFieldCollation.Direction.ASCENDING.equals(direction)) {
                    column = column.asc();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (RelFieldCollation.Direction.STRICTLY_ASCENDING.equals(direction)) {
                    column = column.asc();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return column;
            }, Buffer$.MODULE$.canBuildFrom())).toList());
            Seq partitionColumns = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)group.keys).asScala()).map((Function1 & Serializable & scala.Serializable)fieldIndex -> (Column)columns.apply(Predef$.MODULE$.Integer2int(fieldIndex)), Iterable$.MODULE$.canBuildFrom())).toSeq();
            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)group.aggCalls).asScala()).map((Function1 & Serializable & scala.Serializable)agg -> {
                Column column;
                String string;
                WindowSpec windowDesc = null;
                String opName = agg.op.getName().toUpperCase(Locale.ROOT);
                Map numberConstants = ((Map)((TraversableLike)constantMap.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WindowPlan$.$anonfun$window$11(x$2)))).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)entry._1$mcI$sp()), (Object)((Number)entry._2())), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Tuple2<Object, Object> tuple2 = MODULE$.buildRange((Window.Group)group, (Map<Object, Number>)numberConstants, isDateTimeFamilyType$1.elem, group$1.isRows);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long lowerBound = tuple2._1$mcJ$sp();
                long upperBound = tuple2._2$mcJ$sp();
                long l = lowerBound;
                long l2 = upperBound;
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(l, l2);
                Tuple2.mcJJ.sp sp3 = sp2;
                long lowerBound2 = sp3._1$mcJ$sp();
                long upperBound2 = sp3._2$mcJ$sp();
                if (((List)orderByColumns$1.elem).nonEmpty()) {
                    windowDesc = Window$.MODULE$.orderBy((Seq)((List)orderByColumns$1.elem));
                    if (!MODULE$.nonRangeSpecified().contains((Object)opName)) {
                        windowDesc = group$1.isRows || MODULE$.rowSpecified().contains((Object)opName) ? windowDesc.rowsBetween(lowerBound2, upperBound2) : windowDesc.rangeBetween(lowerBound2, upperBound2);
                    }
                } else if (MODULE$.sortSpecified().contains((Object)opName)) {
                    windowDesc = Window$.MODULE$.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{KapFunctions$.MODULE$.k_lit(BoxesRunTime.boxToInteger((int)1))}));
                    if (!MODULE$.nonRangeSpecified().contains((Object)opName)) {
                        windowDesc = group$1.isRows || MODULE$.rowSpecified().contains((Object)opName) ? windowDesc.rowsBetween(lowerBound2, upperBound2) : windowDesc.rangeBetween(lowerBound2, upperBound2);
                    }
                }
                if (partitionColumns.nonEmpty()) {
                    WindowSpec windowSpec = windowDesc = windowDesc == null ? Window$.MODULE$.partitionBy(partitionColumns) : windowDesc.partitionBy(partitionColumns);
                }
                if ("ROW_NUMBER".equals(string = opName)) {
                    column = functions$.MODULE$.row_number();
                } else if ("RANK".equals(string)) {
                    column = functions$.MODULE$.rank();
                } else if ("DENSE_RANK".equals(string)) {
                    column = functions$.MODULE$.dense_rank();
                } else if ("FIRST_VALUE".equals(string)) {
                    column = functions$.MODULE$.first((Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else if ("LAST_VALUE".equals(string)) {
                    column = functions$.MODULE$.last((Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else if ("LEAD".equals(string)) {
                    Column column2;
                    Buffer args = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)WindowPlan$.$anonfun$window$13(x$4)), Buffer$.MODULE$.canBuildFrom());
                    int n = args.size();
                    switch (n) {
                        case 1: {
                            column2 = functions$.MODULE$.lead((Column)columnsAndConstants.apply(BoxesRunTime.unboxToInt((Object)args.head())), 1);
                            break;
                        }
                        case 2: {
                            column2 = functions$.MODULE$.lead((Column)columnsAndConstants.apply(BoxesRunTime.unboxToInt((Object)args.head())), ((Number)constantMap.apply(args.apply(1))).intValue());
                            break;
                        }
                        case 3: {
                            column2 = functions$.MODULE$.lead((Column)columnsAndConstants.apply(BoxesRunTime.unboxToInt((Object)args.head())), ((Number)constantMap.apply(args.apply(1))).intValue(), MODULE$.constantValue(rel, (Map<Object, Object>)constantMap, BoxesRunTime.unboxToInt((Object)args.apply(2)), visitor));
                            break;
                        }
                        default: {
                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                        }
                    }
                    column = column2;
                } else if ("LAG".equals(string)) {
                    Column column3;
                    Buffer args = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)WindowPlan$.$anonfun$window$14(x$5)), Buffer$.MODULE$.canBuildFrom());
                    int n = args.size();
                    switch (n) {
                        case 1: {
                            column3 = functions$.MODULE$.lag((Column)columnsAndConstants.apply(BoxesRunTime.unboxToInt((Object)args.head())), 1);
                            break;
                        }
                        case 2: {
                            column3 = functions$.MODULE$.lag((Column)columnsAndConstants.apply(BoxesRunTime.unboxToInt((Object)args.head())), ((Number)constantMap.apply(args.apply(1))).intValue());
                            break;
                        }
                        case 3: {
                            column3 = functions$.MODULE$.lag((Column)columnsAndConstants.apply(BoxesRunTime.unboxToInt((Object)args.head())), ((Number)constantMap.apply(args.apply(1))).intValue(), MODULE$.constantValue(rel, (Map<Object, Object>)constantMap, BoxesRunTime.unboxToInt((Object)args.apply(2)), visitor));
                            break;
                        }
                        default: {
                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                        }
                    }
                    column = column3;
                } else if ("NTILE".equals(string)) {
                    column = functions$.MODULE$.ntile(((Number)constantMap.apply((Object)BoxesRunTime.boxToInteger((int)((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()))).intValue());
                } else if ("COUNT".equals(string)) {
                    column = functions$.MODULE$.count(agg.operands.isEmpty() ? KapFunctions$.MODULE$.k_lit(BoxesRunTime.boxToInteger((int)1)) : (Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else if ("MAX".equals(string)) {
                    column = functions$.MODULE$.max((Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else if (opName.contains("SUM")) {
                    column = functions$.MODULE$.sum((Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else if ("MIN".equals(string)) {
                    column = functions$.MODULE$.min((Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else if ("AVG".equals(string)) {
                    column = functions$.MODULE$.avg((Column)columnsAndConstants.apply(((RexInputRef)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)agg.operands).asScala()).head()).getIndex()));
                } else {
                    throw new MatchError((Object)string);
                }
                Column func = column;
                ++windowCount$1.elem;
                String alias = new StringBuilder(8).append(System.identityHashCode(rel)).append("_window_").append(windowCount$1.elem).toString();
                return windowDesc == null ? func.over().alias(alias) : func.over(windowDesc).alias(alias);
            }, Buffer$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom());
        Seq selectColumn = (Seq)columns.$plus$plus((GenTraversableOnce)windows, Seq$.MODULE$.canBuildFrom());
        LogicalPlan windowPlan = SparkOperation$.MODULE$.project((Seq<Column>)selectColumn, plan);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Gen window cost Time :").append(System.currentTimeMillis() - start).append(" ").toString());
        return windowPlan;
    }

    public Object constantValue(OlapWindowRel rel, Map<Object, Object> constantMap, int idx, SparderRexVisitor rexVisitor) {
        Object object;
        if (constantMap.contains((Object)BoxesRunTime.boxToInteger((int)idx))) {
            Object object2;
            Object object3 = constantMap.apply((Object)BoxesRunTime.boxToInteger((int)idx));
            if (object3 instanceof NlsString) {
                NlsString nlsString = (NlsString)object3;
                object2 = nlsString.getValue();
            } else if (object3 instanceof Calendar) {
                Calendar calendar = (Calendar)object3;
                object2 = new Date(calendar.getTimeInMillis());
            } else {
                object2 = object3;
            }
            object = object2;
        } else {
            BoxedUnit boxedUnit;
            RelNode relNode = rel.getInput();
            if (relNode instanceof OlapProjectRel) {
                OlapProjectRel olapProjectRel = (OlapProjectRel)relNode;
                Object object4 = ((RexNode)olapProjectRel.getProjects().get(idx)).accept((RexVisitor)rexVisitor);
                if (object4 instanceof Column) {
                    Column column = (Column)object4;
                    String string = column.expr().prettyName().toUpperCase(Locale.ROOT);
                    Object object5 = "CURRENT_DATE".equals(string) ? DateFormat.getDateFormat((String)"yyyy-MM-dd").format(DateTimeUtils$.MODULE$.currentTimestamp() / 1000L) : column.expr();
                    boxedUnit = object5;
                } else if (object4 instanceof Literal) {
                    Literal literal = (Literal)object4;
                    boxedUnit = literal;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new IllegalStateException("Unsupported window function format");
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            object = boxedUnit2;
        }
        return object;
    }

    public Object constantValue(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof NlsString) {
            NlsString nlsString = (NlsString)object2;
            object = nlsString.getValue();
        } else if (object2 instanceof Calendar) {
            Calendar calendar = (Calendar)object2;
            object = new Date(calendar.getTimeInMillis());
        } else {
            object = object2;
        }
        return object;
    }

    public Tuple2<Object, Object> buildRange(Window.Group group, Map<Object, Number> constantMap, boolean isDateType, boolean isRows) {
        long lowerBound = Window$.MODULE$.currentRow();
        if (group.lowerBound.isPreceding()) {
            if (group.lowerBound.isUnbounded()) {
                lowerBound = Window$.MODULE$.unboundedPreceding();
            } else {
                lowerBound = -((Number)constantMap.apply((Object)BoxesRunTime.boxToInteger((int)((RexInputRef)group.lowerBound.getOffset()).getIndex()))).longValue();
                if (isDateType && !isRows) {
                    lowerBound /= 1000L;
                }
            }
        } else if (group.lowerBound.isFollowing()) {
            if (group.lowerBound.isUnbounded()) {
                lowerBound = Window$.MODULE$.unboundedFollowing();
            } else {
                lowerBound = ((Number)constantMap.apply((Object)BoxesRunTime.boxToInteger((int)((RexInputRef)group.lowerBound.getOffset()).getIndex()))).longValue();
                if (isDateType && !isRows) {
                    lowerBound /= 1000L;
                }
            }
        }
        long upperBound = Window$.MODULE$.currentRow();
        if (group.upperBound.isPreceding()) {
            if (group.upperBound.isUnbounded()) {
                upperBound = Window$.MODULE$.unboundedPreceding();
            } else {
                upperBound = -((Number)constantMap.apply((Object)BoxesRunTime.boxToInteger((int)((RexInputRef)group.upperBound.getOffset()).getIndex()))).longValue();
                if (isDateType && !isRows) {
                    upperBound /= 1000L;
                }
            }
        } else if (group.upperBound.isFollowing()) {
            if (group.upperBound.isUnbounded()) {
                upperBound = Window$.MODULE$.unboundedFollowing();
            } else {
                upperBound = ((Number)constantMap.apply((Object)BoxesRunTime.boxToInteger((int)((RexInputRef)group.upperBound.getOffset()).getIndex()))).longValue();
                if (isDateType && !isRows) {
                    upperBound /= 1000L;
                }
            }
        }
        return new Tuple2.mcJJ.sp(lowerBound, upperBound);
    }

    public static final /* synthetic */ void $anonfun$window$7(BooleanRef isDateTimeFamilyType$1, Tuple2 map) {
        block0: {
            if (!SparderTypeUtil$.MODULE$.isDateTimeFamilyType((String)map._2())) break block0;
            isDateTimeFamilyType$1.elem = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$window$11(Tuple2 x$2) {
        return x$2._2() instanceof Number;
    }

    public static final /* synthetic */ int $anonfun$window$13(RexNode x$4) {
        return ((RexInputRef)x$4).getIndex();
    }

    public static final /* synthetic */ int $anonfun$window$14(RexNode x$5) {
        return ((RexInputRef)x$5).getIndex();
    }

    private WindowPlan$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.sortSpecified = new .colon.colon((Object)"CUME_DIST", (List)new .colon.colon((Object)"LEAD", (List)new .colon.colon((Object)"RANK", (List)new .colon.colon((Object)"DENSE_RANK", (List)new .colon.colon((Object)"ROW_NUMBER", (List)new .colon.colon((Object)"NTILE", (List)new .colon.colon((Object)"LAG", (List)Nil$.MODULE$)))))));
        this.rowSpecified = new .colon.colon((Object)"RANK", (List)new .colon.colon((Object)"PERCENT_RANK", (List)new .colon.colon((Object)"DENSE_RANK", (List)new .colon.colon((Object)"NTILE", (List)new .colon.colon((Object)"ROW_NUMBER", (List)Nil$.MODULE$)))));
        this.nonRangeSpecified = new .colon.colon((Object)"LAG", (List)new .colon.colon((Object)"LEAD", (List)Nil$.MODULE$));
    }
}

