/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.percentile.PercentileCounter;
import org.apache.kylin.measure.percentile.PercentileSerializer;
import org.apache.kylin.measure.sumlc.SumLCCounter;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.udaf.BitmapSerAndDeSer$;
import org.apache.spark.sql.udaf.BitmapSerAndDeSerObj$;
import org.apache.spark.sql.udaf.NullSafeValueSerializer;
import org.apache.spark.sql.udaf.SumLCUtil$;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ExpressionUtils$ {
    public static ExpressionUtils$ MODULE$;

    static {
        new ExpressionUtils$();
    }

    public <T extends Expression> Tuple2<String, Tuple2<ExpressionInfo, Function1<Seq<Expression>, Expression>>> expression(String name, ClassTag<T> tag) {
        Constructor[] constructorArray;
        if (RuntimeReplaceable.class.isAssignableFrom(tag.runtimeClass())) {
            Constructor<?>[] all = tag.runtimeClass().getConstructors();
            int maxNumArgs = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])all)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getParameterCount()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
            constructorArray = (Constructor[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])all)).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExpressionUtils$.$anonfun$expression$2(maxNumArgs, x$2)));
        } else {
            constructorArray = tag.runtimeClass().getConstructors();
        }
        Constructor[] constructors = constructorArray;
        Option varargCtor = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ExpressionUtils$.$anonfun$expression$3(x$3)));
        Function1 & Serializable & scala.Serializable builder = (Function1 & Serializable & scala.Serializable)expressions -> {
            Expression expression;
            if (varargCtor.isDefined()) {
                Expression e;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Expression)((Constructor)varargCtor.get()).newInstance(expressions));
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e2 = failure.exception();
                        throw new AnalysisException(e2.getCause().getMessage(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                Expression expression2 = e = (Expression)success.value();
                expression = expression2;
            } else {
                Expression e;
                Seq params = (Seq)Seq$.MODULE$.fill(expressions.size(), (Function0 & Serializable & scala.Serializable)() -> Expression.class);
                Constructor f = (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ExpressionUtils$.$anonfun$expression$7(params, x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    int[] validParametersCount = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])constructors)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ExpressionUtils$.$anonfun$expression$9(x$5))))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.getParameterCount()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).distinct())).sorted((Ordering)Ordering.Int$.MODULE$);
                    String expectedNumberOfParameters = validParametersCount.length == 1 ? new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(validParametersCount)).head().toString() : new StringBuilder(0).append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(validParametersCount)).init())).mkString("one of ", ", ", " and ")).append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(validParametersCount)).last()).toString();
                    throw new AnalysisException(new StringBuilder(62).append("Invalid number of arguments for function ").append(name).append(". ").append("Expected: ").append(expectedNumberOfParameters).append("; Found: ").append(params.length()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                });
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Expression)f.newInstance((Object[])expressions.toArray(ClassTag$.MODULE$.apply(Expression.class))));
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e3 = failure.exception();
                        throw new AnalysisException(e3.getCause().getMessage(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                Expression expression3 = e = (Expression)success.value();
                expression = expression3;
            }
            return expression;
        };
        return new Tuple2((Object)name, (Object)new Tuple2((Object)this.expressionInfo(name, tag), (Object)builder));
    }

    private <T extends Expression> ExpressionInfo expressionInfo(String name, ClassTag<T> evidence$1) {
        Class clazz = package$.MODULE$.classTag(evidence$1).runtimeClass();
        ExpressionDescription df = clazz.getAnnotation(ExpressionDescription.class);
        return df != null ? (df.extended().isEmpty() ? new ExpressionInfo(clazz.getCanonicalName(), null, name, df.usage(), df.arguments(), df.examples(), df.note(), "", df.since(), "", "") : new ExpressionInfo(clazz.getCanonicalName(), null, name, df.usage(), df.extended())) : new ExpressionInfo(clazz.getCanonicalName(), name);
    }

    public long preciseCountDistinctDecodeHelper(Object bytes) {
        byte[] storageBytes = (byte[])bytes;
        Roaring64NavigableMap roaringMap = BitmapSerAndDeSerObj$.MODULE$.deserialize(storageBytes);
        return roaringMap.getLongCardinality();
    }

    public long approxCountDistinctDecodeHelper(Object bytes, Object precision) {
        long l;
        byte[] storageFormat = (byte[])bytes;
        int preciseValue = BoxesRunTime.unboxToInt((Object)precision);
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(storageFormat)).nonEmpty()) {
            HLLCounter counter = new HLLCounter(preciseValue);
            counter.readRegisters(ByteBuffer.wrap(storageFormat));
            l = counter.getCountEstimate();
        } else {
            l = 0L;
        }
        return l;
    }

    public double percentileDecodeHelper(Object bytes, Object quantile, Object precision) {
        byte[] arrayBytes = (byte[])bytes;
        PercentileSerializer serializer = new PercentileSerializer(BoxesRunTime.unboxToInt((Object)precision));
        PercentileCounter counter = serializer.deserialize(ByteBuffer.wrap(arrayBytes));
        return Predef$.MODULE$.Double2double(counter.getResultEstimateWithQuantileRatio(((Decimal)quantile).toDouble()));
    }

    public Number sumLCDecodeHelper(Object bytes, Object wrapDataType) {
        byte[] arrayBytes = (byte[])bytes;
        NullSafeValueSerializer codec = SumLCUtil$.MODULE$.getNumericNullSafeSerializerByDataType(DataType$.MODULE$.fromJson(wrapDataType.toString()));
        SumLCCounter counter = SumLCUtil$.MODULE$.decodeToSumLCCounter(arrayBytes, codec);
        return counter == null ? (Number)null : (Number)counter.getSumLC();
    }

    public GenericArrayData bitmapUuidToArray(Object bytes) {
        byte[] bitmapbyte = (byte[])bytes;
        Roaring64NavigableMap bitmap = BitmapSerAndDeSer$.MODULE$.get().deserialize(bitmapbyte);
        int cardinality = bitmap.getIntCardinality();
        long[] longs = new long[cardinality];
        int id = 0;
        Iterator iterator = bitmap.iterator();
        while (iterator.hasNext()) {
            longs[id] = Predef$.MODULE$.Long2long((Long)iterator.next());
            ++id;
        }
        return new GenericArrayData(longs);
    }

    public static final /* synthetic */ boolean $anonfun$expression$2(int maxNumArgs$1, Constructor x$2) {
        return x$2.getParameterCount() == maxNumArgs$1;
    }

    public static final /* synthetic */ boolean $anonfun$expression$3(Constructor x$3) {
        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.getParameterTypes())).toSeq();
        .colon.colon colon2 = new .colon.colon(Seq.class, (List)Nil$.MODULE$);
        return !(seq != null ? !seq.equals(colon2) : colon2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$expression$7(Seq params$1, Constructor x$4) {
        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4.getParameterTypes())).toSeq();
        Seq seq2 = params$1;
        return !(seq != null ? !seq.equals(seq2) : seq2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$expression$10(Class x$6) {
        Class clazz = x$6;
        Class<Expression> clazz2 = Expression.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$expression$9(Constructor x$5) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5.getParameterTypes())).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ExpressionUtils$.$anonfun$expression$10(x$6)));
    }

    private ExpressionUtils$() {
        MODULE$ = this;
    }
}

