/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import org.apache.kylin.common.QueryTrace;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class QueryTraceTest {
    @Test
    public void test() throws InterruptedException {
        QueryTrace trace = new QueryTrace();
        trace.startSpan("span 1");
        Thread.sleep(100L);
        trace.startSpan("span 2");
        Thread.sleep(100L);
        trace.endLastSpan();
        Assert.assertEquals((long)2L, (long)trace.spans().size());
        Assert.assertTrue((boolean)trace.getLastSpan().isPresent());
        Assert.assertEquals((Object)"span 2", (Object)((QueryTrace.Span)trace.getLastSpan().get()).name);
        this.assertTimeEqual(100L, ((QueryTrace.Span)trace.getLastSpan().get()).duration);
        trace.amendLast("span 2", ((QueryTrace.Span)trace.getLastSpan().get()).start + ((QueryTrace.Span)trace.getLastSpan().get()).getDuration() + 1000L);
        this.assertTimeEqual(1100L, ((QueryTrace.Span)trace.getLastSpan().get()).duration);
        trace.startSpan("span 3");
        long duration = trace.calculateDuration("span 3", ((QueryTrace.Span)trace.getLastSpan().get()).start + ((QueryTrace.Span)trace.getLastSpan().get()).getDuration() + 1000L);
        this.assertTimeEqual(999L, duration);
    }

    @Test
    public void testGroups() {
        QueryTrace trace = new QueryTrace();
        trace.startSpan("GET_ACL_INFO");
        trace.startSpan("SQL_TRANSFORMATION");
        trace.startSpan("SQL_PARSE_AND_OPTIMIZE");
        trace.startSpan("MODEL_MATCHING");
        trace.startSpan("PREPARE_AND_SUBMIT_JOB");
        trace.startSpan("WAIT_FOR_EXECUTION");
        trace.startSpan("EXECUTION");
        trace.startSpan("FETCH_RESULT");
        trace.startSpan("SQL_PUSHDOWN_TRANSFORMATION");
        trace.startSpan("HIT_CACHE");
        trace.endLastSpan();
        for (QueryTrace.Span span : trace.spans()) {
            if ("PREPARATION".equals(span.getGroup()) || "JOB_EXECUTION".equals(span.getGroup())) {
                Assert.assertTrue((boolean)QueryTrace.SPAN_GROUPS.containsKey(span.getName()));
                continue;
            }
            Assert.assertFalse((boolean)QueryTrace.SPAN_GROUPS.containsKey(span.getName()));
        }
    }

    @Test
    public void testGroupsOfSPARK_JOB_EXECUTION() {
        QueryTrace trace = new QueryTrace();
        trace.startSpan("GET_ACL_INFO");
        trace.startSpan("SQL_TRANSFORMATION");
        trace.startSpan("SQL_PARSE_AND_OPTIMIZE");
        trace.startSpan("MODEL_MATCHING");
        trace.startSpan("SPARK_JOB_EXECUTION");
        trace.startSpan("SQL_PUSHDOWN_TRANSFORMATION");
        trace.startSpan("HIT_CACHE");
        trace.endLastSpan();
        for (QueryTrace.Span span : trace.spans()) {
            if ("PREPARATION".equals(span.getGroup())) {
                Assert.assertTrue((boolean)QueryTrace.SPAN_GROUPS.containsKey(span.getName()));
                continue;
            }
            Assert.assertFalse((boolean)QueryTrace.SPAN_GROUPS.containsKey(span.getName()));
        }
    }

    private void assertTimeEqual(long expected, long actual) {
        Assert.assertTrue((Math.abs(expected - actual) < 1000L ? 1 : 0) != 0);
    }
}

