/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.junit.annotation.MultiTimezoneTest;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtilTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TimeUtilTest.class);

    public static long normalizeTime(long timeMillis, NormalizedTimeUnit unit) {
        log.info(TimeZone.getDefault().toString());
        log.info(Locale.getDefault(Locale.Category.FORMAT).toString());
        Calendar a = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        Calendar b = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        b.clear();
        a.setTimeInMillis(timeMillis);
        if (unit == NormalizedTimeUnit.MINUTE) {
            b.set(a.get(1), a.get(2), a.get(5), a.get(11), a.get(12));
        } else if (unit == NormalizedTimeUnit.HOUR) {
            b.set(a.get(1), a.get(2), a.get(5), a.get(11), 0);
        }
        return b.getTimeInMillis();
    }

    @MultiTimezoneTest(timezones={"UTC", "GMT+8", "GMT+15"})
    public void basicTest() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
        dateFormat.setTimeZone(TimeZone.getDefault());
        long t1 = dateFormat.parse("2012/01/01 00:00:01").getTime();
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t1, NormalizedTimeUnit.HOUR), (long)TimeUtil.getHourStart((long)t1));
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t1, NormalizedTimeUnit.MINUTE), (long)TimeUtil.getMinuteStart((long)t1));
        long t2 = dateFormat.parse("2012/12/31 11:02:01").getTime();
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t2, NormalizedTimeUnit.HOUR), (long)TimeUtil.getHourStart((long)t2));
        Assert.assertEquals((long)TimeUtilTest.normalizeTime(t2, NormalizedTimeUnit.MINUTE), (long)TimeUtil.getMinuteStart((long)t2));
        long t3 = dateFormat.parse("2012/12/31 11:02:01").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/12/1 00:00:00").getTime(), (long)TimeUtil.getMonthStart((long)t3));
        Assert.assertEquals((long)dateFormat.parse("2012/10/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStart((long)t3));
        Assert.assertEquals((long)dateFormat.parse("2012/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStart((long)t3));
        Assert.assertEquals((long)dateFormat.parse("2012/12/30 00:00:00").getTime(), (long)TimeUtil.getWeekStart((long)t3));
        long t4 = dateFormat.parse("2012/12/32 00:00:00").getTime();
        Assert.assertEquals((long)dateFormat.parse("2012/12/32 00:00:00").getTime(), (long)TimeUtil.getDayStart((long)t4));
        long t5 = dateFormat.parse("2015/01/01 10:01:30").getTime();
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getMonthStart((long)t5));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getQuarterStart((long)t5));
        Assert.assertEquals((long)dateFormat.parse("2015/1/1 00:00:00").getTime(), (long)TimeUtil.getYearStart((long)t5));
        Assert.assertEquals((long)dateFormat.parse("2014/12/28 00:00:00").getTime(), (long)TimeUtil.getWeekStart((long)t5));
        Assert.assertEquals((long)86400000L, (long)TimeUtil.timeStringAs((String)"1d", (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @MultiTimezoneTest(timezones={"UTC", "GMT+8", "GMT+15"})
    public void summerTimeChangeTest() throws ParseException {
        log.info(Locale.getDefault(Locale.Category.FORMAT).toString());
        log.info(TimeZone.getDefault().toString());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
        dateFormat.setTimeZone(TimeZone.getDefault());
        long winterTime = dateFormat.parse("2019/11/3 03:30:00").getTime();
        long summerTime = dateFormat.parse("2019/11/3 00:00:00").getTime();
        Assert.assertEquals((long)summerTime, (long)TimeUtil.getDayStart((long)winterTime));
    }

    @MultiTimezoneTest(timezones={"UTC", "GMT+8", "GMT+15"})
    public void minusDaysTest() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
        dateFormat.setTimeZone(TimeZone.getDefault());
        long winterTime = dateFormat.parse("2019/11/5 09:40:00").getTime();
        long sevenDaysBeforeInSummerTime = dateFormat.parse("2019/10/29 09:40:00").getTime();
        Assert.assertEquals((long)sevenDaysBeforeInSummerTime, (long)TimeUtil.minusDays((long)winterTime, (int)7));
    }

    @MultiTimezoneTest(timezones={"UTC", "GMT+8", "GMT+15"})
    public void _ymdint_betweenTest() throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        dateFormat.setTimeZone(TimeZone.getDefault());
        long date1 = dateFormat.parse("1990-04-30").getTime();
        long date2 = dateFormat.parse("2003-02-05").getTime();
        Assert.assertEquals((Object)"120906", (Object)TimeUtil.ymdintBetween((long)date1, (long)date2));
        Assert.assertEquals((Object)"120905", (Object)TimeUtil.ymdintBetween((long)date2, (long)date1));
        long date3 = dateFormat.parse("2020-01-01").getTime();
        long date4 = dateFormat.parse("2021-01-01").getTime();
        Assert.assertEquals((Object)"10000", (Object)TimeUtil.ymdintBetween((long)date3, (long)date4));
        long date5 = dateFormat.parse("2022-01-01").getTime();
        Assert.assertEquals((Object)"10000", (Object)TimeUtil.ymdintBetween((long)date4, (long)date5));
    }

    public static enum NormalizedTimeUnit {
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

