/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.junit;

import java.util.TimeZone;
import lombok.Generated;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;

class TimezoneExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TimezoneExtension.class});
    private static final String KEY = "DefaultTimeZone";
    private String timezone;

    public void beforeEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        this.setDefaultTimeZone(store, this.timezone);
    }

    private void setDefaultTimeZone(ExtensionContext.Store store, String zoneId) {
        TimeZone defaultTimeZone = TimezoneExtension.createTimeZone(zoneId);
        this.storeDefaultTimeZone(store);
        TimeZone.setDefault(defaultTimeZone);
    }

    private static TimeZone createTimeZone(String timeZoneId) {
        TimeZone configuredTimeZone = TimeZone.getTimeZone(timeZoneId);
        if (configuredTimeZone.equals(TimeZone.getTimeZone("GMT")) && !timeZoneId.equals("GMT")) {
            throw new ExtensionConfigurationException(String.format("@DefaultTimeZone not configured correctly. Could not find the specified time zone + '%s'. Please use correct identifiers, e.g. \"GMT\" for Greenwich Mean Time.", timeZoneId));
        }
        return configuredTimeZone;
    }

    private void storeDefaultTimeZone(ExtensionContext.Store store) {
        store.put((Object)KEY, (Object)TimeZone.getDefault());
    }

    public void afterEach(ExtensionContext context) {
        this.resetDefaultTimeZone(context.getStore(NAMESPACE));
    }

    private void resetDefaultTimeZone(ExtensionContext.Store store) {
        TimeZone timeZone = (TimeZone)store.get((Object)KEY, TimeZone.class);
        if (timeZone != null) {
            TimeZone.setDefault(timeZone);
        }
    }

    @Generated
    public TimezoneExtension(String timezone) {
        this.timezone = timezone;
    }
}

