/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class SerializableMap<K, V>
implements Map<K, V>,
Serializable {
    private final Map<K, V> copiedMap = Maps.newHashMap();
    private volatile transient Map<K, V> immutableMap;

    SerializableMap() {
    }

    private SerializableMap(Map<K, V> map) {
        this.copiedMap.putAll(map);
    }

    public static <K, V> SerializableMap<K, V> copyOf(Map<K, V> map) {
        return map == null ? null : new SerializableMap<K, V>(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> immutableMap() {
        if (this.immutableMap == null) {
            SerializableMap serializableMap = this;
            synchronized (serializableMap) {
                if (this.immutableMap == null) {
                    this.immutableMap = Collections.unmodifiableMap(this.copiedMap);
                }
            }
        }
        return this.immutableMap;
    }

    @Override
    public int size() {
        return this.copiedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.copiedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.copiedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.copiedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.copiedMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.copiedMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.copiedMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.copiedMap.putAll(m);
    }

    @Override
    public void clear() {
        this.copiedMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.copiedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.copiedMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.copiedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.copiedMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.copiedMap.hashCode();
    }
}

