/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.DuplicateWAPCommitException;
import org.apache.iceberg.util.SnapshotUtil;

public class WapUtil {
    private WapUtil() {
    }

    public static String stagedWapId(Snapshot snapshot) {
        return snapshot.summary() != null ? (String)snapshot.summary().get("wap.id") : null;
    }

    public static String publishedWapId(Snapshot snapshot) {
        return snapshot.summary() != null ? (String)snapshot.summary().get("published-wap-id") : null;
    }

    public static String validateWapPublish(TableMetadata current, long wapSnapshotId) {
        Snapshot cherryPickSnapshot = current.snapshot(wapSnapshotId);
        String wapId = WapUtil.stagedWapId(cherryPickSnapshot);
        if (wapId != null && !wapId.isEmpty() && WapUtil.isWapIdPublished(current, wapId)) {
            throw new DuplicateWAPCommitException(wapId);
        }
        return wapId;
    }

    private static boolean isWapIdPublished(TableMetadata current, String wapId) {
        for (long ancestorId : SnapshotUtil.ancestorIds(current.currentSnapshot(), current::snapshot)) {
            Snapshot snapshot = current.snapshot(ancestorId);
            if (!wapId.equals(WapUtil.stagedWapId(snapshot)) && !wapId.equals(WapUtil.publishedWapId(snapshot))) continue;
            return true;
        }
        return false;
    }
}

