/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SQLViewRepresentation", generator="Immutables")
@Immutable
public final class ImmutableSQLViewRepresentation
implements SQLViewRepresentation {
    private final String sql;
    private final String dialect;

    private ImmutableSQLViewRepresentation(String sql, String dialect) {
        this.sql = sql;
        this.dialect = dialect;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public String dialect() {
        return this.dialect;
    }

    public final ImmutableSQLViewRepresentation withSql(String value) {
        String newValue = Objects.requireNonNull(value, "sql");
        if (this.sql.equals(newValue)) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(newValue, this.dialect);
    }

    public final ImmutableSQLViewRepresentation withDialect(String value) {
        String newValue = Objects.requireNonNull(value, "dialect");
        if (this.dialect.equals(newValue)) {
            return this;
        }
        return new ImmutableSQLViewRepresentation(this.sql, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSQLViewRepresentation && this.equalTo(0, (ImmutableSQLViewRepresentation)another);
    }

    private boolean equalTo(int synthetic, ImmutableSQLViewRepresentation another) {
        return this.sql.equals(another.sql) && this.dialect.equals(another.dialect);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sql.hashCode();
        h += (h << 5) + this.dialect.hashCode();
        return h;
    }

    public String toString() {
        return "SQLViewRepresentation{sql=" + this.sql + ", dialect=" + this.dialect + "}";
    }

    public static ImmutableSQLViewRepresentation copyOf(SQLViewRepresentation instance) {
        if (instance instanceof ImmutableSQLViewRepresentation) {
            return (ImmutableSQLViewRepresentation)instance;
        }
        return ImmutableSQLViewRepresentation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SQLViewRepresentation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SQL = 1L;
        private static final long INIT_BIT_DIALECT = 2L;
        private long initBits = 3L;
        @Nullable
        private String sql;
        @Nullable
        private String dialect;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SQLViewRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.sql(instance.sql());
            this.dialect(instance.dialect());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sql(String sql) {
            this.sql = Objects.requireNonNull(sql, "sql");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dialect(String dialect) {
            this.dialect = Objects.requireNonNull(dialect, "dialect");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSQLViewRepresentation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSQLViewRepresentation(this.sql, this.dialect);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sql");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dialect");
            }
            return "Cannot build SQLViewRepresentation, some of required attributes are not set " + attributes;
        }
    }
}

