/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.view.ImmutableViewHistoryEntry;
import org.apache.iceberg.view.ImmutableViewMetadata;
import org.apache.iceberg.view.ImmutableViewVersion;
import org.apache.iceberg.view.ViewHistoryEntry;
import org.apache.iceberg.view.ViewVersion;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable(builder=false)
@Value.Style(allParameters=true, visibility=Value.Style.ImplementationVisibility.PACKAGE)
public interface ViewMetadata
extends Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(ViewMetadata.class);
    public static final int SUPPORTED_VIEW_FORMAT_VERSION = 1;
    public static final int DEFAULT_VIEW_FORMAT_VERSION = 1;

    public String uuid();

    public int formatVersion();

    public String location();

    default public Integer currentSchemaId() {
        int currentSchemaId = this.currentVersion().schemaId();
        Preconditions.checkArgument((boolean)this.schemasById().containsKey(currentSchemaId), (String)"Cannot find current schema with id %s in schemas: %s", (int)currentSchemaId, this.schemasById().keySet());
        return currentSchemaId;
    }

    public List<Schema> schemas();

    public int currentVersionId();

    public List<ViewVersion> versions();

    public List<ViewHistoryEntry> history();

    public Map<String, String> properties();

    public List<MetadataUpdate> changes();

    @Nullable
    public String metadataFileLocation();

    default public ViewVersion version(int versionId) {
        return this.versionsById().get(versionId);
    }

    default public ViewVersion currentVersion() {
        Preconditions.checkArgument((boolean)this.versionsById().containsKey(this.currentVersionId()), (String)"Cannot find current version %s in view versions: %s", (int)this.currentVersionId(), this.versionsById().keySet());
        return this.versionsById().get(this.currentVersionId());
    }

    @Value.Derived
    default public Map<Integer, ViewVersion> versionsById() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ViewVersion version : this.versions()) {
            builder.put((Object)version.versionId(), (Object)version);
        }
        return builder.build();
    }

    @Value.Derived
    default public Map<Integer, Schema> schemasById() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Schema schema : this.schemas()) {
            builder.put((Object)schema.schemaId(), (Object)schema);
        }
        return builder.build();
    }

    default public Schema schema() {
        return this.schemasById().get(this.currentSchemaId());
    }

    @Value.Check
    default public void check() {
        Preconditions.checkArgument((this.formatVersion() > 0 && this.formatVersion() <= 1 ? 1 : 0) != 0, (String)"Unsupported format version: %s", (int)this.formatVersion());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder buildFrom(ViewMetadata base) {
        return new Builder(base);
    }

    public static class Builder {
        private static final int LAST_ADDED = -1;
        private final List<ViewVersion> versions;
        private final List<Schema> schemas;
        private final List<ViewHistoryEntry> history;
        private final Map<String, String> properties;
        private final List<MetadataUpdate> changes;
        private int formatVersion = 1;
        private int currentVersionId;
        private String location;
        private String uuid;
        private String metadataLocation;
        private Integer lastAddedVersionId = null;
        private final Map<Integer, ViewVersion> versionsById;
        private final Map<Integer, Schema> schemasById;

        private Builder() {
            this.versions = Lists.newArrayList();
            this.versionsById = Maps.newHashMap();
            this.schemas = Lists.newArrayList();
            this.schemasById = Maps.newHashMap();
            this.history = Lists.newArrayList();
            this.properties = Maps.newHashMap();
            this.changes = Lists.newArrayList();
            this.uuid = null;
        }

        private Builder(ViewMetadata base) {
            this.versions = Lists.newArrayList(base.versions());
            this.versionsById = Maps.newHashMap(base.versionsById());
            this.schemas = Lists.newArrayList(base.schemas());
            this.schemasById = Maps.newHashMap(base.schemasById());
            this.history = Lists.newArrayList(base.history());
            this.properties = Maps.newHashMap(base.properties());
            this.changes = Lists.newArrayList();
            this.formatVersion = base.formatVersion();
            this.currentVersionId = base.currentVersionId();
            this.location = base.location();
            this.uuid = base.uuid();
            this.metadataLocation = null;
        }

        public Builder upgradeFormatVersion(int newFormatVersion) {
            Preconditions.checkArgument((newFormatVersion >= this.formatVersion ? 1 : 0) != 0, (String)"Cannot downgrade v%s view to v%s", (int)this.formatVersion, (int)newFormatVersion);
            if (this.formatVersion == newFormatVersion) {
                return this;
            }
            this.formatVersion = newFormatVersion;
            this.changes.add(new MetadataUpdate.UpgradeFormatVersion(newFormatVersion));
            return this;
        }

        public Builder setLocation(String newLocation) {
            Preconditions.checkArgument((null != newLocation ? 1 : 0) != 0, (Object)"Invalid location: null");
            if (null != this.location && this.location.equals(newLocation)) {
                return this;
            }
            this.location = newLocation;
            this.changes.add(new MetadataUpdate.SetLocation(newLocation));
            return this;
        }

        public Builder setMetadataLocation(String newMetadataLocation) {
            this.metadataLocation = newMetadataLocation;
            return this;
        }

        public Builder setCurrentVersionId(int newVersionId) {
            if (newVersionId == -1) {
                ValidationException.check((this.lastAddedVersionId != null ? 1 : 0) != 0, (String)"Cannot set last version id: no current version id has been set", (Object[])new Object[0]);
                return this.setCurrentVersionId(this.lastAddedVersionId);
            }
            if (this.currentVersionId == newVersionId) {
                return this;
            }
            ViewVersion version = this.versionsById.get(newVersionId);
            Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Cannot set current version to unknown version: %s", (int)newVersionId);
            this.currentVersionId = newVersionId;
            if (this.lastAddedVersionId != null && this.lastAddedVersionId == newVersionId) {
                this.changes.add(new MetadataUpdate.SetCurrentViewVersion(-1));
            } else {
                this.changes.add(new MetadataUpdate.SetCurrentViewVersion(newVersionId));
            }
            return this;
        }

        public Builder setCurrentVersion(ViewVersion version, Schema schema) {
            int newSchemaId = this.addSchemaInternal(schema);
            ImmutableViewVersion newVersion = ImmutableViewVersion.builder().from(version).schemaId(newSchemaId).build();
            return this.setCurrentVersionId(this.addVersionInternal(newVersion));
        }

        public Builder addVersion(ViewVersion version) {
            this.addVersionInternal(version);
            return this;
        }

        private int addVersionInternal(ViewVersion version) {
            int newVersionId = this.reuseOrCreateNewViewVersionId(version);
            if (this.versionsById.containsKey(newVersionId)) {
                boolean addedInBuilder = this.changes(MetadataUpdate.AddViewVersion.class).anyMatch(added -> added.viewVersion().versionId() == newVersionId);
                this.lastAddedVersionId = addedInBuilder ? Integer.valueOf(newVersionId) : null;
                return newVersionId;
            }
            Preconditions.checkArgument((boolean)this.schemasById.containsKey(version.schemaId()), (String)"Cannot add version with unknown schema: %s", (int)version.schemaId());
            ViewVersion newVersion = newVersionId != version.versionId() ? ImmutableViewVersion.builder().from(version).versionId(newVersionId).build() : version;
            this.versions.add(newVersion);
            this.versionsById.put(newVersion.versionId(), newVersion);
            this.changes.add(new MetadataUpdate.AddViewVersion(newVersion));
            this.history.add(ImmutableViewHistoryEntry.builder().timestampMillis(newVersion.timestampMillis()).versionId(newVersion.versionId()).build());
            this.lastAddedVersionId = newVersionId;
            return newVersionId;
        }

        private int reuseOrCreateNewViewVersionId(ViewVersion viewVersion) {
            int newVersionId = viewVersion.versionId();
            for (ViewVersion version : this.versions) {
                if (version.equals(viewVersion)) {
                    return version.versionId();
                }
                if (version.versionId() < newVersionId) continue;
                newVersionId = viewVersion.versionId() + 1;
            }
            return newVersionId;
        }

        public Builder addSchema(Schema schema) {
            this.addSchemaInternal(schema);
            return this;
        }

        private int addSchemaInternal(Schema schema) {
            int newSchemaId = this.reuseOrCreateNewSchemaId(schema);
            if (this.schemasById.containsKey(newSchemaId)) {
                return newSchemaId;
            }
            Schema newSchema = newSchemaId != schema.schemaId() ? new Schema(newSchemaId, schema.columns(), schema.identifierFieldIds()) : schema;
            int highestFieldId = Math.max(this.highestFieldId(), newSchema.highestFieldId());
            this.schemas.add(newSchema);
            this.schemasById.put(newSchema.schemaId(), newSchema);
            this.changes.add(new MetadataUpdate.AddSchema(newSchema, highestFieldId));
            return newSchemaId;
        }

        private int highestFieldId() {
            return this.schemas.stream().map(Schema::highestFieldId).max(Integer::compareTo).orElse(0);
        }

        private int reuseOrCreateNewSchemaId(Schema newSchema) {
            int newSchemaId = newSchema.schemaId();
            for (Schema schema : this.schemas) {
                if (schema.sameSchema(newSchema)) {
                    return schema.schemaId();
                }
                if (schema.schemaId() < newSchemaId) continue;
                newSchemaId = schema.schemaId() + 1;
            }
            return newSchemaId;
        }

        public Builder setProperties(Map<String, String> updated) {
            if (updated.isEmpty()) {
                return this;
            }
            this.properties.putAll(updated);
            this.changes.add(new MetadataUpdate.SetProperties(updated));
            return this;
        }

        public Builder removeProperties(Set<String> propertiesToRemove) {
            if (propertiesToRemove.isEmpty()) {
                return this;
            }
            propertiesToRemove.forEach(this.properties::remove);
            this.changes.add(new MetadataUpdate.RemoveProperties(propertiesToRemove));
            return this;
        }

        public Builder assignUUID(String newUUID) {
            Preconditions.checkArgument((newUUID != null ? 1 : 0) != 0, (Object)"Cannot set uuid to null");
            Preconditions.checkArgument((this.uuid == null || newUUID.equals(this.uuid) ? 1 : 0) != 0, (Object)"Cannot reassign uuid");
            if (!newUUID.equals(this.uuid)) {
                this.uuid = newUUID;
                this.changes.add(new MetadataUpdate.AssignUUID(this.uuid));
            }
            return this;
        }

        public ViewMetadata build() {
            List<ViewHistoryEntry> retainedHistory;
            List<ViewVersion> retainedVersions;
            Preconditions.checkArgument((null != this.location ? 1 : 0) != 0, (Object)"Invalid location: null");
            Preconditions.checkArgument((this.versions.size() > 0 ? 1 : 0) != 0, (Object)"Invalid view: no versions were added");
            Preconditions.checkArgument((this.metadataLocation == null || this.changes.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create view metadata with a metadata location and changes");
            int historySize = PropertyUtil.propertyAsInt(this.properties, "version.history.num-entries", 10);
            Preconditions.checkArgument((historySize > 0 ? 1 : 0) != 0, (String)"%s must be positive but was %s", (Object)"version.history.num-entries", (int)historySize);
            int numAddedVersions = (int)this.changes(MetadataUpdate.AddViewVersion.class).count();
            int numVersionsToKeep = Math.max(numAddedVersions, historySize);
            if (this.versions.size() > numVersionsToKeep) {
                retainedVersions = Builder.expireVersions(this.versionsById, numVersionsToKeep);
                Set<Integer> retainedVersionIds = retainedVersions.stream().map(ViewVersion::versionId).collect(Collectors.toSet());
                retainedHistory = Builder.updateHistory(this.history, retainedVersionIds);
            } else {
                retainedVersions = this.versions;
                retainedHistory = this.history;
            }
            return ImmutableViewMetadata.of(null == this.uuid ? UUID.randomUUID().toString() : this.uuid, this.formatVersion, this.location, this.schemas, this.currentVersionId, retainedVersions, retainedHistory, this.properties, this.changes, this.metadataLocation);
        }

        static List<ViewVersion> expireVersions(Map<Integer, ViewVersion> versionsById, int numVersionsToKeep) {
            ArrayList ids = Lists.newArrayList(versionsById.keySet());
            ids.sort(Comparator.reverseOrder());
            ArrayList retainedVersions = Lists.newArrayList();
            Iterator iterator = ids.subList(0, numVersionsToKeep).iterator();
            while (iterator.hasNext()) {
                int idToKeep = (Integer)iterator.next();
                retainedVersions.add(versionsById.get(idToKeep));
            }
            return retainedVersions;
        }

        static List<ViewHistoryEntry> updateHistory(List<ViewHistoryEntry> history, Set<Integer> ids) {
            ArrayList retainedHistory = Lists.newArrayList();
            for (ViewHistoryEntry entry : history) {
                if (ids.contains(entry.versionId())) {
                    retainedHistory.add(entry);
                    continue;
                }
                retainedHistory.clear();
            }
            return retainedHistory;
        }

        private <U extends MetadataUpdate> Stream<U> changes(Class<U> updateClass) {
            return this.changes.stream().filter(updateClass::isInstance).map(updateClass::cast);
        }
    }
}

