/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="default")
public class DefaultModelDependencyProvider
implements ModelDependencyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModelDependencyProvider.class);
    private final TypeResolver typeResolver;
    private final ModelPropertiesProvider propertiesProvider;
    private final TypeNameExtractor nameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final SchemaPluginsManager schemaPluginsManager;

    @Autowired
    public DefaultModelDependencyProvider(TypeResolver typeResolver, @Qualifier(value="cachedModelProperties") ModelPropertiesProvider propertiesProvider, TypeNameExtractor nameExtractor, EnumTypeDeterminer enumTypeDeterminer, SchemaPluginsManager schemaPluginsManager) {
        this.typeResolver = typeResolver;
        this.propertiesProvider = propertiesProvider;
        this.nameExtractor = nameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.schemaPluginsManager = schemaPluginsManager;
    }

    @Override
    public Set<ResolvedType> dependentModels(ModelContext modelContext) {
        return Stream.concat(this.resolvedDependencies(modelContext).stream().filter(this.ignorableTypes(modelContext)).filter(this.baseTypes(modelContext).negate()), this.schemaPluginsManager.dependencies(modelContext).stream()).collect(Collectors.toSet());
    }

    private Predicate<ResolvedType> baseTypes(ModelContext modelContext) {
        return resolvedType -> this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType));
    }

    private boolean isBaseType(ModelContext modelContext) {
        String typeName = this.nameExtractor.typeName(modelContext);
        return Types.isBaseType(typeName);
    }

    private Predicate<ResolvedType> ignorableTypes(ModelContext modelContext) {
        return input -> !modelContext.hasSeenBefore(input);
    }

    private Set<ResolvedType> resolvedDependencies(ModelContext modelContext) {
        ResolvedType resolvedType = modelContext.alternateEvaluatedType();
        if (this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType))) {
            LOG.debug("Marking base type {} as seen", (Object)resolvedType.getSignature());
            modelContext.seen(resolvedType);
            return new HashSet<ResolvedType>();
        }
        HashSet<ResolvedType> dependencies = new HashSet<ResolvedType>(this.resolvedTypeParameters(modelContext, resolvedType));
        dependencies.addAll(this.resolvedArrayElementType(modelContext, resolvedType));
        dependencies.addAll(this.resolvedMapType(modelContext, resolvedType));
        dependencies.addAll(this.resolvedSubclasses(modelContext, resolvedType));
        dependencies.addAll(this.resolvedPropertiesAndFields(modelContext, resolvedType));
        return dependencies;
    }

    private Collection<ResolvedType> resolvedSubclasses(ModelContext modelContext, ResolvedType resolvedType) {
        JsonSubTypes subTypes = (JsonSubTypes)AnnotationUtils.findAnnotation((Class)resolvedType.getErasedType(), JsonSubTypes.class);
        ArrayList<ResolvedType> subclasses = new ArrayList<ResolvedType>();
        if (subTypes != null) {
            for (JsonSubTypes.Type each : subTypes.value()) {
                ResolvedType type = this.typeResolver.resolve((Type)each.value(), new Type[0]);
                subclasses.add(modelContext.alternateFor(type));
                subclasses.addAll(this.resolvedPropertiesAndFields(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)type), type));
            }
        }
        return subclasses;
    }

    private Collection<ResolvedType> resolvedMapType(ModelContext modelContext, ResolvedType resolvedType) {
        ResolvedType mapType = resolvedType.findSupertype(Map.class);
        if (mapType == null) {
            return new ArrayList<ResolvedType>();
        }
        return this.resolvedTypeParameters(modelContext, mapType);
    }

    private List<ResolvedType> resolvedArrayElementType(ModelContext modelContext, ResolvedType resolvedType) {
        ArrayList<ResolvedType> parameters = new ArrayList<ResolvedType>();
        if (resolvedType.isArray()) {
            ResolvedType elementType = resolvedType.getArrayElementType();
            LOG.debug("Adding type for element {}", (Object)elementType.getSignature());
            parameters.add(modelContext.alternateFor(elementType));
            LOG.debug("Recursively resolving dependencies for element {}", (Object)elementType.getSignature());
            parameters.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)elementType)));
        }
        return parameters;
    }

    private Set<ResolvedType> resolvedTypeParameters(ModelContext modelContext, ResolvedType resolvedType) {
        HashSet<ResolvedType> parameters = new HashSet<ResolvedType>();
        for (ResolvedType parameter : resolvedType.getTypeParameters()) {
            LOG.debug("Adding type for parameter {}", (Object)parameter.getSignature());
            parameters.add(modelContext.alternateFor(parameter));
            LOG.debug("Recursively resolving dependencies for parameter {}", (Object)parameter.getSignature());
            parameters.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)parameter)));
        }
        return parameters;
    }

    private Set<ResolvedType> resolvedPropertiesAndFields(ModelContext modelContext, ResolvedType resolvedType) {
        if (modelContext.hasSeenBefore(resolvedType) || this.enumTypeDeterminer.isEnum(resolvedType.getErasedType())) {
            return new HashSet<ResolvedType>();
        }
        modelContext.seen(resolvedType);
        HashSet<ResolvedType> properties = new HashSet<ResolvedType>();
        for (ModelProperty property : this.nonTrivialProperties(modelContext, resolvedType)) {
            LOG.debug("Adding type {} for parameter {}", (Object)property.getType().getSignature(), (Object)property.getName());
            if (!Maps.isMapType(property.getType())) {
                properties.add(property.getType());
            }
            properties.addAll(this.maybeFromCollectionElementType(modelContext, property));
            properties.addAll(this.maybeFromMapValueType(modelContext, property));
            properties.addAll(this.maybeFromRegularType(modelContext, property));
        }
        return properties;
    }

    private Collection<ModelProperty> nonTrivialProperties(ModelContext modelContext, ResolvedType resolvedType) {
        return this.propertiesFor(modelContext, resolvedType).stream().filter(this.baseProperty(modelContext).negate()).collect(Collectors.toList());
    }

    private Predicate<? super ModelProperty> baseProperty(ModelContext modelContext) {
        return input -> this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)input.getType()));
    }

    private List<ResolvedType> maybeFromRegularType(ModelContext modelContext, ModelProperty property) {
        if (Collections.isContainerType(property.getType()) || Maps.isMapType(property.getType())) {
            return new ArrayList<ResolvedType>();
        }
        LOG.debug("Recursively resolving dependencies for type {}", (Object)ResolvedTypes.resolvedTypeSignature(property.getType()).orElse("<null>"));
        return new ArrayList<ResolvedType>(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)property.getType())));
    }

    private List<ResolvedType> maybeFromCollectionElementType(ModelContext modelContext, ModelProperty property) {
        ArrayList<ResolvedType> dependencies = new ArrayList<ResolvedType>();
        if (Collections.isContainerType(property.getType())) {
            ResolvedType collectionElementType = Collections.collectionElementType(property.getType());
            String resolvedTypeSignature = ResolvedTypes.resolvedTypeSignature(collectionElementType).orElse("<null>");
            if (!this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType))) {
                LOG.debug("Adding collectionElement type {}", (Object)resolvedTypeSignature);
                dependencies.add(collectionElementType);
            }
            LOG.debug("Recursively resolving dependencies for collectionElement type {}", (Object)resolvedTypeSignature);
            dependencies.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)collectionElementType)));
        }
        return dependencies;
    }

    private List<ResolvedType> maybeFromMapValueType(ModelContext modelContext, ModelProperty property) {
        ArrayList<ResolvedType> dependencies = new ArrayList<ResolvedType>();
        if (Maps.isMapType(property.getType())) {
            ResolvedType valueType = Maps.mapValueType(property.getType());
            String resolvedTypeSignature = ResolvedTypes.resolvedTypeSignature(valueType).orElse("<null>");
            if (!this.isBaseType(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)valueType))) {
                LOG.debug("Adding value type {}", (Object)resolvedTypeSignature);
                dependencies.add(valueType);
            }
            LOG.debug("Recursively resolving dependencies for value type {}", (Object)resolvedTypeSignature);
            dependencies.addAll(this.resolvedDependencies(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)valueType)));
        }
        return dependencies;
    }

    private List<ModelProperty> propertiesFor(ModelContext modelContext, ResolvedType resolvedType) {
        return this.propertiesProvider.propertiesFor(resolvedType, modelContext);
    }
}

