/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.data;

import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.engine.exec.ExecuteResult;

public class QueryResult {
    private Iterable<List<String>> rows;
    private List<List<String>> rowsList;
    private int size;
    private List<StructField> columns;
    private List<SelectedColumnMeta> columnMetas;

    public QueryResult() {
        this(new LinkedList<List<String>>(), 0, new LinkedList<StructField>());
    }

    public QueryResult(ExecuteResult result, List<StructField> columns) {
        this.rows = result.getRows();
        this.size = result.getSize();
        this.columns = columns;
    }

    public QueryResult(Iterable<List<String>> rows, int size, List<StructField> columns) {
        this.rows = rows;
        this.columns = columns;
        this.size = size;
    }

    public QueryResult(Iterable<List<String>> rows, int size, List<StructField> columns, List<SelectedColumnMeta> columnMetas) {
        this.rows = rows;
        this.size = size;
        this.columns = columns;
        this.columnMetas = columnMetas;
    }

    @Deprecated
    public List<List<String>> getRows() {
        if (this.rowsList == null) {
            this.rowsList = ImmutableList.copyOf(this.rows);
        }
        return this.rowsList;
    }

    public Iterable<List<String>> getRowsIterable() {
        return this.rows;
    }

    public int getSize() {
        return this.size;
    }

    public List<StructField> getColumns() {
        return this.columns;
    }

    public List<SelectedColumnMeta> getColumnMetas() {
        if (this.columnMetas != null) {
            return this.columnMetas;
        }
        this.columnMetas = new LinkedList<SelectedColumnMeta>();
        int columnCount = this.columns.size();
        List<StructField> fieldList = this.columns;
        for (int i = 0; i < columnCount; ++i) {
            int nullable = fieldList.get(i).isNullable() ? 1 : 0;
            this.columnMetas.add(new SelectedColumnMeta(false, false, false, false, nullable, true, fieldList.get(i).getPrecision(), fieldList.get(i).getName(), fieldList.get(i).getName(), null, null, null, fieldList.get(i).getPrecision(), fieldList.get(i).getScale(), fieldList.get(i).getDataType(), fieldList.get(i).getDataTypeName(), false, false, false));
        }
        return this.columnMetas;
    }
}

