/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.acl.AclTCR;
import org.apache.kylin.metadata.acl.AclTCRManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.source.adhocquery.IPushDownConverter;

public class HackSelectStarWithColumnACL
implements IQueryTransformer,
IPushDownConverter {
    private static boolean hasAdminPermission(QueryContext.AclInfo aclInfo) {
        if (Objects.isNull(aclInfo) || Objects.isNull(aclInfo.getGroups())) {
            return false;
        }
        return aclInfo.getGroups().stream().anyMatch("ROLE_ADMIN"::equals) || aclInfo.isHasAdminPermission();
    }

    public String convert(String originSql, String project, String defaultSchema) {
        return this.transform(originSql, project, defaultSchema);
    }

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        SqlNode sqlNode;
        QueryContext.AclInfo aclLocal = QueryContext.current().getAclInfo();
        if (!KylinConfig.getInstanceFromEnv().isAclTCREnabled() || HackSelectStarWithColumnACL.hasAdminPermission(aclLocal)) {
            return sql;
        }
        try {
            sqlNode = CalciteParser.parse((String)sql, (String)project);
        }
        catch (SqlParseException e) {
            throw new KylinRuntimeException("Failed to parse invalid SQL: " + sql);
        }
        SelectStarAuthVisitor replacer = new SelectStarAuthVisitor(project, defaultSchema, aclLocal);
        sqlNode.accept((SqlVisitor)replacer);
        Map<SqlNode, String> resolved = replacer.getResolved();
        if (resolved.isEmpty()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        AtomicInteger offset = new AtomicInteger(0);
        resolved.forEach((node, replaced) -> {
            Pair replacePos = CalciteParser.getReplacePos((SqlNode)node, (String)sql);
            sb.append(sql, offset.get(), (int)((Integer)replacePos.getKey()));
            sb.append((String)replaced);
            offset.set((Integer)replacePos.getValue());
        });
        sb.append(sql.substring(offset.get()));
        return sb.toString();
    }

    static class SelectStarAuthVisitor
    extends SqlBasicVisitor<SqlNode> {
        Map<SqlNode, String> resolved = new LinkedHashMap<SqlNode, String>();
        private final Map<String, String> tableToReplacedSubQuery = new HashMap<String, String>();
        private final Set<String> namesOfWithItems = new HashSet<String>();
        private final String defaultSchema;
        private final List<AclTCR> aclTCRList;
        private final NTableMetadataManager tableMgr;
        private final boolean sourceNameCaseSensitiveEnabled;
        private final boolean isPushdownSelectStarCaseSensitiveEnable;
        private final boolean isPushdownSelectStarLowerCaseEnable;

        SelectStarAuthVisitor(String project, String defaultSchema, QueryContext.AclInfo aclInfo) {
            this.defaultSchema = defaultSchema;
            KylinConfig config = NProjectManager.getProjectConfig((String)project);
            this.sourceNameCaseSensitiveEnabled = config.getSourceNameCaseSensitiveEnabled();
            this.isPushdownSelectStarCaseSensitiveEnable = config.getPushdownSelectStarCaseSensitiveEnable();
            this.isPushdownSelectStarLowerCaseEnable = config.getPushdownSelectStarLowercaseEnable();
            this.tableMgr = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
            String user = Objects.nonNull(aclInfo) ? aclInfo.getUsername() : null;
            Set groups = Objects.nonNull(aclInfo) ? aclInfo.getGroups() : null;
            this.aclTCRList = AclTCRManager.getInstance((KylinConfig)config, (String)project).getAclTCRs(user, groups);
        }

        public SqlNode visit(SqlNodeList nodeList) {
            for (SqlNode node : nodeList) {
                if (node instanceof SqlWithItem) {
                    SqlWithItem item = (SqlWithItem)node;
                    item.query.accept((SqlVisitor)this);
                    this.namesOfWithItems.add(item.name.toString());
                    continue;
                }
                if (!(node instanceof SqlCall)) continue;
                node.accept((SqlVisitor)this);
            }
            return null;
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                SqlSelect select = (SqlSelect)call;
                select.getSelectList().accept((SqlVisitor)this);
                this.markCall(select.getFrom());
            }
            if (call instanceof SqlBasicCall) {
                SqlBasicCall basicCall = (SqlBasicCall)call;
                basicCall.getOperandList().stream().filter(Objects::nonNull).forEach(node -> {
                    SqlNode cfr_ignored_0 = (SqlNode)node.accept((SqlVisitor)this);
                });
            }
            if (call instanceof SqlJoin) {
                this.markCall(((SqlJoin)call).getLeft());
                this.markCall(((SqlJoin)call).getRight());
            }
            if (call instanceof SqlWith) {
                SqlWith sqlWith = (SqlWith)call;
                sqlWith.withList.accept((SqlVisitor)this);
                sqlWith.body.accept((SqlVisitor)this);
            }
            if (call instanceof SqlOrderBy) {
                call.getOperandList().stream().filter(Objects::nonNull).forEach(node -> {
                    SqlNode cfr_ignored_0 = (SqlNode)node.accept((SqlVisitor)this);
                });
            }
            return null;
        }

        private void markCall(SqlNode operand) {
            if (Objects.isNull(operand)) {
                return;
            }
            if (operand instanceof SqlIdentifier) {
                String replaced = this.markTableIdentifier((SqlIdentifier)operand, null);
                this.resolved.put(operand, replaced);
                return;
            }
            if (this.isCallWithAlias(operand)) {
                List operandList = ((SqlBasicCall)operand).getOperandList();
                SqlNode tableNode = (SqlNode)operandList.get(0);
                if (tableNode instanceof SqlIdentifier) {
                    String replaced = this.markTableIdentifier((SqlIdentifier)tableNode, (SqlNode)operandList.get(1));
                    this.resolved.put(operand, replaced);
                } else {
                    tableNode.accept((SqlVisitor)this);
                }
                return;
            }
            operand.accept((SqlVisitor)this);
        }

        private boolean isCallWithAlias(SqlNode from) {
            return from instanceof SqlBasicCall && from.getKind() == SqlKind.AS;
        }

        private String markTableIdentifier(SqlIdentifier operand, SqlNode alias) {
            TableDesc tableDesc;
            if (this.namesOfWithItems.contains(operand.toString())) {
                String withItemName = StringHelper.doubleQuote((String)operand.toString());
                return alias == null ? withItemName : withItemName + " as " + StringHelper.doubleQuote((String)alias.toString());
            }
            ImmutableList names = operand.names;
            String schema = names.size() == 1 ? this.defaultSchema : (String)names.get(0);
            String table = names.size() == 1 ? (String)names.get(0) : (String)names.get(1);
            String tableMetadataKey = schema + '.' + table;
            if (!this.sourceNameCaseSensitiveEnabled) {
                tableMetadataKey = tableMetadataKey.toUpperCase(Locale.ROOT);
            }
            if ((tableDesc = this.tableMgr.getTableDesc(tableMetadataKey)) == null) {
                throw new KylinRuntimeException("Failed to parse table: " + operand);
            }
            String subQueryAlias = alias == null ? StringHelper.doubleQuote((String)table) : StringHelper.doubleQuote((String)alias.toString());
            String tableIdentity = tableDesc.getDoubleQuoteIdentity();
            String tableToReplacedSubQueryKey = tableIdentity + subQueryAlias;
            if (this.tableToReplacedSubQuery.containsKey(tableToReplacedSubQueryKey)) {
                return this.tableToReplacedSubQuery.get(tableToReplacedSubQueryKey);
            }
            List<String> authorizedCols = this.getAuthorizedCols(tableDesc);
            String replacedSubQuery = "( select " + String.join((CharSequence)", ", authorizedCols) + " from " + tableIdentity + ") as " + subQueryAlias;
            this.tableToReplacedSubQuery.put(tableToReplacedSubQueryKey, replacedSubQuery);
            return replacedSubQuery;
        }

        List<String> getAuthorizedCols(TableDesc tableDesc) {
            ArrayList<String> colList = new ArrayList<String>();
            List columns = Arrays.stream(tableDesc.getColumns()).sorted(Comparator.comparing(ColumnDesc::getZeroBasedIndex)).collect(Collectors.toList());
            block0: for (ColumnDesc column : columns) {
                for (AclTCR aclTCR : this.aclTCRList) {
                    if (!aclTCR.isAuthorized(tableDesc.getIdentity(), column.getName())) continue;
                    colList.add(this.getQuotedColName(column));
                    continue block0;
                }
            }
            return colList;
        }

        String getQuotedColName(ColumnDesc column) {
            if (this.isPushdownSelectStarLowerCaseEnable) {
                return StringHelper.doubleQuote((String)column.getTable().getName()) + "." + StringHelper.doubleQuote((String)StringUtils.lowerCase((String)column.getName()));
            }
            if (this.isPushdownSelectStarCaseSensitiveEnable) {
                return StringHelper.doubleQuote((String)column.getTable().getName()) + "." + StringHelper.doubleQuote((String)column.getCaseSensitiveName());
            }
            return StringHelper.doubleQuote((String)column.getTable().getName()) + "." + StringHelper.doubleQuote((String)column.getName());
        }

        @Generated
        public Map<SqlNode, String> getResolved() {
            return this.resolved;
        }
    }
}

