/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.source.adhocquery.IPushDownConverter;

public class CognosParenthesesEscapeTransformer
implements IQueryTransformer,
IPushDownConverter {
    private static final Pattern FROM_PATTERN = Pattern.compile("\\bfrom(\\s*\\()+(?!\\s*select\\s)", 2);

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        return StringUtils.isEmpty((CharSequence)sql) ? sql : this.completion(sql);
    }

    String completion(String sql) {
        Map<Integer, Integer> parenthesesPairs = this.findParenthesesPairs(sql);
        if (parenthesesPairs.isEmpty()) {
            return sql;
        }
        ArrayList parentheses = Lists.newArrayList();
        String originSql = sql;
        int offset = 0;
        boolean done = false;
        while (!done) {
            Matcher m = FROM_PATTERN.matcher(sql);
            if (m.find()) {
                for (int i = m.end() - 1; i > m.start(); --i) {
                    if (sql.charAt(i) != '(') continue;
                    parentheses.add(i + offset);
                }
                if (m.end() < sql.length()) {
                    offset += m.end();
                    sql = sql.substring(m.end());
                    continue;
                }
            }
            done = true;
        }
        ArrayList indices = Lists.newArrayList();
        parentheses.forEach(index -> {
            indices.add(index);
            indices.add(parenthesesPairs.get(index));
        });
        indices.sort(Integer::compareTo);
        StringBuilder builder = new StringBuilder();
        int lastIndex = 0;
        for (Integer i : indices) {
            builder.append(originSql, lastIndex, (int)i);
            lastIndex = i + 1;
        }
        builder.append(originSql, lastIndex, originSql.length());
        return builder.toString();
    }

    private Map<Integer, Integer> findParenthesesPairs(String sql) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (sql.length() > 1) {
            ArrayDeque<Integer> lStack = new ArrayDeque<Integer>();
            boolean inStrVal = false;
            block5: for (int i = 0; i < sql.length(); ++i) {
                switch (sql.charAt(i)) {
                    case '(': {
                        if (inStrVal) continue block5;
                        lStack.push(i);
                        continue block5;
                    }
                    case ')': {
                        if (inStrVal || lStack.isEmpty()) continue block5;
                        result.put((Integer)lStack.pop(), i);
                        continue block5;
                    }
                    case '\'': {
                        inStrVal = !inStrVal;
                        continue block5;
                    }
                }
            }
        }
        return result;
    }

    public String convert(String originSql, String project, String defaultSchema) {
        return this.transform(originSql, project, defaultSchema);
    }
}

