/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.util.Litmus;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.tool.CalciteParser;

public class SqlSubqueryFinder
extends SqlBasicVisitor<SqlNode> {
    private List<SqlCall> sqlSelectsOrOrderbys = new ArrayList<SqlCall>();
    private List<SqlIdentifier> subqueryAlias = new ArrayList<SqlIdentifier>();
    private boolean includeNestedQueries = false;

    SqlSubqueryFinder() {
    }

    public SqlSubqueryFinder(boolean includeNestedQueries) {
        this();
        this.includeNestedQueries = includeNestedQueries;
    }

    public static List<SqlCall> getSubqueries(String sql) throws SqlParseException {
        return SqlSubqueryFinder.getSubqueries(sql, false);
    }

    public static List<SqlCall> getSubqueries(String sql, boolean includeNestedQueries) throws SqlParseException {
        SqlNode parsed = CalciteParser.parse((String)sql);
        SqlSubqueryFinder sqlSubqueryFinder = new SqlSubqueryFinder(includeNestedQueries);
        parsed.accept((SqlVisitor)sqlSubqueryFinder);
        return sqlSubqueryFinder.getSqlSelectsOrOrderbys();
    }

    List<SqlCall> getSqlSelectsOrOrderbys() {
        return this.sqlSelectsOrOrderbys;
    }

    public SqlNode visit(SqlCall call) {
        for (SqlNode operand : call.getOperandList()) {
            if (operand == null) continue;
            operand.accept((SqlVisitor)this);
        }
        if (call instanceof SqlSelect && ((SqlSelect)call).getFrom() != null) {
            SqlSelect select = (SqlSelect)call;
            RootTableValidator validator = new RootTableValidator();
            select.getFrom().accept((SqlVisitor)validator);
            if (validator.hasRoot) {
                this.sqlSelectsOrOrderbys.add(call);
            }
        }
        if (call instanceof SqlWithItem) {
            SqlWithItem sqlWithQuery = (SqlWithItem)call;
            this.subqueryAlias.add(sqlWithQuery.name);
        }
        if (this.includeNestedQueries && SqlKind.UNION == call.getKind()) {
            this.sqlSelectsOrOrderbys.add(call);
        }
        if (call instanceof SqlOrderBy) {
            SqlCall sqlCall = this.sqlSelectsOrOrderbys.get(this.sqlSelectsOrOrderbys.size() - 1);
            SqlNode query = ((SqlOrderBy)call).query;
            if (query instanceof SqlWith) {
                query = ((SqlWith)query).body;
            }
            if (query instanceof SqlBasicCall && SqlKind.UNION == query.getKind()) {
                for (SqlNode operand : ((SqlBasicCall)query).getOperandList()) {
                    if (operand == null) continue;
                    operand.accept((SqlVisitor)this);
                }
            } else {
                RootTableValidator validator = new RootTableValidator();
                ((SqlSelect)query).getFrom().accept((SqlVisitor)validator);
                if (validator.hasRoot) {
                    Preconditions.checkState((query == sqlCall ? 1 : 0) != 0);
                    this.sqlSelectsOrOrderbys.set(this.sqlSelectsOrOrderbys.size() - 1, call);
                }
            }
        }
        return null;
    }

    private class RootTableValidator
    extends SqlBasicVisitor<SqlNode> {
        private boolean hasRoot = true;

        private RootTableValidator() {
        }

        public SqlNode visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                if (SqlSubqueryFinder.this.includeNestedQueries) {
                    SqlNodeList list = ((SqlSelect)call).getSelectList();
                    this.hasRoot = list.get(0).toString().equals("*");
                } else {
                    this.hasRoot = false;
                }
            } else if (call instanceof SqlJoin) {
                ((SqlJoin)call).getLeft().accept((SqlVisitor)this);
            } else if (call instanceof SqlBasicCall && call.getOperator() instanceof SqlAsOperator) {
                ((SqlNode)call.getOperandList().get(0)).accept((SqlVisitor)this);
            } else {
                for (SqlNode operand : call.getOperandList()) {
                    if (operand == null) continue;
                    operand.accept((SqlVisitor)this);
                }
            }
            return null;
        }

        public SqlNode visit(SqlIdentifier id) {
            for (SqlIdentifier alias : SqlSubqueryFinder.this.subqueryAlias) {
                if (!alias.equalsDeep((SqlNode)id, Litmus.IGNORE)) continue;
                this.hasRoot = false;
                break;
            }
            return null;
        }
    }
}

