/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.constant;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kylin.job.constant.JobActionEnum;

public enum JobStatusEnum {
    NEW(0){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return true;
        }
    }
    ,
    PENDING(1){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return actionEnum == JobActionEnum.PAUSE || actionEnum == JobActionEnum.DISCARD;
        }
    }
    ,
    RUNNING(2){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return actionEnum == JobActionEnum.PAUSE || actionEnum == JobActionEnum.DISCARD || actionEnum == JobActionEnum.RESTART;
        }
    }
    ,
    FINISHED(4){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    }
    ,
    ERROR(8){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return actionEnum == JobActionEnum.DISCARD || actionEnum == JobActionEnum.RESUME || actionEnum == JobActionEnum.RESTART;
        }
    }
    ,
    DISCARDED(16){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    }
    ,
    STOPPED(32){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return actionEnum == JobActionEnum.DISCARD || actionEnum == JobActionEnum.RESUME || actionEnum == JobActionEnum.RESTART;
        }
    }
    ,
    SUICIDAL(64){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    }
    ,
    STARTING(128){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    }
    ,
    STOPPING(256){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    }
    ,
    LAUNCHING_ERROR(512){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return actionEnum == JobActionEnum.DISCARD || actionEnum == JobActionEnum.RESUME || actionEnum == JobActionEnum.RESTART;
        }
    }
    ,
    SKIP(1024){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    }
    ,
    WARNING(2048){

        @Override
        public boolean checkAction(JobActionEnum actionEnum) {
            return false;
        }
    };

    private final int code;
    private static final Map<Integer, JobStatusEnum> codeMap;
    private static final Map<String, JobStatusEnum> nameMap;

    public abstract boolean checkAction(JobActionEnum var1);

    public String getValidActions() {
        return Arrays.stream(JobActionEnum.values()).filter(this::checkAction).map(Enum::name).collect(Collectors.joining(", "));
    }

    private JobStatusEnum(int statusCode) {
        this.code = statusCode;
    }

    public int getCode() {
        return this.code;
    }

    public static JobStatusEnum getByCode(Integer statusCode) {
        if (null == statusCode) {
            return null;
        }
        return codeMap.get(statusCode);
    }

    public static JobStatusEnum getByName(String name) {
        return nameMap.get(name);
    }

    static {
        codeMap = new HashMap<Integer, JobStatusEnum>(10);
        nameMap = new HashMap<String, JobStatusEnum>(10);
        for (JobStatusEnum jobStatusEnum : JobStatusEnum.values()) {
            codeMap.put(jobStatusEnum.getCode(), jobStatusEnum);
            nameMap.put(jobStatusEnum.name(), jobStatusEnum);
        }
    }
}

