/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;

public class TableSamplingJobHandler
extends AbstractJobHandler {
    @Override
    protected AbstractExecutable createJob(JobParam jobParam) {
        return JobFactory.createJob("TABLE_SAMPLING_JOB_FACTORY", new TableSamplingJobBuildParam(jobParam));
    }

    @Override
    protected void checkBeforeHandle(JobParam jobParam) {
        String project = jobParam.getProject();
        String table = jobParam.getTable();
        List<JobInfo> existingJobs = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project).fetchNotFinalJobsByTypes(project, Lists.newArrayList((Object[])new String[]{JobTypeEnum.TABLE_SAMPLING.name()}), Lists.newArrayList((Object[])new String[]{table}));
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        if (CollectionUtils.isNotEmpty(existingJobs)) {
            existingJobs.forEach(jobInfo -> execMgr.discardJob(jobInfo.getJobId()));
        }
        JobManager.checkStorageQuota(project);
    }

    public static class TableSamplingJobBuildParam
    extends JobFactory.JobBuildParams {
        private final String table;
        private final String project;
        private final int row;

        public TableSamplingJobBuildParam(JobParam jobParam) {
            super(null, jobParam.getDeleteLayouts(), jobParam.getOwner(), jobParam.getJobTypeEnum(), jobParam.getJobId(), jobParam.getDeleteLayouts(), jobParam.getIgnoredSnapshotTables(), jobParam.getTargetPartitions(), jobParam.getTargetBuckets(), jobParam.getExtParams());
            this.table = jobParam.getTable();
            this.project = jobParam.getProject();
            this.row = Integer.parseInt(jobParam.getExtParams().get("samplingRows"));
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public int getRow() {
            return this.row;
        }
    }
}

