/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage;

import java.text.MessageFormat;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageFatalException;
import org.apache.linkis.storage.factory.BuildFactory;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.Map;

public final class FSFactory$
implements Logging {
    public static FSFactory$ MODULE$;
    private final Map<String, BuildFactory> buildClasses;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FSFactory$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FSFactory$ fSFactory$ = this;
        synchronized (fSFactory$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Map<String, BuildFactory> buildClasses() {
        return this.buildClasses;
    }

    public BuildFactory getBuildFactory(String fsName) {
        if (!this.buildClasses().contains((Object)fsName)) {
            throw new StorageFatalException(LinkisStorageErrorCodeSummary.UNSUPPORTED_FILE.getErrorCode(), MessageFormat.format(LinkisStorageErrorCodeSummary.UNSUPPORTED_FILE.getErrorDesc(), fsName));
        }
        return (BuildFactory)this.buildClasses().apply((Object)fsName);
    }

    public Fs getFs(String fsType, String proxyUser) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fsType).getFs(user, proxyUser);
    }

    public Fs getFs(String fsType) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fsType).getFs(user, user);
    }

    public Fs getFs(FsPath fsPath) {
        return this.getFs(fsPath.getFsType());
    }

    public Fs getFsByProxyUser(FsPath fsPath, String proxyUser) {
        return this.getFs(fsPath.getFsType(), proxyUser);
    }

    public Fs getFSByLabel(String fs, String label) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fs).getFs(user, user, label);
    }

    public Fs getFSByLabelAndUser(String fs, String label, String proxy) {
        String user = StorageUtils$.MODULE$.getJvmUser();
        return this.getBuildFactory(fs).getFs(user, proxy, label);
    }

    private FSFactory$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.buildClasses = StorageUtils$.MODULE$.loadClass((String)StorageConfiguration$.MODULE$.STORAGE_BUILD_FS_CLASSES().getValue(), (Function1 & java.io.Serializable & Serializable)t -> t.fsName());
    }
}

