/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.ddl;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.metadata.conf.MdqConfiguration$;
import org.apache.linkis.metadata.ddl.ImportHelper;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableBO;
import org.apache.linkis.metadata.domain.mdq.bo.MdqTableImportInfoBO;
import org.apache.linkis.metadata.errorcode.LinkisMetadataErrorCodeSummary;
import org.apache.linkis.metadata.exception.MdqIllegalParamException;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class FileImportDDLHelper$
implements ImportHelper,
Logging {
    public static FileImportDDLHelper$ MODULE$;
    private final CommonVars<String> CODE_STORE_PREFIX;
    private final CommonVars<String> CODE_STORE_SUFFIX;
    private final String CHARSET;
    private final String CODE_SPLIT;
    private final String LENGTH_SPLIT;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new FileImportDDLHelper$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FileImportDDLHelper$ fileImportDDLHelper$ = this;
        synchronized (fileImportDDLHelper$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private CommonVars<String> CODE_STORE_PREFIX() {
        return this.CODE_STORE_PREFIX;
    }

    private CommonVars<String> CODE_STORE_SUFFIX() {
        return this.CODE_STORE_SUFFIX;
    }

    private String CHARSET() {
        return this.CHARSET;
    }

    private String CODE_SPLIT() {
        return this.CODE_SPLIT;
    }

    private String LENGTH_SPLIT() {
        return this.LENGTH_SPLIT;
    }

    @Override
    public String generateCode(MdqTableBO mdqTableBO, String user) {
        scala.collection.mutable.StringBuilder stringBuilder;
        this.logger().info(new StringBuilder(42).append("begin to generate code for ").append(mdqTableBO.getTableBaseInfo().getBase().getName()).append(" using File way").toString());
        scala.collection.mutable.StringBuilder createTableCode = new scala.collection.mutable.StringBuilder();
        MdqTableImportInfoBO importInfo = mdqTableBO.getImportInfo();
        if (StringUtils.isEmpty((CharSequence)importInfo.getSource())) {
            throw new MdqIllegalParamException(LinkisMetadataErrorCodeSummary.IMPORT_HIVE_SOURCE_IS_NULL.getErrorDesc());
        }
        String _source = importInfo.getSource();
        if (StringUtils.isEmpty((CharSequence)importInfo.getDestination())) {
            throw new MdqIllegalParamException(LinkisMetadataErrorCodeSummary.IMPORT_HIVE_SOURCE_IS_NULL.getErrorDesc());
        }
        String _destination = importInfo.getDestination();
        String source = new StringBuilder(20).append("val source = \"\"\"").append(_source).append("\"\"\"\n").toString();
        createTableCode.append(source);
        String storePath = this.storeExecutionCode(_destination, user);
        if (storePath == null) {
            String destination = new StringBuilder(25).append("val destination = \"\"\"").append(_destination).append("\"\"\"\n").toString();
            createTableCode.append(destination);
            stringBuilder = createTableCode.append(new StringBuilder(42).append((String)MdqConfiguration$.MODULE$.SPARK_MDQ_IMPORT_CLAZZ().getValue()).append(".loadDataToTable(spark,source,destination)").toString());
        } else {
            String destination = new StringBuilder(25).append("val destination = \"\"\"").append(storePath).append("\"\"\"\n").toString();
            createTableCode.append(destination);
            stringBuilder = createTableCode.append(new StringBuilder(48).append((String)MdqConfiguration$.MODULE$.SPARK_MDQ_IMPORT_CLAZZ().getValue()).append(".loadDataToTableByFile(spark,destination,source)").toString());
        }
        String resultCode = createTableCode.toString();
        this.logger().info(new StringBuilder(34).append("end to generate code for ").append(mdqTableBO.getTableBaseInfo().getBase().getName()).append(" code is ").append(resultCode).toString());
        return resultCode;
    }

    public String storeExecutionCode(String destination, String user) {
        if (destination.length() < 60000) {
            return null;
        }
        String path = this.getCodeStorePath(user);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
        fileSystem.init(null);
        ObjectRef os = ObjectRef.create(null);
        LongRef position = LongRef.create((long)0L);
        byte[] codeBytes = destination.getBytes(this.CHARSET());
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = path.intern();
            synchronized (string) {
                if (!fileSystem.exists(fsPath)) {
                    FileSystemUtils$.MODULE$.createNewFile(fsPath, user, true);
                }
                os$1.elem = fileSystem.write(fsPath, false);
                position$1.elem = fileSystem.get(path).getLength();
                IOUtils.write((byte[])codeBytes, (OutputStream)((OutputStream)os$1.elem));
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (fileSystem != null) {
                fileSystem.close();
            }
            IOUtils.closeQuietly((OutputStream)((OutputStream)os$1.elem));
        });
        int length = codeBytes.length;
        return new StringBuilder(0).append(path).append(this.CODE_SPLIT()).append(position.elem).append(this.LENGTH_SPLIT()).append(length).toString();
    }

    private String getCodeStorePath(String user) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        return new StringBuilder(26).append(this.CODE_STORE_PREFIX().getValue()).append(user).append(this.CODE_STORE_SUFFIX().getValue()).append("/executionCode/").append(date).append("/_bgservice").toString();
    }

    private FileImportDDLHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CODE_STORE_PREFIX = CommonVars$.MODULE$.apply("wds.linkis.mdq.store.prefix", (Object)"hdfs:///apps-data/");
        this.CODE_STORE_SUFFIX = CommonVars$.MODULE$.apply("wds.linkis.mdq.store.suffix", (Object)"");
        this.CHARSET = "utf-8";
        this.CODE_SPLIT = ";";
        this.LENGTH_SPLIT = "#";
    }
}

