/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.restful;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.common.utils.JsonUtils;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.converter.DefaultMetricsConverter;
import org.apache.linkis.manager.am.exception.AMErrorCode;
import org.apache.linkis.manager.am.exception.AMErrorException;
import org.apache.linkis.manager.am.manager.EngineNodeManager;
import org.apache.linkis.manager.am.restful.EngineRestfulApi;
import org.apache.linkis.manager.am.service.ECResourceInfoService;
import org.apache.linkis.manager.am.service.em.ECMOperateService;
import org.apache.linkis.manager.am.service.em.EMInfoService;
import org.apache.linkis.manager.am.service.engine.DefaultEngineCreateService;
import org.apache.linkis.manager.am.utils.AMUtils;
import org.apache.linkis.manager.am.vo.CanCreateECRes;
import org.apache.linkis.manager.am.vo.EMNodeVo;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;
import org.apache.linkis.manager.common.entity.metrics.NodeHealthyInfo;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.entity.persistence.ECResourceInfoRecord;
import org.apache.linkis.manager.common.exception.RMErrorException;
import org.apache.linkis.manager.common.protocol.OperateRequest$;
import org.apache.linkis.manager.common.protocol.em.ECMOperateRequest;
import org.apache.linkis.manager.common.protocol.em.ECMOperateRequest$;
import org.apache.linkis.manager.common.protocol.em.ECMOperateResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.exception.PersistenceErrorException;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.UserModifiable;
import org.apache.linkis.manager.label.entity.engine.EngineTypeLabel;
import org.apache.linkis.manager.label.entity.engine.UserCreatorLabel;
import org.apache.linkis.manager.label.exception.LabelErrorException;
import org.apache.linkis.manager.label.service.NodeLabelService;
import org.apache.linkis.manager.label.utils.EngineTypeLabelCreator;
import org.apache.linkis.manager.persistence.LabelManagerPersistence;
import org.apache.linkis.manager.persistence.NodeMetricManagerPersistence;
import org.apache.linkis.manager.persistence.ResourceManagerPersistence;
import org.apache.linkis.manager.rm.external.service.ExternalResourceService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ECM(engineconnmanager) operation"})
@RequestMapping(path={"/linkisManager"}, produces={"application/json"})
@RestController
public class EMRestfulApi {
    public static final String KEY_TENANT = "tenant";
    @Autowired
    private EMInfoService emInfoService;
    @Autowired
    private NodeLabelService nodeLabelService;
    @Autowired
    private DefaultMetricsConverter defaultMetricsConverter;
    @Autowired
    private EngineNodeManager engineNodeManager;
    @Autowired
    private ECMOperateService ecmOperateService;
    @Autowired
    private ECResourceInfoService ecResourceInfoService;
    @Autowired
    private ResourceManagerPersistence resourceManagerPersistence;
    @Autowired
    private LabelManagerPersistence labelManagerPersistence;
    @Autowired
    private ExternalResourceService externalResourceService;
    @Autowired
    private DefaultEngineCreateService defaultEngineCreateService;
    @Autowired
    private NodeMetricManagerPersistence nodeMetricManagerPersistence;
    private LabelBuilderFactory stdLabelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    private Logger logger = LoggerFactory.getLogger(EMRestfulApi.class);
    private String[] adminOperations = ((String)AMConfiguration.ECM_ADMIN_OPERATIONS.getValue()).split(",");

    private void checkAdmin(String userName) throws AMErrorException {
        if (Configuration.isNotAdmin((String)userName)) {
            throw new AMErrorException(210003, "Only admin can modify ECMs(\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539ECM).");
        }
    }

    @ApiOperation(value="listAllEMs", notes="get all ECM service list", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="instance", dataType="String", value="Instance"), @ApiImplicitParam(name="nodeHealthy", dataType="String", value="node  healthy status", example="Healthy, UnHealthy, WARN, StockAvailable, StockUnavailable"), @ApiImplicitParam(name="owner", dataType="String", value="Owner"), @ApiImplicitParam(name="tenantLabel", dataType="String", value="tenantLabel like")})
    @RequestMapping(path={"/listAllEMs"}, method={RequestMethod.GET})
    public Message listAllEMs(HttpServletRequest req, @RequestParam(value="instance", required=false) String instance, @RequestParam(value="nodeHealthy", required=false) String nodeHealthy, @RequestParam(value="owner", required=false) String owner, @RequestParam(value="tenantLabel", required=false) String tenantLabel) throws AMErrorException {
        this.checkAdmin(ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"listAllEMs"));
        List<EMNodeVo> emNodeVos = AMUtils.copyToEMVo(this.emInfoService.getAllEM());
        if (CollectionUtils.isNotEmpty(emNodeVos)) {
            Stream<Object> stream = emNodeVos.stream();
            if (StringUtils.isNotBlank((CharSequence)instance)) {
                stream = stream.filter(em -> em.getInstance().contains(instance));
            }
            if (StringUtils.isNotBlank((CharSequence)nodeHealthy)) {
                stream = stream.filter(em -> em.getNodeHealthy() == null || em.getNodeHealthy().equals((Object)NodeHealthy.valueOf((String)nodeHealthy)));
            }
            if (StringUtils.isNotBlank((CharSequence)owner)) {
                stream = stream.filter(em -> em.getOwner().equalsIgnoreCase(owner));
            }
            if (StringUtils.isNotBlank((CharSequence)tenantLabel)) {
                stream = stream.filter(em -> {
                    List<Object> labels = em.getLabels();
                    return (labels = labels.stream().filter(label -> KEY_TENANT.equals(label.getLabelKey()) && label.getStringValue().contains(tenantLabel)).collect(Collectors.toList())).size() > 0;
                });
            }
            emNodeVos = stream.collect(Collectors.toList());
            if (StringUtils.isNotBlank((CharSequence)tenantLabel)) {
                Collections.sort(emNodeVos, new Comparator<EMNodeVo>(){

                    @Override
                    public int compare(EMNodeVo a, EMNodeVo b) {
                        String aLabelStr = ((Label)a.getLabels().stream().filter(label -> EMRestfulApi.KEY_TENANT.equals(label.getLabelKey())).collect(Collectors.toList()).get(0)).getStringValue();
                        String bLabelStr = ((Label)b.getLabels().stream().filter(label -> EMRestfulApi.KEY_TENANT.equals(label.getLabelKey())).collect(Collectors.toList()).get(0)).getStringValue();
                        return aLabelStr.compareTo(bLabelStr);
                    }
                });
            } else {
                Collections.sort(emNodeVos, Comparator.comparing(EMNodeVo::getInstance));
            }
        }
        return Message.ok().data("EMs", emNodeVos);
    }

    @ApiOperation(value="listAllECMHealthyStatus", notes="get all ECM healthy status", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="onlyEditable", dataType="Boolean", value="only editable")})
    @RequestMapping(path={"/listAllECMHealthyStatus"}, method={RequestMethod.GET})
    public Message listAllNodeHealthyStatus(HttpServletRequest req, @RequestParam(value="onlyEditable", required=false) Boolean onlyEditable) {
        NodeHealthy[] nodeHealthy = NodeHealthy.values();
        if (onlyEditable.booleanValue()) {
            nodeHealthy = new NodeHealthy[]{NodeHealthy.Healthy, NodeHealthy.UnHealthy, NodeHealthy.WARN, NodeHealthy.StockAvailable, NodeHealthy.StockUnavailable};
        }
        return Message.ok().data("nodeHealthy", (Object)nodeHealthy);
    }

    @ApiOperation(value="modifyEMInfo", notes="modify ECM info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationName", dataType="String", example="linkis-cg-engineconnmanager"), @ApiImplicitParam(name="emStatus", dataType="String", example="Healthy, UnHealthy, WARN, StockAvailable, StockUnavailable"), @ApiImplicitParam(name="instance", dataType="String", example="bdp110:9102"), @ApiImplicitParam(name="labels", dataType="List", value="Labels"), @ApiImplicitParam(name="labelKey", dataType="String", example="emInstance"), @ApiImplicitParam(name="description", dataType="String", example=""), @ApiImplicitParam(name="stringValue", dataType="String", example="linkis-cg-engineconn-bdp110:12295")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/modifyEMInfo"}, method={RequestMethod.PUT})
    @Transactional(rollbackFor={Exception.class})
    public Message modifyEMInfo(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException, LabelErrorException {
        JsonNode description;
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"modifyEMInfo");
        this.checkAdmin(username);
        String applicationName = jsonNode.get("applicationName").asText();
        String instance = jsonNode.get("instance").asText();
        if (StringUtils.isEmpty((CharSequence)applicationName)) {
            throw new AMErrorException(AMErrorCode.QUERY_PARAM_NULL.getErrorCode(), "applicationName cannot be null(\u8bf7\u6c42\u53c2\u6570applicationName\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isEmpty((CharSequence)instance)) {
            throw new AMErrorException(AMErrorCode.QUERY_PARAM_NULL.getErrorCode(), "instance cannot be null(\u8bf7\u6c42\u53c2\u6570instance\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        ServiceInstance serviceInstance = ServiceInstance.apply((String)applicationName, (String)instance);
        if (serviceInstance == null) {
            throw new AMErrorException(AMErrorCode.QUERY_PARAM_NULL.getErrorCode(), "serviceInstance:" + applicationName + " non-existent(" + applicationName + ")");
        }
        String healthyStatus = jsonNode.get("emStatus").asText();
        if (healthyStatus != null) {
            NodeHealthyInfo nodeHealthyInfo = new NodeHealthyInfo();
            nodeHealthyInfo.setNodeHealthy(NodeHealthy.valueOf((String)healthyStatus));
            this.emInfoService.updateEMInfo(serviceInstance, nodeHealthyInfo);
        }
        JsonNode labels = jsonNode.get("labels");
        HashSet<String> labelKeySet = new HashSet<String>();
        if (labels != null) {
            ArrayList newLabelList = new ArrayList();
            for (JsonNode label : labels) {
                String stringValue;
                String labelKey = label.get("labelKey").asText();
                Label newLabel = this.stdLabelBuilderFactory.createLabel(labelKey, (Object)(stringValue = label.get("stringValue").asText()));
                if (newLabel instanceof UserModifiable) {
                    ((UserModifiable)newLabel).valueCheck(stringValue);
                }
                labelKeySet.add(labelKey);
                newLabelList.add(newLabel);
            }
            if (labelKeySet.size() != newLabelList.size()) {
                throw new AMErrorException(210003, "Failed to update label, include repeat labels(\u66f4\u65b0label\u5931\u8d25\uff0c\u5305\u542b\u91cd\u590dlabel)");
            }
            this.nodeLabelService.updateLabelsToNode(serviceInstance, newLabelList);
            this.logger.info("success to update label of instance: " + serviceInstance.getInstance());
        }
        if (null != (description = jsonNode.get("description"))) {
            this.nodeMetricManagerPersistence.updateNodeMetricDescription(description.asText(), instance);
        }
        return Message.ok((String)"success");
    }

    @ApiOperation(value="executeECMOperationByEC", notes="EC execute ECM operation", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/executeECMOperationByEC"}, method={RequestMethod.POST})
    public Message executeECMOperationByEC(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        Map parameters;
        ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"executeECMOperationByEC");
        this.logger.info("User {} try to execute ECM Operation by EngineConn {}.", (Object)userName, (Object)serviceInstance);
        EngineNode engineNode = this.engineNodeManager.getEngineNode(serviceInstance);
        try {
            parameters = (Map)JsonUtils.jackson().readValue(jsonNode.get("parameters").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.error("Fail to process the operation parameters: [{}] in request", (Object)jsonNode.get("parameters").toString(), (Object)e);
            return Message.error((String)("Fail to process the operation parameters, cased by " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        parameters.put(ECMOperateRequest.ENGINE_CONN_INSTANCE_KEY(), serviceInstance.getInstance());
        if (!userName.equals(engineNode.getOwner()) && Configuration.isNotAdmin((String)userName)) {
            return Message.error((String)("You have no permission to execute ECM Operation by this EngineConn " + serviceInstance));
        }
        return this.executeECMOperation(engineNode.getEMNode(), engineNode.getServiceInstance().getInstance(), new ECMOperateRequest(userName, parameters));
    }

    @ApiOperation(value="executeECMOperation", notes="execute ECM operation", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/executeECMOperation"}, method={RequestMethod.POST})
    public Message executeECMOperation(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        Map parameters;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"executeECMOperation");
        ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
        this.logger.info("User {} try to execute ECM Operation with {}.", (Object)userName, (Object)serviceInstance);
        EMNode ecmNode = this.emInfoService.getEM(serviceInstance);
        try {
            parameters = (Map)JsonUtils.jackson().readValue(jsonNode.get("parameters").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.error("Fail to process the operation parameters: [{}] in request", (Object)jsonNode.get("parameters").toString(), (Object)e);
            return Message.error((String)("Fail to process the operation parameters, cased by " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        if (parameters.containsKey("engineConnInstance")) {
            return this.executeECMOperation(ecmNode, parameters.get("engineConnInstance").toString(), new ECMOperateRequest(userName, parameters));
        }
        return this.executeECMOperation(ecmNode, "", new ECMOperateRequest(userName, parameters));
    }

    @ApiOperation(value="openEngineLog", notes="open Engine log", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationName", dataType="String", example="linkis-cg-engineconn"), @ApiImplicitParam(name="emInstance", dataType="String", example="bdp110:9100"), @ApiImplicitParam(name="instance", dataType="String", example="bdp110:21976"), @ApiImplicitParam(name="parameters", dataType="Map", value="Parameters"), @ApiImplicitParam(name="logType", dataType="String", example="stdout"), @ApiImplicitParam(name="fromLine", dataType="String", example="0"), @ApiImplicitParam(name="pageSize", dataType="String", defaultValue="1000")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/openEngineLog"}, method={RequestMethod.POST})
    public Message openEngineLog(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws AMErrorException {
        Map parameters;
        EMNode ecmNode;
        String engineInstance;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"openEngineLog");
        try {
            String emInstance = jsonNode.get("emInstance").asText();
            engineInstance = jsonNode.get("instance").asText();
            ServiceInstance serviceInstance = EngineRestfulApi.getServiceInstance(jsonNode);
            this.logger.info("User {} try to open engine: {} log.", (Object)userName, (Object)serviceInstance);
            ecmNode = this.emInfoService.getEM(ServiceInstance.apply((String)"linkis-cg-engineconnmanager", (String)emInstance));
            this.logger.info("ecm node info:{}", (Object)ecmNode);
            parameters = (Map)JsonUtils.jackson().readValue(jsonNode.get("parameters").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String logType = (String)parameters.get("logType");
            if (!(logType.equals("stdout") || logType.equals("stderr") || logType.equals("gc") || logType.equals("yarnApp"))) {
                throw new AMErrorException(AMErrorCode.PARAM_ERROR.getErrorCode(), AMErrorCode.PARAM_ERROR.getErrorDesc());
            }
            parameters.put(OperateRequest$.MODULE$.OPERATOR_NAME_KEY(), "engineConnLog");
            parameters.put(ECMOperateRequest$.MODULE$.ENGINE_CONN_INSTANCE_KEY(), engineInstance);
            if (!parameters.containsKey("enableTail")) {
                parameters.put("enableTail", true);
            }
        }
        catch (JsonProcessingException e) {
            this.logger.error("Fail to process the operation parameters: [{}] in request", (Object)jsonNode.get("parameters").toString(), (Object)e);
            return Message.error((String)("Fail to process the operation parameters, cased by " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        catch (Exception e) {
            this.logger.error("Failed to open engine log, error:", (Throwable)e);
            return Message.error((String)e.getMessage());
        }
        return this.executeECMOperation(ecmNode, engineInstance, new ECMOperateRequest(userName, parameters));
    }

    private Message executeECMOperation(EMNode ecmNode, String engineInstance, ECMOperateRequest ecmOperateRequest) {
        if (Objects.isNull(ecmNode)) {
            return Message.error((String)MessageFormat.format("ECM node :[{0}]  does not exist, Unable to open engine log(ECM\u8282\u70b9:[{1}] \u5f02\u5e38\uff0c\u65e0\u6cd5\u6253\u5f00\u65e5\u5fd7\uff0c\u53ef\u80fd\u662f\u8be5\u8282\u70b9\u670d\u52a1\u91cd\u542f\u6216\u8005\u670d\u52a1\u5f02\u5e38\u5bfc\u81f4)", engineInstance, engineInstance));
        }
        String operationName = OperateRequest$.MODULE$.getOperationName(ecmOperateRequest.parameters());
        String userName = ecmOperateRequest.user();
        if (ArrayUtils.contains((Object[])this.adminOperations, (Object)operationName) && Configuration.isNotAdmin((String)userName)) {
            this.logger.warn("User {} has no permission to execute {} admin Operation in ECM {}.", new Object[]{userName, operationName, ecmNode.getServiceInstance()});
            return Message.error((String)("You have no permission to execute " + operationName + " admin Operation in ECM " + ecmNode.getServiceInstance()));
        }
        if (StringUtils.isNotBlank((CharSequence)engineInstance) && Objects.isNull(ecmOperateRequest.parameters().get("logDirSuffix"))) {
            ECResourceInfoRecord ecResourceInfoRecord = this.ecResourceInfoService.getECResourceInfoRecordByInstance(engineInstance);
            if (Objects.isNull(ecResourceInfoRecord)) {
                return Message.error((String)("EC instance: " + engineInstance + " not exist "));
            }
            String logDirSuffix = ecResourceInfoRecord.getLogDirSuffix();
            if (!userName.equals(ecResourceInfoRecord.getCreateUser()) && Configuration.isNotJobHistoryAdmin((String)userName)) {
                this.logger.warn("User {} has no permission to get log with path: {} in ECM:{}.", new Object[]{userName, logDirSuffix, ecmNode.getServiceInstance()});
                return Message.error((String)("You have no permission to get log with path:" + logDirSuffix + " in ECM:" + ecmNode.getServiceInstance()));
            }
            ecmOperateRequest.parameters().put("logDirSuffix", logDirSuffix);
        }
        ECMOperateResponse engineOperateResponse = this.ecmOperateService.executeOperation(ecmNode, ecmOperateRequest);
        return Message.ok().data("result", (Object)engineOperateResponse.getResult()).data("errorMsg", (Object)engineOperateResponse.errorMsg()).data("isError", (Object)engineOperateResponse.isError());
    }

    @ApiOperation(value="taskprediction", notes="linkis task taskprediction", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", dataType="String", example="hadoop"), @ApiImplicitParam(name="engineType", dataType="String", example="spark/hive"), @ApiImplicitParam(name="creator", dataType="String", value="ide"), @ApiImplicitParam(name="clustername", dataType="String", example="clustername"), @ApiImplicitParam(name="queueName", dataType="String", example="queueName"), @ApiImplicitParam(name="tenant", dataType="String", defaultValue="tenant")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/task-prediction"}, method={RequestMethod.GET})
    public Message taskprediction(HttpServletRequest req, @RequestParam(value="username", required=false) String username, @RequestParam(value="engineType", required=false) String engineType, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="clustername", required=false) String clusterName, @RequestParam(value="queueName", required=false) String queueName, @RequestParam(value="tenant", required=false) String tenant) throws PersistenceErrorException, RMErrorException {
        String loginUser = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"taskprediction");
        if (StringUtils.isBlank((CharSequence)username)) {
            username = loginUser;
        }
        if (StringUtils.isBlank((CharSequence)engineType)) {
            return Message.error((String)"parameters:engineType can't be null (\u8bf7\u6c42\u53c2\u6570\u3010engineType\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        if (StringUtils.isBlank((CharSequence)creator)) {
            return Message.error((String)"parameters:creator can't be null (\u8bf7\u6c42\u53c2\u6570\u3010creator\u3011\u4e0d\u80fd\u4e3a\u7a7a)");
        }
        UserCreatorLabel userCreatorLabel = (UserCreatorLabel)LabelBuilderFactoryContext.getLabelBuilderFactory().createLabel(UserCreatorLabel.class);
        userCreatorLabel.setCreator(creator);
        userCreatorLabel.setUser(username);
        EngineTypeLabel engineTypeLabel = EngineTypeLabelCreator.createEngineTypeLabel((String)engineType);
        HashMap<String, String> parms = new HashMap<String, String>();
        parms.put(userCreatorLabel.getLabelKey(), userCreatorLabel.getStringValue());
        parms.put(engineTypeLabel.getLabelKey(), engineTypeLabel.getStringValue());
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            parms.put(KEY_TENANT, tenant);
        }
        EngineCreateRequest engineCreateRequest = new EngineCreateRequest();
        engineCreateRequest.setUser(username);
        engineCreateRequest.setLabels(parms);
        CanCreateECRes canCreateECRes = this.defaultEngineCreateService.canCreateEC(engineCreateRequest);
        return Message.ok().data(KEY_TENANT, (Object)tenant).data("userResource", (Object)canCreateECRes.getLabelResource()).data("ecmResource", (Object)canCreateECRes.getEcmResource()).data("yarnResource", (Object)canCreateECRes.getYarnResource()).data("checkResult", (Object)canCreateECRes.isCanCreateEC());
    }

    @ApiOperation(value="reset resource", notes="ecm & user resource reset", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="serviceInstance", dataType="String", example="gz.bdz.bdplxxxxx.apache:9102"), @ApiImplicitParam(name="username", dataType="String", example="hadoop")})
    @RequestMapping(path={"/reset-resource"}, method={RequestMethod.GET})
    public Message resetResource(HttpServletRequest req, @RequestParam(value="serviceInstance", required=false) String serviceInstance, @RequestParam(value="username", required=false) String username) {
        String loginUser = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"reset resource");
        if (Configuration.isNotAdmin((String)loginUser)) {
            return Message.error((String)"Only Admin Can Use Reset Resource (\u91cd\u7f6e\u8d44\u6e90\u4ec5\u7ba1\u7406\u5458\u4f7f\u7528)");
        }
        this.emInfoService.resetResource(serviceInstance, username);
        return Message.ok();
    }
}

