/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.catalyst.reheater;

import java.io.Serializable;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.orchestrator.computation.utils.TreeNodeUtil$;
import org.apache.linkis.orchestrator.conf.OrchestratorConfiguration$;
import org.apache.linkis.orchestrator.core.FailedOrchestrationResponse;
import org.apache.linkis.orchestrator.domain.TreeNode;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.extensions.catalyst.ReheaterTransform;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.PhysicalContext;
import org.apache.linkis.orchestrator.plans.physical.RetryExecTask;
import org.apache.linkis.orchestrator.plans.physical.RetryExecTask$;
import org.apache.linkis.orchestrator.strategy.ExecTaskStatusInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0002\u0004\u0001+!)1\u0006\u0001C\u0001Y!)q\u0006\u0001C!a!)\u0001\t\u0001C\u0005\u0003\")A\n\u0001C!\u001b\n9\u0002K];oKR\u000b7o\u001b*fiJLHK]1og\u001a|'/\u001c\u0006\u0003\u000f!\t\u0001B]3iK\u0006$XM\u001d\u0006\u0003\u0013)\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00171\t1bY8naV$\u0018\r^5p]*\u0011QBD\u0001\r_J\u001c\u0007.Z:ue\u0006$xN\u001d\u0006\u0003\u001fA\ta\u0001\\5oW&\u001c(BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001-q\u0019\u0003CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eC5\taD\u0003\u0002\n?)\u0011\u0001\u0005D\u0001\u000bKb$XM\\:j_:\u001c\u0018B\u0001\u0012\u001f\u0005E\u0011V\r[3bi\u0016\u0014HK]1og\u001a|'/\u001c\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nQ!\u001e;jYNT!\u0001\u000b\b\u0002\r\r|W.\\8o\u0013\tQSEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u00051\u0011!B1qa2LHcA\u0019:wA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\ta\"L8/[2bY*\u0011a\u0007D\u0001\u0006a2\fgn]\u0005\u0003qM\u0012\u0001\"\u0012=fGR\u000b7o\u001b\u0005\u0006u\t\u0001\r!M\u0001\u0003S:DQ\u0001\u0010\u0002A\u0002u\nqaY8oi\u0016DH\u000f\u0005\u00023}%\u0011qh\r\u0002\u0010!\"L8/[2bY\u000e{g\u000e^3yi\u0006Y\u0001/^:i\u0013:4w\u000eT8h)\r\u0011Ui\u0012\t\u0003/\rK!\u0001\u0012\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\r\u000e\u0001\r!M\u0001\u0005i\u0006\u001c8\u000eC\u0003I\u0007\u0001\u0007\u0011*A\u0007sKR\u0014\u00180\u0012=fGR\u000b7o\u001b\t\u0003e)K!aS\u001a\u0003\u001bI+GO]=Fq\u0016\u001cG+Y:l\u0003\u001d9W\r\u001e(b[\u0016,\u0012A\u0014\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005ECR\"\u0001*\u000b\u0005M#\u0012A\u0002\u001fs_>$h(\u0003\u0002V1\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)\u0006\u0004")
public class PruneTaskRetryTransform
implements ReheaterTransform,
Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PruneTaskRetryTransform pruneTaskRetryTransform = this;
        synchronized (pruneTaskRetryTransform) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ExecTask apply(ExecTask in, PhysicalContext context) {
        ExecTask[] failedTasks = TreeNodeUtil$.MODULE$.getAllFailedTaskNode(in);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])failedTasks)).foreach((Function1 & Serializable & scala.Serializable)task -> {
            PruneTaskRetryTransform.$anonfun$apply$1(this, in, failedTasks, context, task);
            return BoxedUnit.UNIT;
        });
        return in;
    }

    private void pushInfoLog(ExecTask task, RetryExecTask retryExecTask) {
        Option<ExecTaskStatusInfo> responseOption = TreeNodeUtil$.MODULE$.removeTaskResponse(task);
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder();
        stringBuilder.append(new StringBuilder(46).append("This ").append(task.getIDInfo()).append(" retry, new retry-task is:").append(retryExecTask.getIDInfo()).append(", retryCount: ").append(retryExecTask.getAge()).append(".").toString());
        responseOption.foreach((Function1 & Serializable & scala.Serializable)execTaskStatusInfo -> {
            TaskResponse taskResponse = execTaskStatusInfo.taskResponse();
            if (taskResponse instanceof FailedOrchestrationResponse) {
                TaskResponse taskResponse2 = taskResponse;
                return stringBuilder.append("reason:").append(((FailedOrchestrationResponse)taskResponse2).getErrorMsg());
            }
            return stringBuilder.append("Reason is empty");
        });
        TaskLogEvent logEvent = new TaskLogEvent(task, LogUtils$.MODULE$.generateInfo(stringBuilder.toString()));
        task.getPhysicalContext().pushLog(logEvent);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(ExecTask parent$1, ExecTask x$1) {
        ExecTask execTask = x$1;
        ExecTask execTask2 = parent$1;
        return execTask == null ? execTask2 != null : !execTask.equals(execTask2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(ExecTask task$1, ExecTask x$2) {
        ExecTask execTask = x$2;
        ExecTask execTask2 = task$1;
        return execTask == null ? execTask2 != null : !execTask.equals(execTask2);
    }

    public static final /* synthetic */ void $anonfun$apply$6(PruneTaskRetryTransform $this, ExecTask task$1, ExecTask parent$1, ExecTask[] otherChildren$1, ExecTask[] otherParents$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof Exception) {
            Integer n;
            Exception exception = (Exception)throwable;
            StringBuilder stringBuilder = new StringBuilder(88).append("Retry task construction failed, start to restore task node, task node: ").append(task$1.getIDInfo()).append(", ").append("age: ");
            ExecTask execTask = task$1;
            if (execTask instanceof RetryExecTask) {
                RetryExecTask retryExecTask = (RetryExecTask)execTask;
                n = BoxesRunTime.boxToInteger((int)retryExecTask.getAge());
            } else {
                n = BoxesRunTime.boxToInteger((int)0);
            }
            TaskLogEvent logEvent = new TaskLogEvent(task$1, LogUtils$.MODULE$.generateWarn(stringBuilder.append(n).append(", reason: ").append(exception.getMessage()).toString()));
            $this.logger().error(new StringBuilder(21).append("Failed to retry task ").append(task$1.getIDInfo()).toString(), (Throwable)exception);
            task$1.getPhysicalContext().pushLog(logEvent);
            parent$1.withNewChildren((TreeNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherChildren$1)).$colon$plus((Object)task$1, ClassTag$.MODULE$.apply(ExecTask.class)));
            task$1.withNewParents((TreeNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherParents$1)).$colon$plus((Object)parent$1, ClassTag$.MODULE$.apply(ExecTask.class)));
            TaskLogEvent downLogEvent = new TaskLogEvent(task$1, LogUtils$.MODULE$.generateWarn(new StringBuilder(33).append("restore task success! task node: ").append(task$1.getIDInfo()).toString()));
            task$1.getPhysicalContext().pushLog(downLogEvent);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    public static final /* synthetic */ void $anonfun$apply$2(PruneTaskRetryTransform $this, ExecTask[] parents$1, ExecTask task$1, PhysicalContext context$1, ExecTask parent) {
        ExecTask[] otherParents = (ExecTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents$1)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PruneTaskRetryTransform.$anonfun$apply$3(parent, x$1)));
        ExecTask[] otherChildren = (ExecTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parent.getChildren())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PruneTaskRetryTransform.$anonfun$apply$4(task$1, x$2)));
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ExecTask execTask = task$1;
            if (execTask instanceof RetryExecTask) {
                RetryExecTask retryExecTask = (RetryExecTask)execTask;
                if (retryExecTask.getAge() < Predef$.MODULE$.Integer2int(retryExecTask.getMaxRetryCount())) {
                    RetryExecTask newTask = new RetryExecTask(retryExecTask.getOriginTask(), retryExecTask.getAge() + 1);
                    newTask.initialize(retryExecTask.getPhysicalContext());
                    TreeNodeUtil$.MODULE$.replaceNode((ExecTask)retryExecTask, (ExecTask)newTask);
                    context$1.set(OrchestratorConfiguration$.MODULE$.REHEATER_KEY(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    $this.pushInfoLog(task$1, newTask);
                    return;
                }
                TaskLogEvent logEvent = new TaskLogEvent(task$1, LogUtils$.MODULE$.generateWarn(new StringBuilder(52).append("Retry task: ").append(retryExecTask.getIDInfo()).append(" reached maximum age:").append(retryExecTask.getAge()).append(", stop to retry it!").toString()));
                task$1.getPhysicalContext().pushLog(logEvent);
                return;
            }
            RetryExecTask retryExecTask = new RetryExecTask(task$1, RetryExecTask$.MODULE$.$lessinit$greater$default$2());
            retryExecTask.initialize(task$1.getPhysicalContext());
            TreeNodeUtil$.MODULE$.insertNode(parent, task$1, (ExecTask)retryExecTask);
            context$1.set(OrchestratorConfiguration$.MODULE$.REHEATER_KEY(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            $this.pushInfoLog(task$1, retryExecTask);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            PruneTaskRetryTransform.$anonfun$apply$6($this, task$1, parent, otherChildren, otherParents, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(PruneTaskRetryTransform $this, ExecTask in$1, ExecTask[] failedTasks$1, PhysicalContext context$1, ExecTask task) {
        $this.logger().info(new StringBuilder(72).append("task:").append(in$1.getIDInfo()).append(" has ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])failedTasks$1)).size()).append(" child tasks which execute failed, some of them may be retried").toString());
        TaskResponse taskResponse = TreeNodeUtil$.MODULE$.getTaskResponse(task);
        if (taskResponse instanceof FailedTaskResponse) {
            FailedTaskResponse failedTaskResponse = (FailedTaskResponse)taskResponse;
            Throwable exception = failedTaskResponse.getCause();
            if (exception instanceof LinkisRetryException) {
                ExecTask[] parents = (ExecTask[])task.getParents();
                if (parents != null) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parents)).foreach((Function1 & Serializable & scala.Serializable)parent -> {
                        PruneTaskRetryTransform.$anonfun$apply$2($this, parents, task, context$1, parent);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
                return;
            }
            return;
        }
    }

    public PruneTaskRetryTransform() {
        Logging.$init$((Logging)this);
    }
}

