/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceResource
extends CPUResource {
    private final int instances;

    public InstanceResource(int instances) {
        super(instances);
        this.instances = instances;
    }

    public InstanceResource() {
        super(Integer.MAX_VALUE);
        this.instances = Integer.MAX_VALUE;
    }

    public int getInstances() {
        return this.instances;
    }

    @Override
    public Resource toResource(int cores) {
        return new InstanceResource(cores);
    }

    @Override
    public String toJson() {
        return String.format("Instance: %d", this.instances);
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

