/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.label.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtils;

public abstract class SerializableLabel<T>
implements Label<T> {
    private static final Map<Class<?>, List<String>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    protected static final String VALUE_SEPARATOR = "-";
    protected static final String[] VALUE_METHOD_PREFIX = new String[]{"is", "get", "set"};
    protected static final String SET_VALUE_METHOD_PREFIX = "set";
    @JsonIgnore
    protected T value;
    private String stringValue;

    public abstract String getFeatureKey();

    @Override
    public String getStringValue() {
        if (StringUtils.isBlank((CharSequence)this.stringValue) && null != this.value) {
            if (LabelUtils.isBasicType(this.value.getClass())) {
                this.stringValue = String.valueOf(this.value);
            } else if (this.value instanceof List) {
                this.stringValue = StringUtils.join((Iterable)((List)this.value), (String)VALUE_SEPARATOR);
            } else {
                List valueSerial;
                List<String> orderedValueNames;
                Map valueMap = (Map)LabelUtils.Jackson.convert(this.value, Map.class, String.class, String.class);
                if (StringUtils.isNotBlank((CharSequence)this.getFeatureKey())) {
                    valueMap.remove(this.getFeatureKey());
                }
                if (null == (orderedValueNames = CACHE.get(this.getClass()))) {
                    orderedValueNames = LabelUtils.getOrderedValueNameInLabelClass(this.getClass(), VALUE_METHOD_PREFIX);
                    CACHE.put(this.getClass(), orderedValueNames);
                }
                if ((valueSerial = new ArrayList<String>(orderedValueNames).stream().map(valueMap::get).filter(Objects::nonNull).collect(Collectors.toList())).size() == orderedValueNames.size()) {
                    this.stringValue = StringUtils.join(valueSerial, (String)VALUE_SEPARATOR);
                }
            }
        }
        return this.stringValue;
    }

    protected void setStringValue(String stringValue) {
        if (StringUtils.isNotBlank((CharSequence)stringValue)) {
            String[] stringValueArray = stringValue.split(VALUE_SEPARATOR);
            List<String> orderedValueNames = CACHE.get(this.getClass());
            if (null == orderedValueNames) {
                orderedValueNames = LabelUtils.getOrderedValueNameInLabelClass(this.getClass(), VALUE_METHOD_PREFIX);
                CACHE.put(this.getClass(), orderedValueNames);
            }
            if (stringValueArray.length != orderedValueNames.size()) {
                return;
            }
            for (int i = 0; i < orderedValueNames.size(); ++i) {
                String valueName = orderedValueNames.get(i);
                try {
                    Method method = this.getClass().getMethod(SET_VALUE_METHOD_PREFIX + valueName.substring(0, 1).toUpperCase() + valueName.substring(1), String.class);
                    method.invoke((Object)this, stringValueArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public final String toString() {
        return "[key: " + this.getLabelKey() + ", value: " + LabelUtils.Jackson.toJson(this.value, null) + ", str: " + this.getStringValue() + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof SerializableLabel) {
            String otherSerialStr = other.toString();
            String serialStr = this.toString();
            return StringUtils.isNotBlank((CharSequence)serialStr) && this.toString().equals(otherSerialStr);
        }
        return super.equals(other);
    }

    @Override
    public Boolean isEmpty() {
        return null == this.getValue();
    }
}

