/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hive.common.util.DateParser;

public class CastStringToDate
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int inputColumn;
    private final transient DateParser dateParser = new DateParser();

    public CastStringToDate() {
        this.inputColumn = -1;
    }

    public CastStringToDate(int inputColumn, int outputColumnNum) {
        super(outputColumnNum);
        this.inputColumn = inputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        boolean[] inputIsNull = inV.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inV.isRepeating) {
            if (inV.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.evaluate(outputColVector, inV, 0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inV.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.evaluate(outputColVector, inV, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluate(outputColVector, inV, i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.evaluate(outputColVector, inV, i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!inputIsNull[i]) {
                        outputColVector.isNull[i] = false;
                        this.evaluate(outputColVector, inV, i);
                        continue;
                    }
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (!inputIsNull[i]) {
                        outputColVector.isNull[i] = false;
                        this.evaluate(outputColVector, inV, i);
                        continue;
                    }
                    outputColVector.isNull[i] = true;
                    outputColVector.noNulls = false;
                }
            }
        }
    }

    private void evaluate(LongColumnVector outputColVector, BytesColumnVector inV, int i) {
        String dateString = new String(inV.vector[i], inV.start[i], inV.length[i], StandardCharsets.UTF_8);
        Date hDate = new Date();
        if (this.dateParser.parseDate(dateString, hDate)) {
            outputColVector.vector[i] = DateWritableV2.dateToDays(hDate);
            return;
        }
        outputColVector.vector[i] = 1L;
        outputColVector.isNull[i] = true;
        outputColVector.noNulls = false;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumn);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

