/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.storage.csv.CSVFsWriter;
import org.apache.linkis.storage.domain.DataType$;
import org.apache.linkis.storage.resultset.table.TableMetaData;
import org.apache.linkis.storage.resultset.table.TableRecord;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005g!A\u0011\t\u0001BC\u0002\u0013\u0005!\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00034\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011)\u0003!Q1A\u0005\u0002-C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\b9\u0002\u0001\r\u0011\"\u0001E\u0011\u001di\u0006\u00011A\u0005\u0002yCa\u0001\u001a\u0001!B\u0013)\u0005\"B+\u0001\t\u0003)\u0007bB6\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007a\u0002\u0001\u000b\u0011B7\t\u000fE\u0004!\u0019!C\u0005e\"1A\u0010\u0001Q\u0001\nMDQ! \u0001\u0005ByDq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002X\u0001!I!!\u0017\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAE\u0001\u0011\u0005\u0013q\u0011\u0002\u0011'R|'/Y4f\u0007N3vK]5uKJT!AG\u000e\u0002\u0007\r\u001chO\u0003\u0002\u001d;\u000591\u000f^8sC\u001e,'B\u0001\u0010 \u0003\u0019a\u0017N\\6jg*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0013*!\t1s%D\u0001\u001a\u0013\tA\u0013DA\u0006D'Z35o\u0016:ji\u0016\u0014\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\u0015)H/\u001b7t\u0015\tqS$\u0001\u0004d_6lwN\\\u0005\u0003a-\u0012q\u0001T8hO&tw-A\u0004dQ\u0006\u00148/\u001a;\u0016\u0003M\u0002\"\u0001N\u001f\u000f\u0005UZ\u0004C\u0001\u001c:\u001b\u00059$B\u0001\u001d$\u0003\u0019a$o\\8u})\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta\u0014(\u0001\u0005dQ\u0006\u00148/\u001a;!\u0003%\u0019X\r]1sCR|'/\u0001\u0006tKB\f'/\u0019;pe\u0002\n!#];pi\u0016\u0014V\r^8vG\",e.\u00192mKV\tQ\t\u0005\u0002G\u000f6\t\u0011(\u0003\u0002Is\t9!i\\8mK\u0006t\u0017aE9v_R,'+\u001a;pk\u000eDWI\\1cY\u0016\u0004\u0013\u0001D8viB,Ho\u0015;sK\u0006lW#\u0001'\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016AA5p\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015(\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u001b=,H\u000f];u'R\u0014X-Y7!\u0003\u0019a\u0014N\\5u}Q)q\u000bW-[7B\u0011a\u0005\u0001\u0005\u0006c%\u0001\ra\r\u0005\u0006\u0003&\u0001\ra\r\u0005\u0006\u0007&\u0001\r!\u0012\u0005\u0006\u0015&\u0001\r\u0001T\u0001\fW\u0016,\u0007OT3xY&tW-A\blK\u0016\u0004h*Z<mS:,w\fJ3r)\ty&\r\u0005\u0002GA&\u0011\u0011-\u000f\u0002\u0005+:LG\u000fC\u0004d\u0017\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'\u0001\u0007lK\u0016\u0004h*Z<mS:,\u0007\u0005\u0006\u0004XM\u001eD\u0017N\u001b\u0005\u0006c5\u0001\ra\r\u0005\u0006\u00036\u0001\ra\r\u0005\u0006\u00076\u0001\r!\u0012\u0005\u0006\u00156\u0001\r\u0001\u0014\u0005\u000696\u0001\r!R\u0001\nI\u0016d\u0017.\\5uKJ,\u0012!\u001c\t\u0003\r:L!a\\\u001d\u0003\u0007\u0005s\u00170\u0001\u0006eK2LW.\u001b;fe\u0002\naAY;gM\u0016\u0014X#A:\u0011\u0005QLhBA;x\u001d\t1d/C\u0001;\u0013\tA\u0018(A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(!D*ue&twMQ;jY\u0012,'O\u0003\u0002ys\u00059!-\u001e4gKJ\u0004\u0013aC1eI6+G/\u0019#bi\u0006$\"aX@\t\u000f\u0005\u0005!\u00031\u0001\u0002\u0004\u0005AQ.\u001a;b\t\u0006$\u0018\r\u0005\u0003\u0002\u0006\u0005%QBAA\u0004\u0015\tyU&\u0003\u0003\u0002\f\u0005\u001d!\u0001C'fi\u0006$\u0015\r^1)\u000bI\ty!a\u0007\u0011\u000b\u0019\u000b\t\"!\u0006\n\u0007\u0005M\u0011H\u0001\u0004uQJ|wo\u001d\t\u0004\u001b\u0006]\u0011bAA\r\u001d\nY\u0011jT#yG\u0016\u0004H/[8oc\u0019q2'!\b\u0002HEJ1%a\b\u0002&\u0005u\u0012qE\u000b\u0004e\u0005\u0005BaBA\u0012G\t\u0007\u0011Q\u0006\u0002\u0002)&!\u0011qEA\u0015\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111F\u001d\u0002\rQD'o\\<t#\u0011\ty#!\u000e\u0011\u0007\u0019\u000b\t$C\u0002\u00024e\u0012qAT8uQ&tw\r\u0005\u0003\u00028\u0005ebB\u0001$x\u0013\r\tYd\u001f\u0002\n)\"\u0014xn^1cY\u0016\f\u0014bIA \u0003\u0003\n\u0019%a\u000b\u000f\u0007\u0019\u000b\t%C\u0002\u0002,e\nTA\t$:\u0003\u000b\u0012Qa]2bY\u0006\f4AJA\u000b\u0003\u001d\u0019w.\u001c9bGR$2aMA'\u0011\u001d\tye\u0005a\u0001\u0003#\n1A]8x!\u00111\u00151K\u001a\n\u0007\u0005U\u0013HA\u0003BeJ\f\u00170A\u0003xe&$X\r\u0006\u0003\u0002\\\u0005%\u0004\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\b[V$\u0018M\u00197f\u0015\r\t)'O\u0001\u000bG>dG.Z2uS>t\u0017b\u0001>\u0002`!9\u0011q\n\u000bA\u0002\u0005E\u0013!C1eIJ+7m\u001c:e)\ry\u0016q\u000e\u0005\b\u0003c*\u0002\u0019AA:\u0003\u0019\u0011XmY8sIB!\u0011QAA;\u0013\u0011\t9(a\u0002\u0003\rI+7m\u001c:eQ\u0015)\u0012qBA>c\u0019q2'! \u0002\u0004FJ1%a\b\u0002&\u0005}\u0014qE\u0019\nG\u0005}\u0012\u0011IAA\u0003W\tTA\t$:\u0003\u000b\n4AJA\u000b\u0003\u00151G.^:i)\u0005y\u0016!B2m_N,\u0007")
public class StorageCSVWriter
extends CSVFsWriter
implements Logging {
    private final String charset;
    private final String separator;
    private final boolean quoteRetouchEnable;
    private final OutputStream outputStream;
    private boolean keepNewline;
    private final Object delimiter;
    private final scala.collection.mutable.StringBuilder buffer;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageCSVWriter storageCSVWriter = this;
        synchronized (storageCSVWriter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    public boolean quoteRetouchEnable() {
        return this.quoteRetouchEnable;
    }

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public boolean keepNewline() {
        return this.keepNewline;
    }

    public void keepNewline_$eq(boolean x$1) {
        this.keepNewline = x$1;
    }

    private Object delimiter() {
        return this.delimiter;
    }

    private scala.collection.mutable.StringBuilder buffer() {
        return this.buffer;
    }

    public void addMetaData(MetaData metaData) throws IOException {
        String[] head = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TableMetaData)metaData).columns())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.columnName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.write(head);
    }

    private String compact(String[] row) {
        String quotationMarks = "\"";
        String dealNewlineSymbolMarks = "\n";
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(new StringBuilder(10).append("delimiter:").append(this.delimiter().toString()).toString());
        }
        return new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).map((Function1 & Serializable & scala.Serializable)x -> this.decorateValue$1((String)x, quotationMarks, dealNewlineSymbolMarks), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toList().mkString(this.delimiter().toString())).append("\n").toString();
    }

    private scala.collection.mutable.StringBuilder write(String[] row) {
        String content;
        block0: {
            content = this.compact(row);
            if (this.buffer().length() + content.length() <= 49500) break block0;
            IOUtils.write((byte[])this.buffer().toString().getBytes(this.charset()), (OutputStream)this.outputStream());
            this.buffer().clear();
        }
        return this.buffer().append(content);
    }

    public void addRecord(Record record) throws IOException {
        String[] body = (String[])Predef$.MODULE$.genericArrayOps((Object)((TableRecord)record).row()).map((Function1 & Serializable & scala.Serializable)value -> DataType$.MODULE$.valueToString(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.write(body);
    }

    public void flush() {
        IOUtils.write((byte[])this.buffer().toString().getBytes(this.charset()), (OutputStream)this.outputStream());
        this.buffer().clear();
    }

    public void close() {
        this.flush();
        IOUtils.closeQuietly((OutputStream)this.outputStream());
    }

    private final String decorateValue$1(String v, String quotationMarks$1, String dealNewlineSymbolMarks$1) {
        if (StringUtils.isBlank((CharSequence)v)) {
            return v;
        }
        String res = v;
        if (this.quoteRetouchEnable()) {
            res = new StringBuilder(0).append(quotationMarks$1).append(v.replaceAll(quotationMarks$1, "")).append(quotationMarks$1).toString();
        }
        if (!this.keepNewline()) {
            res = res.replaceAll(dealNewlineSymbolMarks$1, " ");
        }
        this.logger().debug(new StringBuilder(33).append("decorateValue with input:").append(v).append(" output:").append(res).toString());
        return res;
    }

    public StorageCSVWriter(String charset, String separator, boolean quoteRetouchEnable, OutputStream outputStream) {
        this.charset = charset;
        this.separator = separator;
        this.quoteRetouchEnable = quoteRetouchEnable;
        this.outputStream = outputStream;
        Logging.$init$((Logging)this);
        this.keepNewline = false;
        String string = separator;
        this.delimiter = "t".equals(string) ? BoxesRunTime.boxToCharacter((char)'\t') : (StringUtils.isNotEmpty((CharSequence)string) ? string : BoxesRunTime.boxToCharacter((char)'\t'));
        this.buffer = new scala.collection.mutable.StringBuilder(50000);
    }

    public StorageCSVWriter(String charset, String separator, boolean quoteRetouchEnable, OutputStream outputStream, boolean keepNewline) {
        this(charset, separator, quoteRetouchEnable, outputStream);
        this.keepNewline_$eq(keepNewline);
    }
}

