/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.fs.impl;

import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.storage.errorcode.LinkisStorageErrorCodeSummary;
import org.apache.linkis.storage.exception.StorageWarnException;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.StorageConfiguration;
import org.apache.linkis.storage.utils.StorageUtils;

public class AzureBlobFileSystem
extends FileSystem {
    private static final String SLASH = "/";
    private BlobServiceClient serviceClient;

    private BlobContainerClient getBlobContainerClient(String containerName) {
        return this.serviceClient.getBlobContainerClient(containerName);
    }

    private PahtInfo azureLocation(String path) {
        return this.azureLocation(new FsPath(path));
    }

    private PahtInfo azureLocation(FsPath dest) {
        String path = dest.getPath();
        String[] paths = path.split(SLASH, 2);
        if (paths.length < 2) {
            throw new IllegalArgumentException("file path error,with out container:" + path);
        }
        String[] names = paths[1].split(SLASH, 2);
        if (names.length < 2) {
            return new PahtInfo(paths[0], names[0], null);
        }
        return new PahtInfo(paths[0], names[0], names[1]);
    }

    public void init(Map<String, String> properties) throws IOException {
        String acctName = (String)StorageConfiguration.AZURE_ACCT_NAME().getValue(properties);
        String connectStr = (String)StorageConfiguration.AZURE_ACCT_CONNECT_STR().getValue(properties);
        this.serviceClient = new BlobServiceClientBuilder().endpoint(StorageUtils.BLOB_SCHEMA() + acctName + ".blob.core.windows.net/").connectionString(connectStr).buildClient();
    }

    public String fsName() {
        return StorageUtils.BLOB();
    }

    public String rootUserName() {
        return "";
    }

    public FsPath get(String dest) throws IOException {
        FsPath path = new FsPath(dest);
        if (this.exists(path)) {
            return path;
        }
        throw new StorageWarnException(LinkisStorageErrorCodeSummary.TO_BE_UNKNOW.getErrorCode(), "File or folder does not exist or file name is garbled(\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u4e71\u7801)");
    }

    public InputStream read(FsPath dest) {
        PahtInfo result = this.azureLocation(dest);
        BlobClient blobclient = this.getBlobContainerClient(result.getContainer()).getBlobClient(result.getBlobName());
        return blobclient.openInputStream();
    }

    public OutputStream write(FsPath dest, boolean overwrite) {
        PahtInfo result = this.azureLocation(dest);
        BlobClient blobclient = this.getBlobContainerClient(result.getContainer()).getBlobClient(result.getBlobName());
        return blobclient.getBlockBlobClient().getBlobOutputStream(overwrite);
    }

    public boolean create(String dest) throws IOException {
        FsPath path = new FsPath(dest);
        if (this.exists(path)) {
            return false;
        }
        PahtInfo names = this.azureLocation(dest);
        if (!names.getTail().contains(".")) {
            String tmp = names.toFullName() + SLASH + "_tmp.txt";
            names = this.azureLocation(tmp);
        }
        BlobContainerClient client = this.serviceClient.createBlobContainerIfNotExists(names.getContainer());
        try (BlobOutputStream bos = client.getBlobClient(names.getBlobName()).getBlockBlobClient().getBlobOutputStream();){
            bos.write(1);
            bos.flush();
        }
        return true;
    }

    public List<FsPath> list(FsPath path) throws IOException {
        PahtInfo result = this.azureLocation(path);
        return this.getBlobContainerClient(result.getContainer()).listBlobs().stream().filter(item -> !item.isDeleted()).map(item -> {
            FsPath tmp = new FsPath(result.toFullName() + SLASH + item.getName());
            if (item.getProperties().getContentType() == null) {
                tmp.setIsdir(true);
            }
            return tmp;
        }).collect(Collectors.toList());
    }

    public boolean canRead(FsPath dest) throws IOException {
        return this.exists(dest);
    }

    public boolean canRead(FsPath dest, String user) throws IOException {
        return false;
    }

    public boolean canWrite(FsPath dest) throws IOException {
        return this.exists(dest);
    }

    public boolean exists(FsPath dest) throws IOException {
        PahtInfo file = this.azureLocation(dest);
        return this.getBlobContainerClient(file.getContainer()).getBlobClient(file.getBlobName()).exists();
    }

    public boolean delete(FsPath dest) throws IOException {
        PahtInfo file = this.azureLocation(dest);
        return this.getBlobContainerClient(file.getContainer()).getBlobClient(file.getBlobName()).deleteIfExists();
    }

    @Override
    public boolean copy(String origin, String dest) throws IOException {
        PahtInfo oriNames = this.azureLocation(origin);
        PahtInfo destNames = this.azureLocation(dest);
        BlobClient oriClient = this.getBlobContainerClient(oriNames.getContainer()).getBlobClient(oriNames.getBlobName());
        BlockBlobClient destClient = this.getBlobContainerClient(destNames.getContainer()).getBlobClient(destNames.getBlobName()).getBlockBlobClient();
        SyncPoller poller = destClient.beginCopy(oriClient.getBlobUrl(), Duration.ofSeconds(2L));
        poller.waitForCompletion();
        return true;
    }

    public boolean renameTo(FsPath oldDest, FsPath newDest) throws IOException {
        this.copy(oldDest.getPath(), newDest.getPath());
        this.delete(oldDest);
        return true;
    }

    public boolean mkdir(FsPath dest) throws IOException {
        return this.create(dest.getPath());
    }

    public boolean mkdirs(FsPath dest) throws IOException {
        return this.mkdir(dest);
    }

    @Override
    public String listRoot() throws IOException {
        return "";
    }

    @Override
    public long getTotalSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getFreeSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getUsableSpace(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public long getLength(FsPath dest) throws IOException {
        return 0L;
    }

    @Override
    public String checkSum(FsPath dest) throws IOException {
        return null;
    }

    @Override
    public boolean canExecute(FsPath dest) throws IOException {
        return false;
    }

    @Override
    public boolean setOwner(FsPath dest, String user, String group) throws IOException {
        return false;
    }

    @Override
    public boolean setOwner(FsPath dest, String user) throws IOException {
        return false;
    }

    @Override
    public boolean setGroup(FsPath dest, String group) throws IOException {
        return false;
    }

    @Override
    public boolean setPermission(FsPath dest, String permission) throws IOException {
        return false;
    }

    public void close() throws IOException {
    }

    public static class PahtInfo {
        private String schema = "http://";
        private String domain;
        private String container;
        private String blobName;
        private String tail;

        public PahtInfo(String domain, String container, String blobName) {
            this.domain = domain;
            this.container = container;
            this.blobName = blobName;
            if (blobName != null) {
                String[] names = blobName.split(AzureBlobFileSystem.SLASH, -1);
                this.tail = names[names.length - 1];
            }
        }

        public String toFullName() {
            return this.schema + this.domain + AzureBlobFileSystem.SLASH + this.container + AzureBlobFileSystem.SLASH + this.blobName;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getContainer() {
            return this.container;
        }

        public String getBlobName() {
            return this.blobName;
        }

        public String getTail() {
            return this.tail;
        }

        public String toString() {
            return "PahtInfo{schema='" + this.schema + '\'' + ", domain='" + this.domain + '\'' + ", container='" + this.container + '\'' + ", blobName='" + this.blobName + '\'' + ", tail='" + this.tail + '\'' + '}';
        }
    }
}

