/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.script.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.storage.script.Parser;
import org.apache.linkis.storage.script.ParserFactory$;
import org.apache.linkis.storage.script.ScriptFsReader;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.ScriptRecord;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.utils.StorageUtils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0011#\u0001=B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005m!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!b\u0001\n\u0003\u0001\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000be\u0003A\u0011\u0001.\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0013\t\u0007\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%i\u0007\u00011A\u0001B\u0003&!\rC\u0005o\u0001\u0001\u0007\t\u0019!C\u0005_\"I1\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001e\u0005\nm\u0002\u0001\r\u0011!Q!\nAD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\b\"C@\u0001\u0001\u0004\u0005\t\u0015)\u0003z\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019\u0001C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e!A\u0011\u0011\u0005\u0001!B\u0013\t)\u0001\u0003\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0001C1\"!\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(!Q\u00111\u0006\u0001A\u0002\u0003\u0005\u000b\u0015B!\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a1\u0001\t\u0003\n)\rC\u0004\u0002Z\u0002!\t%a,\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002\u0012\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bbBA}\u0001\u0011\u0005\u00111 \u0002\u0016'R|'/Y4f'\u000e\u0014\u0018\u000e\u001d;GgJ+\u0017\rZ3s\u0015\t\u0019C%\u0001\u0004sK\u0006$WM\u001d\u0006\u0003K\u0019\naa]2sSB$(BA\u0014)\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u000b\u0016\u0002\r1Lgn[5t\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cIj\u0011\u0001J\u0005\u0003g\u0011\u0012abU2sSB$hi\u001d*fC\u0012,'/\u0001\u0003qCRDW#\u0001\u001c\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014AA5p\u0015\tY\u0004&\u0001\u0004d_6lwN\\\u0005\u0003{a\u0012aAR:QCRD\u0017!\u00029bi\"\u0004\u0013aB2iCJ\u001cX\r^\u000b\u0002\u0003B\u0011!i\u0013\b\u0003\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0018\u0002\rq\u0012xn\u001c;?\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005);\u0015\u0001C2iCJ\u001cX\r\u001e\u0011\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\\\u000b\u0002#B\u0011!KV\u0007\u0002'*\u0011\u0011\b\u0016\u0006\u0002+\u0006!!.\u0019<b\u0013\t96KA\u0006J]B,Ho\u0015;sK\u0006l\u0017\u0001D5oaV$8\u000b\u001e:fC6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003\\;z{\u0006C\u0001/\u0001\u001b\u0005\u0011\u0003\"\u0002\u001b\b\u0001\u00041\u0004\"B \b\u0001\u0004\t\u0005\"B(\b\u0001\u0004\t\u0016!E5oaV$8\u000b\u001e:fC6\u0014V-\u00193feV\t!\r\u0005\u0002SG&\u0011Am\u0015\u0002\u0012\u0013:\u0004X\u000f^*ue\u0016\fWNU3bI\u0016\u0014\u0018!F5oaV$8\u000b\u001e:fC6\u0014V-\u00193fe~#S-\u001d\u000b\u0003O.\u0004\"\u0001[5\u000e\u0003\u001dK!A[$\u0003\tUs\u0017\u000e\u001e\u0005\bY&\t\t\u00111\u0001c\u0003\rAH%M\u0001\u0013S:\u0004X\u000f^*ue\u0016\fWNU3bI\u0016\u0014\b%\u0001\bck\u001a4WM]3e%\u0016\fG-\u001a:\u0016\u0003A\u0004\"AU9\n\u0005I\u001c&A\u0004\"vM\u001a,'/\u001a3SK\u0006$WM]\u0001\u0013EV4g-\u001a:fIJ+\u0017\rZ3s?\u0012*\u0017\u000f\u0006\u0002hk\"9A\u000eDA\u0001\u0002\u0004\u0001\u0018a\u00042vM\u001a,'/\u001a3SK\u0006$WM\u001d\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012!\u001f\t\u0003ciL!a\u001f\u0013\u0003\u001dM\u001b'/\u001b9u\u001b\u0016$\u0018\rR1uC\u0006aQ.\u001a;bI\u0006$\u0018m\u0018\u0013fcR\u0011qM \u0005\bY>\t\t\u00111\u0001z\u0003%iW\r^1eCR\f\u0007%A\u0005wCJL\u0017M\u00197fgV\u0011\u0011Q\u0001\t\u0007\u0003\u000f\t\t\"!\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tq!\\;uC\ndWMC\u0002\u0002\u0010\u001d\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004c\u0005]\u0011bAA\rI\tAa+\u0019:jC\ndW-A\u0007wCJL\u0017M\u00197fg~#S-\u001d\u000b\u0004O\u0006}\u0001\u0002\u00037\u0013\u0003\u0003\u0005\r!!\u0002\u0002\u0015Y\f'/[1cY\u0016\u001c\b%\u0001\u0005mS:,G+\u001a=u\u00031a\u0017N\\3UKb$x\fJ3r)\r9\u0017\u0011\u0006\u0005\bYV\t\t\u00111\u0001B\u0003%a\u0017N\\3UKb$\b%A\u0005hKR\u0014VmY8sIV\u0011\u0011\u0011\u0007\t\u0004o\u0005M\u0012bAA\u001bq\t1!+Z2pe\u0012DSaFA\u001d\u0003\u000b\u0002R\u0001[A\u001e\u0003\u007fI1!!\u0010H\u0005\u0019!\bN]8xgB\u0019!+!\u0011\n\u0007\u0005\r3KA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017G\u0002\u0010B\u0003\u000f\n9(M\u0005$\u0003\u0013\ny%!\u001c\u0002RU\u0019\u0001)a\u0013\u0005\u000f\u00055cF1\u0001\u0002X\t\tA+\u0003\u0003\u0002R\u0005M\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002V\u001d\u000ba\u0001\u001e5s_^\u001c\u0018\u0003BA-\u0003?\u00022\u0001[A.\u0013\r\tif\u0012\u0002\b\u001d>$\b.\u001b8h!\u0011\t\t'a\u001a\u000f\u0007!\f\u0019'C\u0002\u0002f\u001d\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0005-$!\u0003+ie><\u0018M\u00197f\u0015\r\t)gR\u0019\nG\u0005=\u0014\u0011OA:\u0003+r1\u0001[A9\u0013\r\t)fR\u0019\u0006E!<\u0015Q\u000f\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005}\u0012aC4fi6+G/\u0019#bi\u0006,\"!! \u0011\u0007]\ny(C\u0002\u0002\u0002b\u0012\u0001\"T3uC\u0012\u000bG/\u0019\u0015\u00061\u0005e\u0012QQ\u0019\u0007=\u0005\u000b9)!$2\u0013\r\nI%a\u0014\u0002\n\u0006E\u0013'C\u0012\u0002p\u0005E\u00141RA+c\u0015\u0011\u0003nRA;c\r1\u0013qH\u0001\u0005S:LG\u000fF\u0001h\u0003\u0011\u00198.\u001b9\u0015\t\u0005]\u0015Q\u0014\t\u0004Q\u0006e\u0015bAAN\u000f\n\u0019\u0011J\u001c;\t\u000f\u0005}%\u00041\u0001\u0002\u0018\u0006I!/Z2pe\u0012tU/\u001c\u0015\u00065\u0005e\u00121U\u0019\u0007=\u0005\u000b)+a+2\u0013\r\nI%a\u0014\u0002(\u0006E\u0013'C\u0012\u0002p\u0005E\u0014\u0011VA+c\u0015\u0011\u0003nRA;c\r1\u0013qH\u0001\fO\u0016$\bk\\:ji&|g.\u0006\u0002\u00022B\u0019\u0001.a-\n\u0007\u0005UvI\u0001\u0003M_:<\u0007&B\u000e\u0002:\u0005e\u0016G\u0002\u0010B\u0003w\u000b\t-M\u0005$\u0003\u0013\ny%!0\u0002REJ1%a\u001c\u0002r\u0005}\u0016QK\u0019\u0006E!<\u0015QO\u0019\u0004M\u0005}\u0012a\u00025bg:+\u0007\u0010^\u000b\u0003\u0003\u000f\u00042\u0001[Ae\u0013\r\tYm\u0012\u0002\b\u0005>|G.Z1oQ\u0015a\u0012\u0011HAhc\u0019q\u0012)!5\u0002XFJ1%!\u0013\u0002P\u0005M\u0017\u0011K\u0019\nG\u0005=\u0014\u0011OAk\u0003+\nTA\t5H\u0003k\n4AJA \u0003%\tg/Y5mC\ndW\rK\u0003\u001e\u0003s\ti.\r\u0004\u001f\u0003\u0006}\u0017Q]\u0019\nG\u0005%\u0013qJAq\u0003#\n\u0014bIA8\u0003c\n\u0019/!\u00162\u000b\tBw)!\u001e2\u0007\u0019\ny$A\u0003dY>\u001cX-\u0001\u0006jg6+G/\u00193bi\u0006$\u0002\"a2\u0002n\u0006E\u0018Q\u001f\u0005\u0007\u0003_|\u0002\u0019A!\u0002\t1Lg.\u001a\u0005\u0007\u0003g|\u0002\u0019A!\u0002\rA\u0014XMZ5y\u0011\u0019\t9p\ba\u0001\u0003\u0006Q\u0001O]3gSb\u001cuN\u001c4\u0002\u001f\u001d,GoU2sSB$\b+\u0019:tKJ$\"!!@\u0011\u0007E\ny0C\u0002\u0003\u0002\u0011\u0012a\u0001U1sg\u0016\u0014\b")
public class StorageScriptFsReader
extends ScriptFsReader {
    private final FsPath path;
    private final String charset;
    private final InputStream inputStream;
    private InputStreamReader inputStreamReader;
    private BufferedReader bufferedReader;
    private ScriptMetaData metadata;
    private ArrayBuffer<Variable> variables;
    private String lineText;

    @Override
    public FsPath path() {
        return this.path;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    private InputStreamReader inputStreamReader() {
        return this.inputStreamReader;
    }

    private void inputStreamReader_$eq(InputStreamReader x$1) {
        this.inputStreamReader = x$1;
    }

    private BufferedReader bufferedReader() {
        return this.bufferedReader;
    }

    private void bufferedReader_$eq(BufferedReader x$1) {
        this.bufferedReader = x$1;
    }

    private ScriptMetaData metadata() {
        return this.metadata;
    }

    private void metadata_$eq(ScriptMetaData x$1) {
        this.metadata = x$1;
    }

    private ArrayBuffer<Variable> variables() {
        return this.variables;
    }

    private void variables_$eq(ArrayBuffer<Variable> x$1) {
        this.variables = x$1;
    }

    private String lineText() {
        return this.lineText;
    }

    private void lineText_$eq(String x$1) {
        this.lineText = x$1;
    }

    public Record getRecord() throws IOException {
        if (this.metadata() == null) {
            throw new IOException("Must read metadata first(\u5fc5\u987b\u5148\u8bfb\u53d6metadata)");
        }
        ScriptRecord record = new ScriptRecord(this.lineText());
        this.lineText_$eq(this.bufferedReader().readLine());
        return record;
    }

    public MetaData getMetaData() throws IOException {
        if (this.metadata() == null) {
            this.init();
        }
        Parser parser = this.getScriptParser();
        this.lineText_$eq(this.bufferedReader().readLine());
        while (this.hasNext() && parser != null && this.isMetadata(this.lineText(), parser.prefix(), parser.prefixConf())) {
            this.variables().$plus$eq((Object)parser.parse(this.lineText()));
            this.lineText_$eq(this.bufferedReader().readLine());
        }
        this.metadata_$eq(new ScriptMetaData((Variable[])this.variables().toArray(ClassTag$.MODULE$.apply(Variable.class))));
        return this.metadata();
    }

    public void init() {
        this.inputStreamReader_$eq(new InputStreamReader(this.inputStream()));
        this.bufferedReader_$eq(new BufferedReader(this.inputStreamReader()));
    }

    public int skip(int recordNum) throws IOException {
        int n;
        if (recordNum < 0) {
            return -1;
        }
        Object object = this.metadata() == null ? this.getMetaData() : BoxedUnit.UNIT;
        try {
            n = (int)this.bufferedReader().skip(recordNum);
        }
        catch (Throwable t) {
            n = recordNum;
        }
        return n;
    }

    public long getPosition() throws IOException {
        return -1L;
    }

    public boolean hasNext() throws IOException {
        return this.lineText() != null;
    }

    public long available() throws IOException {
        if (this.inputStream() != null) {
            return this.inputStream().available();
        }
        return 0L;
    }

    public void close() {
        IOUtils.closeQuietly((Reader)this.bufferedReader());
        IOUtils.closeQuietly((Reader)this.inputStreamReader());
        IOUtils.closeQuietly((InputStream)this.inputStream());
    }

    public boolean isMetadata(String line, String prefix, String prefixConf) {
        String string;
        Regex regex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(24).append("\\s*").append(prefix).append("\\s*(.+)\\s*").append("=").append("\\s*(.+)\\s*").toString())).r();
        Option option = regex.unapplySeq((CharSequence)(string = line));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            return true;
        }
        String[] split = line.split("=");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split)).size() != 2) {
            return false;
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split[0].split(" "))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StorageScriptFsReader.$anonfun$isMetadata$1(x$1))))).size() != 4) {
            return false;
        }
        return ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])split[0].split(" "))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StorageScriptFsReader.$anonfun$isMetadata$2(x$2))))[0].equals(prefixConf);
    }

    public Parser getScriptParser() {
        Parser[] parsers = (Parser[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ParserFactory$.MODULE$.listParsers())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.belongTo(StorageUtils$.MODULE$.pathToSuffix(this.path().getPath()))));
        if (parsers.length > 0) {
            return parsers[0];
        }
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$isMetadata$1(String x$1) {
        String string = x$1;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$isMetadata$2(String x$2) {
        String string = x$2;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public StorageScriptFsReader(FsPath path, String charset, InputStream inputStream) {
        this.path = path;
        this.charset = charset;
        this.inputStream = inputStream;
        this.variables = new ArrayBuffer();
    }
}

