/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.MemoryResource;
import org.apache.linkis.manager.common.entity.resource.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoadResource
extends Resource {
    private final long memory;
    private final int cores;

    private LoadResource(Resource r) {
        if (r instanceof LoadResource) {
            LoadResource t = (LoadResource)r;
            this.memory = t.memory;
            this.cores = t.cores;
        } else if (r instanceof MemoryResource) {
            MemoryResource m = (MemoryResource)r;
            this.memory = m.getMemory();
            this.cores = 0;
        } else if (r instanceof CPUResource) {
            CPUResource c = (CPUResource)r;
            this.memory = 0L;
            this.cores = c.getCores();
        } else {
            this.memory = Long.MAX_VALUE;
            this.cores = Integer.MAX_VALUE;
        }
    }

    public LoadResource() {
        this(Long.MAX_VALUE, Integer.MAX_VALUE);
    }

    public LoadResource(long memory, int cores) {
        this.memory = memory;
        this.cores = cores;
    }

    @Override
    public LoadResource add(Resource r) {
        LoadResource temp = new LoadResource(r);
        return new LoadResource(this.memory + temp.memory, this.cores + temp.cores);
    }

    @Override
    public LoadResource minus(Resource r) {
        LoadResource temp = new LoadResource(r);
        return new LoadResource(this.memory - temp.memory, this.cores - temp.cores);
    }

    @Override
    public LoadResource multiplied(Resource r) {
        LoadResource temp = new LoadResource(r);
        return new LoadResource(this.memory * temp.memory, this.cores * temp.cores);
    }

    @Override
    public LoadResource multiplied(float rate) {
        return new LoadResource((long)((float)this.memory * rate), Math.round((float)this.cores * rate));
    }

    @Override
    public LoadResource divide(Resource r) {
        LoadResource temp = new LoadResource(r);
        return new LoadResource(this.memory / temp.memory, this.cores / temp.cores);
    }

    @Override
    public LoadResource divide(int rate) {
        return new LoadResource(this.memory / (long)rate, this.cores / rate);
    }

    @Override
    public boolean moreThan(Resource r) {
        LoadResource temp = new LoadResource(r);
        return this.memory > temp.memory && this.cores > temp.cores;
    }

    @Override
    public boolean caseMore(Resource r) {
        LoadResource temp = new LoadResource(r);
        return this.memory > temp.memory || this.cores > temp.cores;
    }

    @Override
    public boolean equalsTo(Resource r) {
        LoadResource temp = new LoadResource(r);
        return this.memory == temp.memory && this.cores == temp.cores;
    }

    @Override
    public boolean notLess(Resource r) {
        LoadResource temp = new LoadResource(r);
        return this.memory >= temp.memory && this.cores >= temp.cores;
    }

    @Override
    public boolean less(Resource r) {
        return !this.notLess(r);
    }

    @Override
    public int compare(Resource r) {
        LoadResource temp = new LoadResource(r);
        if (this.getMemory() > temp.getMemory()) {
            return 1;
        }
        if (this.getMemory() < temp.getMemory()) {
            return -1;
        }
        return Integer.compare(this.getCores(), temp.getCores());
    }

    @Override
    public String toJson() {
        return String.format("{\"memory\":%s,\"cpu\":%d}", ByteTimeUtils.bytesToString((long)this.memory), this.cores);
    }

    public String toString() {
        return this.toJson();
    }

    public long getMemory() {
        return this.memory;
    }

    public int getCores() {
        return this.cores;
    }
}

