/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.authentication.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.authentication.bo.Token;
import org.apache.linkis.gateway.authentication.bo.User;
import org.apache.linkis.gateway.authentication.bo.impl.TokenImpl;
import org.apache.linkis.gateway.authentication.conf.TokenConfiguration$;
import org.apache.linkis.gateway.authentication.dao.TokenDao;
import org.apache.linkis.gateway.authentication.entity.TokenEntity;
import org.apache.linkis.gateway.authentication.errorcode.LinkisGwAuthenticationErrorCodeSummary;
import org.apache.linkis.gateway.authentication.exception.TokenAuthException;
import org.apache.linkis.gateway.authentication.exception.TokenNotExistException;
import org.apache.linkis.gateway.authentication.service.TokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\r\u001a\u0001\u0019BQ!\r\u0001\u0005\u0002IB\u0011\u0002\u000e\u0001A\u0002\u0003\u0007I\u0011B\u001b\t\u0013q\u0002\u0001\u0019!a\u0001\n\u0013i\u0004\"C\"\u0001\u0001\u0004\u0005\t\u0015)\u00037\u0011\u001d\t\u0006A1A\u0005\nICa\u0001\u001d\u0001!\u0002\u0013\u0019\u0006\"B9\u0001\t\u0003\u0012\b\"\u0002=\u0001\t\u0003J\b\"\u0002?\u0001\t\u0003j\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011Q\u000f\u0001\u0005B\u0005\u0015\u0005bBA6\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003w\u0002A\u0011IAH\u0011\u001d\t)\n\u0001C!\u0003/\u0013!cQ1dQ\u0016$Gk\\6f]N+'O^5dK*\u0011!dG\u0001\bg\u0016\u0014h/[2f\u0015\taR$\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005yy\u0012aB4bi\u0016<\u0018-\u001f\u0006\u0003A\u0005\na\u0001\\5oW&\u001c(B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012a!\u00118z%\u00164\u0007C\u0001\u00180\u001b\u0005I\u0012B\u0001\u0019\u001a\u00051!vn[3o'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\t1\u0007\u0005\u0002/\u0001\u0005AAo\\6f]\u0012\u000bw.F\u00017!\t9$(D\u00019\u0015\tI4$A\u0002eC>L!a\u000f\u001d\u0003\u0011Q{7.\u001a8EC>\fA\u0002^8lK:$\u0015m\\0%KF$\"AP!\u0011\u0005!z\u0014B\u0001!*\u0005\u0011)f.\u001b;\t\u000f\t\u001b\u0011\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\u0002\u0013Q|7.\u001a8EC>\u0004\u0003F\u0001\u0003F!\t1u*D\u0001H\u0015\tA\u0015*\u0001\u0006b]:|G/\u0019;j_:T!AS&\u0002\u000f\u0019\f7\r^8ss*\u0011A*T\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u001d\u000e\nqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003!\u001e\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0015Q|7.\u001a8DC\u000eDW-F\u0001T!\u0011!Vl\u00186\u000e\u0003US!AV,\u0002\u000b\r\f7\r[3\u000b\u0005aK\u0016AB2p[6|gN\u0003\u0002[7\u00061qm\\8hY\u0016T\u0011\u0001X\u0001\u0004G>l\u0017B\u00010V\u00051au.\u00193j]\u001e\u001c\u0015m\u00195f!\t\u0001wM\u0004\u0002bKB\u0011!-K\u0007\u0002G*\u0011A-J\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019L\u0013A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u0015\u0011\u0005-tW\"\u00017\u000b\u00055\\\u0012A\u00012p\u0013\tyGNA\u0003U_.,g.A\u0006u_.,gnQ1dQ\u0016\u0004\u0013aC1eI:+w\u000fV8lK:$\"a\u001d<\u0011\u0005!\"\u0018BA;*\u0005\u001d\u0011un\u001c7fC:DQa^\u0004A\u0002)\fQ\u0001^8lK:\f1B]3n_Z,Gk\\6f]R\u00111O\u001f\u0005\u0006w\"\u0001\raX\u0001\ni>\\WM\u001c(b[\u0016\f1\"\u001e9eCR,Gk\\6f]R\u00111O \u0005\u0006o&\u0001\rA[\u0001\u0010C\u0012$Wk]3s\r>\u0014Hk\\6f]R)1/a\u0001\u0002\u0006!)1P\u0003a\u0001?\"9\u0011q\u0001\u0006A\u0002\u0005%\u0011\u0001B;tKJ\u00042a[A\u0006\u0013\r\ti\u0001\u001c\u0002\u0005+N,'/A\bbI\u0012Dun\u001d;G_J$vn[3o)\u0015\u0019\u00181CA\u000b\u0011\u0015Y8\u00021\u0001`\u0011\u0019\t9b\u0003a\u0001?\u0006\u0011\u0011\u000e]\u0001\u0017C\u0012$\u0007j\\:u\u0003:$Wk]3s\r>\u0014Hk\\6f]R91/!\b\u0002 \u0005\u0005\u0002\"B>\r\u0001\u0004y\u0006bBA\u0004\u0019\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0003/a\u0001\u0019A0\u0002%I,Wn\u001c<f+N,'OR8s)>\\WM\u001c\u000b\u0006g\u0006\u001d\u0012\u0011\u0006\u0005\u0006w6\u0001\ra\u0018\u0005\b\u0003\u000fi\u0001\u0019AA\u0005\u0003I\u0011X-\\8wK\"{7\u000f\u001e$peR{7.\u001a8\u0015\u000bM\fy#!\r\t\u000bmt\u0001\u0019A0\t\r\u0005]a\u00021\u0001`\u0003Iaw.\u00193U_.,gN\u0012:p[\u000e\u000b7\r[3\u0015\u0007)\f9\u0004C\u0003|\u001f\u0001\u0007q,A\fuQJ|w\u000fV8lK:\fU\u000f\u001e5Fq\u000e,\u0007\u000f^5p]RA\u0011QHA\"\u0003'\n)\u0006E\u0002)\u0003\u007fI1!!\u0011*\u0005\u001dqu\u000e\u001e5j]\u001eDq!!\u0012\u0011\u0001\u0004\t9%\u0001\u0011ho\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u0016\u0013(o\u001c:D_\u0012,7+^7nCJL\b\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u000553$A\u0005feJ|'oY8eK&!\u0011\u0011KA&\u0005\u0019b\u0015N\\6jg\u001e;\u0018)\u001e;iK:$\u0018nY1uS>tWI\u001d:pe\u000e{G-Z*v[6\f'/\u001f\u0005\u0006wB\u0001\ra\u0018\u0005\b\u0003/\u0002\u0002\u0019AA-\u0003\u0005)\u0007\u0003BA.\u0003KrA!!\u0018\u0002b9\u0019!-a\u0018\n\u0003)J1!a\u0019*\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001a\u0002j\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003GJ\u0013!G5t)>\\WM\\!dG\u0016\u0004H/\u00192mK^KG\u000f[+tKJ$Ra]A8\u0003cBQa^\tA\u0002)Da!a\u001d\u0012\u0001\u0004y\u0016\u0001C;tKJt\u0015-\\3\u0002\u0019%\u001cHk\\6f]Z\u000bG.\u001b3\u0015\u0007M\fI\bC\u0003x%\u0001\u0007!.A\rjgR{7.\u001a8BG\u000e,\u0007\u000f^1cY\u0016<\u0016\u000e\u001e5I_N$H#B:\u0002\u0000\u0005\u0005\u0005\"B<\u0014\u0001\u0004Q\u0007BBAB'\u0001\u0007q,\u0001\u0003i_N$HcA:\u0002\b\")1\u0010\u0006a\u0001?R)1/a#\u0002\u000e\")10\u0006a\u0001?\"1\u00111O\u000bA\u0002}#Ra]AI\u0003'CQa\u001f\fA\u0002}Ca!a!\u0017\u0001\u0004y\u0016A\u00023p\u0003V$\b\u000eF\u0004t\u00033\u000bY*!(\t\u000bm<\u0002\u0019A0\t\r\u0005Mt\u00031\u0001`\u0011\u0019\t\u0019i\u0006a\u0001?\"\u001a\u0001!!)\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KS1!a*N\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003W\u000b)KA\u0004TKJ4\u0018nY3")
public class CachedTokenService
implements TokenService {
    @Autowired
    private TokenDao org$apache$linkis$gateway$authentication$service$CachedTokenService$$tokenDao;
    private final LoadingCache<String, Token> tokenCache = CacheBuilder.newBuilder().maximumSize((long)TokenConfiguration$.MODULE$.TOKEN_CACHE_MAX_SIZE()).refreshAfterWrite((long)TokenConfiguration$.MODULE$.TOKEN_CACHE_EXPIRE_MINUTES(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Token>(this){
        private final /* synthetic */ CachedTokenService $outer;

        public Token load(String tokenName) {
            TokenEntity tokenEntity = this.$outer.org$apache$linkis$gateway$authentication$service$CachedTokenService$$tokenDao().selectTokenByName(tokenName);
            if (tokenEntity != null) {
                return new TokenImpl().convertFrom(tokenEntity);
            }
            throw new TokenNotExistException(LinkisGwAuthenticationErrorCodeSummary.INVALID_TOKEN.getErrorCode(), LinkisGwAuthenticationErrorCodeSummary.INVALID_TOKEN.getErrorDesc());
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    });

    public TokenDao org$apache$linkis$gateway$authentication$service$CachedTokenService$$tokenDao() {
        return this.org$apache$linkis$gateway$authentication$service$CachedTokenService$$tokenDao;
    }

    private void org$apache$linkis$gateway$authentication$service$CachedTokenService$$tokenDao_$eq(TokenDao x$1) {
        this.org$apache$linkis$gateway$authentication$service$CachedTokenService$$tokenDao = x$1;
    }

    private LoadingCache<String, Token> tokenCache() {
        return this.tokenCache;
    }

    @Override
    public boolean addNewToken(Token token) {
        return false;
    }

    @Override
    public boolean removeToken(String tokenName) {
        return false;
    }

    @Override
    public boolean updateToken(Token token) {
        return false;
    }

    @Override
    public boolean addUserForToken(String tokenName, User user) {
        return false;
    }

    @Override
    public boolean addHostForToken(String tokenName, String ip) {
        return false;
    }

    @Override
    public boolean addHostAndUserForToken(String tokenName, User user, String ip) {
        return false;
    }

    @Override
    public boolean removeUserForToken(String tokenName, User user) {
        return false;
    }

    @Override
    public boolean removeHostForToken(String tokenName, String ip) {
        return false;
    }

    private Token loadTokenFromCache(String tokenName) {
        if (tokenName == null) {
            throw new TokenAuthException(LinkisGwAuthenticationErrorCodeSummary.TOKEN_IS_NULL.getErrorCode(), MessageFormat.format(LinkisGwAuthenticationErrorCodeSummary.TOKEN_IS_NULL.getErrorDesc(), tokenName));
        }
        return (Token)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> (Token)this.tokenCache().get((Object)tokenName), (Function1 & Serializable & scala.Serializable)t -> {
            Throwable throwable = t;
            if (throwable instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)throwable;
                Throwable throwable2 = executionException.getCause();
                if (throwable2 instanceof TokenNotExistException) {
                    TokenNotExistException tokenNotExistException = (TokenNotExistException)((Object)((Object)throwable2));
                    throw this.throwTokenAuthException(LinkisGwAuthenticationErrorCodeSummary.NOT_EXIST_DB, tokenName, (Throwable)((Object)tokenNotExistException));
                }
                throw this.throwTokenAuthException(LinkisGwAuthenticationErrorCodeSummary.FAILED_TO_LOAD_TOKEN, tokenName, throwable2);
            }
            if (throwable instanceof UncheckedExecutionException) {
                UncheckedExecutionException uncheckedExecutionException = (UncheckedExecutionException)throwable;
                throw this.throwTokenAuthException(LinkisGwAuthenticationErrorCodeSummary.FAILED_TO_BAD_SQLGRAMMAR, tokenName, (Throwable)uncheckedExecutionException);
            }
            throw this.throwTokenAuthException(LinkisGwAuthenticationErrorCodeSummary.FAILED_TO_LOAD_TOKEN, tokenName, throwable);
        });
    }

    private Nothing$ throwTokenAuthException(LinkisGwAuthenticationErrorCodeSummary gwAuthenticationErrorCodeSummary, String tokenName, Throwable e) {
        TokenAuthException exception = new TokenAuthException(gwAuthenticationErrorCodeSummary.getErrorCode(), MessageFormat.format(gwAuthenticationErrorCodeSummary.getErrorDesc(), tokenName, e.getMessage()));
        exception.initCause(e);
        throw exception;
    }

    private boolean isTokenAcceptableWithUser(Token token, String userName) {
        return token != null && !token.isStale() && token.isUserLegal(userName);
    }

    private boolean isTokenValid(Token token) {
        return token != null && !token.isStale();
    }

    private boolean isTokenAcceptableWithHost(Token token, String host) {
        return token != null && !token.isStale() && token.isHostLegal(host);
    }

    @Override
    public boolean isTokenValid(String tokenName) {
        return this.isTokenValid(this.loadTokenFromCache(tokenName));
    }

    @Override
    public boolean isTokenAcceptableWithUser(String tokenName, String userName) {
        return this.isTokenAcceptableWithUser(this.loadTokenFromCache(tokenName), userName);
    }

    @Override
    public boolean isTokenAcceptableWithHost(String tokenName, String host) {
        return this.isTokenAcceptableWithHost(this.loadTokenFromCache(tokenName), host);
    }

    @Override
    public boolean doAuth(String tokenName, String userName, String host) {
        Token tmpToken = this.loadTokenFromCache(tokenName);
        boolean ok = true;
        if (!this.isTokenValid(tmpToken)) {
            ok = false;
            throw new TokenAuthException(LinkisGwAuthenticationErrorCodeSummary.TOKEN_IS_EXPIRED.getErrorCode(), MessageFormat.format(LinkisGwAuthenticationErrorCodeSummary.TOKEN_IS_EXPIRED.getErrorDesc(), tokenName));
        }
        if (!this.isTokenAcceptableWithUser(tmpToken, userName)) {
            ok = false;
            throw new TokenAuthException(LinkisGwAuthenticationErrorCodeSummary.ILLEGAL_TOKENUSER.getErrorCode(), MessageFormat.format(LinkisGwAuthenticationErrorCodeSummary.ILLEGAL_TOKENUSER.getErrorDesc(), userName));
        }
        if (!this.isTokenAcceptableWithHost(tmpToken, host)) {
            ok = false;
            throw new TokenAuthException(LinkisGwAuthenticationErrorCodeSummary.ILLEGAL_HOST.getErrorCode(), MessageFormat.format(LinkisGwAuthenticationErrorCodeSummary.ILLEGAL_HOST.getErrorDesc(), host));
        }
        return ok;
    }
}

