/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Feign;
import feign.Target;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.cloud.openfeign.FeignCircuitBreakerInvocationHandler;

public final class FeignCircuitBreaker {
    private FeignCircuitBreaker() {
        throw new IllegalStateException("Don't instantiate a utility class");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Feign.Builder {
        private CircuitBreakerFactory circuitBreakerFactory;
        private String feignClientName;
        private boolean circuitBreakerGroupEnabled;
        private CircuitBreakerNameResolver circuitBreakerNameResolver;

        Builder circuitBreakerFactory(CircuitBreakerFactory circuitBreakerFactory) {
            this.circuitBreakerFactory = circuitBreakerFactory;
            return this;
        }

        Builder feignClientName(String feignClientName) {
            this.feignClientName = feignClientName;
            return this;
        }

        Builder circuitBreakerGroupEnabled(boolean circuitBreakerGroupEnabled) {
            this.circuitBreakerGroupEnabled = circuitBreakerGroupEnabled;
            return this;
        }

        Builder circuitBreakerNameResolver(CircuitBreakerNameResolver circuitBreakerNameResolver) {
            this.circuitBreakerNameResolver = circuitBreakerNameResolver;
            return this;
        }

        public <T> T target(Target<T> target, T fallback) {
            return (T)this.build(fallback != null ? new FallbackFactory.Default<T>(fallback) : null).newInstance(target);
        }

        public <T> T target(Target<T> target, FallbackFactory<? extends T> fallbackFactory) {
            return (T)this.build(fallbackFactory).newInstance(target);
        }

        public <T> T target(Target<T> target) {
            return (T)this.build(null).newInstance(target);
        }

        public Feign build(FallbackFactory<?> nullableFallbackFactory) {
            super.invocationHandlerFactory((target, dispatch) -> new FeignCircuitBreakerInvocationHandler(this.circuitBreakerFactory, this.feignClientName, target, dispatch, nullableFallbackFactory, this.circuitBreakerGroupEnabled, this.circuitBreakerNameResolver));
            return super.build();
        }
    }
}

