/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.context.webflux;

import java.util.Locale;
import java.util.Map;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.spring5.context.webflux.ISpringWebFluxContext;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Mono;

public class SpringWebFluxContext
extends AbstractContext
implements ISpringWebFluxContext {
    private final ServerWebExchange exchange;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public SpringWebFluxContext(ServerWebExchange exchange) {
        this(exchange, null, null, null);
    }

    public SpringWebFluxContext(ServerWebExchange exchange, Locale locale) {
        this(exchange, null, locale, null);
    }

    public SpringWebFluxContext(ServerWebExchange exchange, Locale locale, Map<String, Object> variables) {
        this(exchange, null, locale, variables);
    }

    public SpringWebFluxContext(ServerWebExchange exchange, ReactiveAdapterRegistry reactiveAdapterRegistry, Locale locale, Map<String, Object> variables) {
        super(locale, variables);
        Validate.notNull((Object)exchange, (String)"ServerWebExchange cannot be null in Spring WebFlux contexts");
        this.exchange = exchange;
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    @Override
    public ServerHttpRequest getRequest() {
        return this.exchange.getRequest();
    }

    @Override
    public Mono<WebSession> getSession() {
        return this.exchange.getSession();
    }

    @Override
    public ServerHttpResponse getResponse() {
        return this.exchange.getResponse();
    }

    @Override
    public ServerWebExchange getExchange() {
        return this.exchange;
    }
}

