/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.common;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.constants.CliConstants;
import org.apache.linkis.cli.application.exception.LinkisClientExecutionException;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.common.ResultData;
import org.apache.linkis.cli.application.observer.event.FetchResultEvent;
import org.apache.linkis.cli.application.observer.event.LinkisClientEvent;
import org.apache.linkis.cli.application.observer.listener.LinkisClientListener;
import org.apache.linkis.cli.application.operator.ujes.LinkisJobOper;
import org.apache.linkis.cli.application.utils.CliUtils;
import org.apache.linkis.cli.application.utils.LoggerManager;
import org.apache.linkis.cli.application.utils.SchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ResultRetriever.class);
    private LinkisJobOper linkisJobOperator;
    private ResultData resultData;
    private LinkisClientListener resultListener;
    private LinkisClientEvent fetchResultEvent = new FetchResultEvent();

    public ResultRetriever(String user, String jobId, String execId, LinkisJobOper linkisJobOperator, LinkisClientListener resultListener) {
        this.linkisJobOperator = linkisJobOperator;
        this.resultListener = resultListener;
        this.resultData = new ResultData(user, jobId, execId);
        this.registerResultListener(resultListener);
    }

    public void retrieveResultSync() {
        if (this.resultData.getUser() == null || this.resultData.getJobID() == null) {
            throw new LinkisClientExecutionException("EXE0036", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "user or jobID is null");
        }
        this.resultData.updateByOperResult(this.linkisJobOperator.queryJobInfo(this.resultData.getUser(), this.resultData.getJobID()));
        if (this.resultData.getJobStatus() == null) {
            throw new LinkisClientExecutionException("EXE0038", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionErr, "jobStatus is null");
        }
        if (!this.resultData.getJobStatus().isJobSuccess()) {
            LoggerManager.getInformationLogger().info("Job status is not success but '" + this.resultData.getJobStatus() + "'. Will not try to retrieve any Result");
            this.resultData.setResultFin();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.resultData.getResultLocation())) {
            throw new LinkisClientExecutionException("EXE0037", ErrorLevel.WARN, (ErrorMsg)CommonErrMsg.ExecutionErr, "Got blank ResultLocation from server. Job may not have result-set. Will not try to retrieve any Result");
        }
        this.resultData.updateByOperResult(this.linkisJobOperator.queryResultSetPaths(this.resultData.getUser(), this.resultData.getJobID(), this.resultData.getResultLocation()));
        if (this.resultData.getResultSetPaths() == null || this.resultData.getResultSetPaths().length == 0) {
            String msg = "Your job got no result.";
            logger.warn(msg);
            this.resultData.setResultFin();
            this.resultData.setHasResult(false);
            return;
        }
        try {
            this.resultData.setHasResult(true);
            Thread resultThread = new Thread(() -> this.queryResultLoop(this.resultData), "Result-Retrieve-Thread");
            SchedulerManager.getCachedThreadPoolExecutor().execute(resultThread);
            this.notifyResultListener();
        }
        catch (Exception e) {
            logger.error("Failed to retrieve result", (Throwable)e);
            throw e;
        }
    }

    public void queryResultLoop(ResultData data) {
        block10: {
            boolean hasNext = true;
            int retryCnt = 0;
            int MAX_RETRY = 30;
            int idx = 0;
            while (true) {
                try {
                    if (!hasNext) break block10;
                    try {
                        hasNext = this.queryOneResult(data, idx);
                    }
                    catch (LinkisClientRuntimeException e) {
                        logger.error("Cannot get result:", (Throwable)e);
                        if (++retryCnt >= 30) {
                            logger.error("Continuously failing to query result for 480s. Will no longer try to query result", (Throwable)e);
                            data.setResultFin();
                            return;
                        }
                        hasNext = true;
                        CliUtils.doSleepQuietly(500L + 500L * (long)retryCnt);
                        continue;
                    }
                    ++idx;
                }
                catch (Exception e) {
                    logger.error("Something goes wrong. Job Result may be incomplete", (Throwable)e);
                    throw e;
                }
            }
            finally {
                data.setResultFin();
            }
        }
    }

    private boolean queryOneResult(ResultData data, int idxResultSet) {
        Integer curPage = 1;
        boolean hasNextResult = true;
        boolean hasNextPage = true;
        while (hasNextPage) {
            data.updateByOperResult(this.linkisJobOperator.queryResultSetGivenResultSetPath(data.getResultSetPaths(), idxResultSet, data.getUser(), curPage, CliConstants.RESULTSET_PAGE_SIZE));
            if (data.hasNextResultPage() == null) {
                throw new LinkisClientExecutionException("EXE0040", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ExecutionResultErr, "Something foes wrong. Got null as 'hasNextPage'.");
            }
            hasNextPage = data.hasNextResultPage();
            Integer n = curPage;
            Integer n2 = curPage = Integer.valueOf(curPage + 1);
            hasNextResult = idxResultSet + 1 < data.getResultSetPaths().length;
        }
        return hasNextResult;
    }

    public void registerResultListener(LinkisClientListener observer) {
        this.fetchResultEvent.register(observer);
    }

    public void notifyResultListener() {
        if (this.fetchResultEvent.isRegistered()) {
            this.fetchResultEvent.notifyObserver(this.fetchResultEvent, this.resultData);
        }
    }

    public void setResultFin() {
        this.resultData.setResultFin();
    }
}

