/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.job.jobcmd;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.entity.context.CliCtx;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdDesc;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdSubType;
import org.apache.linkis.cli.application.utils.CliUtils;

public class JobCmdDescBuilder {
    public static JobCmdDesc build(CliCtx ctx) {
        JobCmdDesc desc = new JobCmdDesc();
        String osUser = System.getProperty("user.name");
        String[] adminUsers = StringUtils.split((String)"hadoop,root,shangda", (char)',');
        HashSet<String> adminSet = new HashSet<String>();
        for (String admin : adminUsers) {
            adminSet.add(admin);
        }
        String submitUsr = CliUtils.getSubmitUser(ctx.getVarAccess(), osUser, adminSet);
        JobCmdSubType subType = null;
        String jobId = null;
        if (ctx.getVarAccess().hasVar("wds.linkis.client.common.kill")) {
            jobId = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.kill");
            subType = JobCmdSubType.KILL;
        } else if (ctx.getVarAccess().hasVar("wds.linkis.client.common.status")) {
            jobId = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.status");
            subType = JobCmdSubType.STATUS;
        } else if (ctx.getVarAccess().hasVar("wds.linkis.client.common.desc")) {
            jobId = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.desc");
            subType = JobCmdSubType.DESC;
        } else if (ctx.getVarAccess().hasVar("wds.linkis.client.common.log")) {
            jobId = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.log");
            subType = JobCmdSubType.LOG;
        } else if (ctx.getVarAccess().hasVar("wds.linkis.client.common.result")) {
            jobId = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.result");
            subType = JobCmdSubType.RESULT;
        } else if (ctx.getVarAccess().hasVar("wds.linkis.client.common.list")) {
            jobId = ctx.getVarAccess().getVar(String.class, "wds.linkis.client.common.list");
            subType = JobCmdSubType.LIST;
        }
        desc.setSubType(subType);
        desc.setJobId(jobId);
        desc.setUser(submitUsr);
        return desc;
    }
}

