/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.present.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.linkis.cli.application.exception.PresenterException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;

public class ResultFileWriter {
    public static void writeToFile(String pathName, String fileName, String content, Boolean overWrite) {
        File dir = new File(pathName);
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                throw new PresenterException("PST0005", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresentDriverErr, "Cannot mkdir for path: " + dir.getAbsolutePath(), e);
            }
        }
        File file = new File(dir.getAbsolutePath() + File.separator + fileName);
        if (overWrite.booleanValue() || !file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new PresenterException("PST0006", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresentDriverErr, "Cannot create file for path: " + file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new PresenterException("PST0006", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresentDriverErr, "Cannot create file for path: " + file.getAbsolutePath(), e);
            }
        }
        FileOutputStream fos = null;
        OutputStreamWriter osWritter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fos = new FileOutputStream(file, overWrite == false);
            osWritter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bufferedWriter = new BufferedWriter(osWritter, 1024);
            bufferedWriter.write(content + "\n");
        }
        catch (Exception e) {
            throw new PresenterException("PST0007", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.PresentDriverErr, "Cannot write: " + file.getAbsolutePath(), e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
            if (osWritter != null) {
                try {
                    osWritter.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

