/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.jackson.mixin.ApplicationsJsonMixIn;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;
import com.netflix.discovery.converters.jackson.serializer.InstanceInfoJsonBeanSerializer;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.cloud.configuration.SSLContextFactory;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.cloud.netflix.eureka.http.DefaultEurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.cloud.netflix.eureka.http.RestTemplateEurekaHttpClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestTemplateTransportClientFactory
implements TransportClientFactory {
    private final Optional<SSLContext> sslContext;
    private final Optional<HostnameVerifier> hostnameVerifier;
    private final EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier;

    public RestTemplateTransportClientFactory(TlsProperties tlsProperties, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier) {
        this.sslContext = this.context(tlsProperties);
        this.hostnameVerifier = Optional.empty();
        this.eurekaClientHttpRequestFactorySupplier = eurekaClientHttpRequestFactorySupplier;
    }

    private Optional<SSLContext> context(TlsProperties properties) {
        if (properties == null || !properties.isEnabled()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new SSLContextFactory(properties).createSSLContext());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public RestTemplateTransportClientFactory(Optional<SSLContext> sslContext, Optional<HostnameVerifier> hostnameVerifier, EurekaClientHttpRequestFactorySupplier eurekaClientHttpRequestFactorySupplier) {
        this.sslContext = sslContext;
        this.hostnameVerifier = hostnameVerifier;
        this.eurekaClientHttpRequestFactorySupplier = eurekaClientHttpRequestFactorySupplier;
    }

    public RestTemplateTransportClientFactory() {
        this.sslContext = Optional.empty();
        this.hostnameVerifier = Optional.empty();
        this.eurekaClientHttpRequestFactorySupplier = new DefaultEurekaClientHttpRequestFactorySupplier();
    }

    public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
        return new RestTemplateEurekaHttpClient(this.restTemplate(serviceUrl.getServiceUrl()), serviceUrl.getServiceUrl());
    }

    private RestTemplate restTemplate(String serviceUrl) {
        RestTemplate restTemplate = this.restTemplate();
        try {
            String[] credentials;
            URI serviceURI = new URI(serviceUrl);
            if (serviceURI.getUserInfo() != null && (credentials = serviceURI.getUserInfo().split(":")).length == 2) {
                restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(credentials[0], credentials[1]));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        restTemplate.getMessageConverters().add(0, this.mappingJacksonHttpMessageConverter());
        restTemplate.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
        return restTemplate;
    }

    private RestTemplate restTemplate() {
        ClientHttpRequestFactory requestFactory = this.eurekaClientHttpRequestFactorySupplier.get(this.sslContext.orElse(null), this.hostnameVerifier.orElse(null));
        return new RestTemplate(requestFactory);
    }

    public MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE));
        SimpleModule jsonModule = new SimpleModule();
        jsonModule.setSerializerModifier(RestTemplateTransportClientFactory.createJsonSerializerModifier());
        converter.getObjectMapper().registerModule((Module)jsonModule);
        converter.getObjectMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        converter.getObjectMapper().configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        converter.getObjectMapper().addMixIn(Applications.class, ApplicationsJsonMixIn.class);
        converter.getObjectMapper().addMixIn(InstanceInfo.class, InstanceInfoJsonMixIn.class);
        return converter;
    }

    public static BeanSerializerModifier createJsonSerializerModifier() {
        return new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc.getBeanClass().isAssignableFrom(InstanceInfo.class)) {
                    return new InstanceInfoJsonBeanSerializer((BeanSerializerBase)serializer, false);
                }
                return serializer;
            }
        };
    }

    public void shutdown() {
    }

    class ErrorHandler
    extends DefaultResponseErrorHandler {
        ErrorHandler() {
        }

        protected boolean hasError(HttpStatus statusCode) {
            if (statusCode.is4xxClientError()) {
                return false;
            }
            return super.hasError(statusCode);
        }
    }
}

