/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.python.executor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject$;
import org.apache.linkis.engineconn.launch.EngineConnServer$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.PythonCodeParser;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.conf.EngineConnPluginConf$;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils$;
import org.apache.linkis.manager.engineplugin.python.conf.PythonEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.python.executor.PythonSession;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Function0;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001\u0002\u000e\u001c\u0001)B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!I!\t\u0001B\u0001B\u0003%qg\u0011\u0005\u0006\t\u0002!\t!\u0012\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\n-C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013Y\u0003\u0001\u0019!A!B\u0013a\u0005bB,\u0001\u0005\u0004%I\u0001\u0017\u0005\u0007]\u0002\u0001\u000b\u0011B-\t\u000bY\u0004A\u0011I<\t\u000fa\u0004!\u0019!C\u0005s\"9\u00111\u0002\u0001!\u0002\u0013Q\bbBA\u0007\u0001\u0011%\u0011q\u0002\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!9\u00111\u000e\u0001\u0005B\u00055\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\tI\n\u0001C!\u00037Cq!!,\u0001\t\u0003\ny\u0001C\u0004\u00020\u0002!\t%!-\t\r\u0005U\u0006\u0001\"\u0011x\u0005a\u0001\u0016\u0010\u001e5p]\u0016sw-\u001b8f\u0007>tg.\u0012=fGV$xN\u001d\u0006\u00039u\t\u0001\"\u001a=fGV$xN\u001d\u0006\u0003=}\ta\u0001]=uQ>t'B\u0001\u0011\"\u00031)gnZ5oKBdWoZ5o\u0015\t\u00113%A\u0004nC:\fw-\u001a:\u000b\u0005\u0011*\u0013A\u00027j].L7O\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0003\u0001-\u0002\"\u0001\f\u001b\u000e\u00035R!AL\u0018\u0002\u000f\u0015DXmY;uK*\u0011A\u0004\r\u0006\u0003cI\n1bY8naV$\u0018\r^5p]*\u00111gI\u0001\u000bK:<\u0017N\\3d_:t\u0017BA\u001b.\u0005M\u0019u.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u0003\tIG\r\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0002J]R\fQ\u0002]=uQ>t7+Z:tS>t\u0007CA A\u001b\u0005Y\u0012BA!\u001c\u00055\u0001\u0016\u0010\u001e5p]N+7o]5p]\u0006\u0001r.\u001e;qkR\u0004&/\u001b8u\u0019&l\u0017\u000e^\u0005\u0003\u0005R\na\u0001P5oSRtD\u0003\u0002$H\u0011&\u0003\"a\u0010\u0001\t\u000bY\"\u0001\u0019A\u001c\t\u000bu\"\u0001\u0019\u0001 \t\u000b\t#\u0001\u0019A\u001c\u0002-\u0015tw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012\u0001\u0014\t\u0003Y5K!AT\u0017\u0003-\u0015sw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f!$\u001a8hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010^0%KF$\"!\u0015+\u0011\u0005a\u0012\u0016BA*:\u0005\u0011)f.\u001b;\t\u000fU3\u0011\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010J\u0019\u0002/\u0015tw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013AD3yK\u000e,Ho\u001c:MC\n,Gn]\u000b\u00023B\u0019!lX1\u000e\u0003mS!\u0001X/\u0002\tU$\u0018\u000e\u001c\u0006\u0002=\u0006!!.\u0019<b\u0013\t\u00017L\u0001\u0003MSN$\bG\u00012m!\r\u0019\u0007N[\u0007\u0002I*\u0011QMZ\u0001\u0007K:$\u0018\u000e^=\u000b\u0005\u001d\f\u0013!\u00027bE\u0016d\u0017BA5e\u0005\u0015a\u0015MY3m!\tYG\u000e\u0004\u0001\u0005\u00135L\u0011\u0011!A\u0001\u0006\u0003y'aA0%c\u0005yQ\r_3dkR|'\u000fT1cK2\u001c\b%\u0005\u0002qgB\u0011\u0001(]\u0005\u0003ef\u0012qAT8uQ&tw\r\u0005\u00029i&\u0011Q/\u000f\u0002\u0004\u0003:L\u0018\u0001B5oSR$\u0012!U\u0001\u0015af$\bn\u001c8EK\u001a\fW\u000f\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003i\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{fj\u0011A \u0006\u0003\u007f&\na\u0001\u0010:p_Rt\u0014bAA\u0002s\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001:\u0003U\u0001\u0018\u0010\u001e5p]\u0012+g-Y;miZ+'o]5p]\u0002\nAbZ3u!f4VM]:j_:$\u0012A_\u0001\fKb,7-\u001e;f\u0019&tW\r\u0006\u0004\u0002\u0016\u0005\u0015\u0012q\u0005\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003!)\u00070Z2vi\u0016\u0014(bAA\u0010G\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003G\tIBA\bFq\u0016\u001cW\u000f^3SKN\u0004xN\\:f\u0011\u0015Qe\u00021\u0001M\u0011\u0019\tIC\u0004a\u0001u\u0006!1m\u001c3f\u0003E)\u00070Z2vi\u0016\u001cu.\u001c9mKR,G.\u001f\u000b\t\u0003+\ty#!\r\u00024!)!j\u0004a\u0001\u0019\"1\u0011\u0011F\bA\u0002iDa!!\u000e\u0010\u0001\u0004Q\u0018!D2p[BdW\r^3e\u0019&tW-\u0001\u0005qe><'/Z:t)\u0011\tY$!\u0011\u0011\u0007a\ni$C\u0002\u0002@e\u0012QA\u00127pCRDa!a\u0011\u0011\u0001\u0004Q\u0018A\u0002;bg.LE)A\bhKR\u0004&o\\4sKN\u001c\u0018J\u001c4p)\u0011\tI%a\u0018\u0011\u000ba\nY%a\u0014\n\u0007\u00055\u0013HA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002R\u0005mSBAA*\u0015\u0011\t)&a\u0016\u0002\r\u0015tw-\u001b8f\u0015\r\tIfI\u0001\taJ|Go\\2pY&!\u0011QLA*\u0005=QuN\u0019)s_\u001e\u0014Xm]:J]\u001a|\u0007BBA\"#\u0001\u0007!0A\ntkB\u0004xN\u001d;DC2d')Y2l\u0019><7\u000f\u0006\u0002\u0002fA\u0019\u0001(a\u001a\n\u0007\u0005%\u0014HA\u0004C_>dW-\u00198\u0002/I,\u0017/^3ti\u0016C\b/Z2uK\u0012\u0014Vm]8ve\u000e,G\u0003BA8\u0003\u0003\u0003B!!\u001d\u0002~5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0005sKN|WO]2f\u0015\r)\u0017\u0011\u0010\u0006\u0004\u0003w\n\u0013AB2p[6|g.\u0003\u0003\u0002\u0000\u0005M$\u0001\u0004(pI\u0016\u0014Vm]8ve\u000e,\u0007bBAB'\u0001\u0007\u0011qN\u0001\u0011Kb\u0004Xm\u0019;fIJ+7o\\;sG\u0016\facZ3u\u0007V\u0014(/\u001a8u\u001d>$WMU3t_V\u00148-\u001a\u000b\u0003\u0003_\n\u0011cZ3u\u000bb,7-\u001e;pe2\u000b'-\u001a7t)\t\ti\t\u0005\u0003[?\u0006=\u0005\u0007BAI\u0003+\u0003Ba\u00195\u0002\u0014B\u00191.!&\u0005\u0015\u0005]U#!A\u0001\u0002\u000b\u0005qNA\u0002`IM\n\u0011c]3u\u000bb,7-\u001e;pe2\u000b'-\u001a7t)\r\t\u0016Q\u0014\u0005\b\u0003?3\u0002\u0019AAQ\u0003\u0019a\u0017MY3mgB!!lXARa\u0011\t)+!+\u0011\t\rD\u0017q\u0015\t\u0004W\u0006%FaCAV\u0003;\u000b\t\u0011!A\u0003\u0002=\u00141a\u0018\u00135\u0003\u00159W\r^%e\u0003!Y\u0017\u000e\u001c7UCN\\GcA)\u00024\"1\u00111\t\rA\u0002i\fQa\u00197pg\u0016\u0004")
public class PythonEngineConnExecutor
extends ComputationExecutor {
    private final int id;
    private final PythonSession pythonSession;
    private EngineExecutionContext engineExecutionContext;
    private final List<Label<?>> executorLabels;
    private final String pythonDefaultVersion;

    private EngineExecutionContext engineExecutionContext() {
        return this.engineExecutionContext;
    }

    private void engineExecutionContext_$eq(EngineExecutionContext x$1) {
        this.engineExecutionContext = x$1;
    }

    private List<Label<?>> executorLabels() {
        return this.executorLabels;
    }

    public void init() {
        this.logger().info("Ready to change engine state!");
        this.setCodeParser((CodeParser)new PythonCodeParser());
        super.init();
    }

    private String pythonDefaultVersion() {
        return this.pythonDefaultVersion;
    }

    private String getPyVersion() {
        if (EngineConnServer$.MODULE$.getEngineCreationContext().getOptions() != null) {
            return EngineConnServer$.MODULE$.getEngineCreationContext().getOptions().getOrDefault(EngineConnPluginConf$.MODULE$.PYTHON_VERSION_KEY(), "python");
        }
        return (String)PythonEngineConfiguration$.MODULE$.PYTHON_VERSION().getValue();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutionContext, String code) {
        String pythonVersion = engineExecutionContext.getProperties().getOrDefault(EngineConnPluginConf$.MODULE$.PYTHON_VERSION_KEY(), this.pythonDefaultVersion()).toString().toLowerCase();
        this.logger().info(new StringBuilder(48).append(" EngineExecutionContext user python.version = > ").append(pythonVersion).toString());
        System.getProperties().put(EngineConnPluginConf$.MODULE$.PYTHON_VERSION_KEY(), pythonVersion);
        this.logger().info(new StringBuilder(41).append(" System getProperties python.version = > ").append(System.getProperties().getProperty(EngineConnPluginConf$.MODULE$.PYTHON_VERSION_KEY())).toString());
        this.pythonSession.lazyInitGateway();
        EngineExecutionContext engineExecutionContext2 = engineExecutionContext;
        EngineExecutionContext engineExecutionContext3 = this.engineExecutionContext();
        if (engineExecutionContext2 == null ? engineExecutionContext3 != null : !engineExecutionContext2.equals(engineExecutionContext3)) {
            this.engineExecutionContext_$eq(engineExecutionContext);
            this.pythonSession.setEngineExecutionContext(engineExecutionContext);
            this.logger().info("Python executor reset new engineExecutorContext!");
        }
        engineExecutionContext.appendStdout(new StringBuilder(4).append(this.getId()).append(" >> ").append(code.trim()).toString());
        if (this.engineExecutionContext().getCurrentParagraph() == 1) {
            engineExecutionContext.appendStdout(LogUtils$.MODULE$.generateInfo(new StringBuilder(24).append("Your Python Version is:\n").append(pythonVersion).toString()));
        }
        this.pythonSession.execute(code);
        return new SuccessExecuteResponse();
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutionContext, String code, String completedLine) {
        String newcode = new StringBuilder(0).append(completedLine).append(code).toString();
        this.logger().debug(new StringBuilder(11).append("newcode is ").append(newcode).toString());
        return this.executeLine(engineExecutionContext, newcode);
    }

    public float progress(String taskID) {
        if (this.engineExecutionContext() != null) {
            return (float)this.engineExecutionContext().getCurrentParagraph() / (float)this.engineExecutionContext().getTotalParagraph();
        }
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        ArrayBuffer jobProgressInfo = new ArrayBuffer();
        if (this.engineExecutionContext() == null) {
            return (JobProgressInfo[])jobProgressInfo.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
        }
        ArrayBuffer arrayBuffer = 0.0f == this.progress(taskID) ? jobProgressInfo.$plus$eq((Object)new JobProgressInfo((String)this.engineExecutionContext().getJobId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), 1, 1, 0, 0)) : jobProgressInfo.$plus$eq((Object)new JobProgressInfo((String)this.engineExecutionContext().getJobId().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), 1, 0, 0, 1));
        return (JobProgressInfo[])jobProgressInfo.toArray(ClassTag$.MODULE$.apply(JobProgressInfo.class));
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils$.MODULE$.applyAsLoadInstanceResource(EngineConnObject$.MODULE$.getEngineCreationContext().getOptions()));
        return resource;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels();
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels().clear();
            this.executorLabels().addAll(labels);
            return;
        }
    }

    public String getId() {
        return new StringBuilder(1).append(Sender$.MODULE$.getThisServiceInstance().getInstance()).append("_").append(this.id).toString();
    }

    public void killTask(String taskID) {
        this.logger().info(new StringBuilder(26).append("Start to kill python task ").append(taskID).toString());
        super.killTask(taskID);
        this.logger().info(new StringBuilder(25).append("To close python cli task ").append(taskID).toString());
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.close(), this.logger());
    }

    public void close() {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.pythonSession.close(), this.logger());
        this.logger().info("To delete python executor");
        this.logger().info("Finished to kill python");
    }

    public PythonEngineConnExecutor(int id, PythonSession pythonSession, int outputPrintLimit) {
        this.id = id;
        this.pythonSession = pythonSession;
        super(outputPrintLimit);
        this.executorLabels = new ArrayList();
        this.pythonDefaultVersion = this.getPyVersion();
    }
}

