/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.cs.client.ContextClient;
import org.apache.linkis.cs.client.builder.ContextClientFactory;
import org.apache.linkis.cs.client.service.DefaultSearchService;
import org.apache.linkis.cs.client.service.SearchService;
import org.apache.linkis.cs.client.service.TableService;
import org.apache.linkis.cs.client.utils.SerializeHelper;
import org.apache.linkis.cs.common.entity.enumeration.ContextScope;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.metadata.CSTable;
import org.apache.linkis.cs.common.entity.source.CombinedNodeIDContextID;
import org.apache.linkis.cs.common.entity.source.CommonContextKey;
import org.apache.linkis.cs.common.entity.source.CommonContextValue;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSTableService
implements TableService {
    private static final Logger logger = LoggerFactory.getLogger(CSTableService.class);
    private SearchService searchService = DefaultSearchService.getInstance();
    private static CSTableService csTableService;

    private CSTableService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CSTableService getInstance() {
        if (null != csTableService) return csTableService;
        Class<CSTableService> clazz = CSTableService.class;
        synchronized (CSTableService.class) {
            if (null != csTableService) return csTableService;
            csTableService = new CSTableService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return csTableService;
        }
    }

    @Override
    public CSTable getCSTable(ContextID contextID, ContextKey contextKey) throws CSErrorException {
        CSTable csTable;
        if (null == contextID || null == contextKey) {
            logger.warn("contextIDStr or nodeName cannot null");
            return null;
        }
        if (contextID instanceof CombinedNodeIDContextID) {
            contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
        }
        if (null != (csTable = this.searchService.getContextValue(contextID, contextKey, CSTable.class))) {
            logger.info("contextID: {} and contextKey: {} succeed to get table tableName {}", new Object[]{contextID.getContextId(), contextKey.getKey(), csTable.getName()});
        }
        return csTable;
    }

    @Override
    public List<CSTable> getUpstreamTables(String contextIDStr, String nodeName) throws CSErrorException {
        List<CSTable> rsList = new ArrayList<CSTable>();
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return rsList;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (null != contextID) {
                if (contextID instanceof CombinedNodeIDContextID) {
                    contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
                }
                rsList = this.searchService.searchUpstreamContext(contextID, nodeName, Integer.MAX_VALUE, CSTable.class);
            }
            if (null != rsList) {
                logger.info("contextID: {} and nodeName: {} succeed to get tables size {}", new Object[]{contextID.getContextId(), nodeName, rsList.size()});
            }
            return rsList;
        }
        catch (ErrorException e) {
            logger.error("Deserialize contextID error. contextIDStr : " + contextIDStr);
            throw new CSErrorException(70112, "getUpstreamTables error ", (Throwable)e);
        }
    }

    @Override
    public CSTable getUpstreamSuitableTable(String contextIDStr, String nodeName, String keyword) throws CSErrorException {
        CSTable csTable = null;
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            logger.warn("contextIDStr or nodeName cannot null");
            return csTable;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (null != contextID) {
                if (contextID instanceof CombinedNodeIDContextID) {
                    contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
                }
                if (null != (csTable = this.searchService.searchContext(contextID, keyword, nodeName, CSTable.class))) {
                    logger.info("contextID: {} , nodeName: {}, keyword {} succeed to getUpstreamSuitableTable tableName {}", new Object[]{contextID.getContextId(), nodeName, keyword, csTable.getName()});
                }
            }
        }
        catch (ErrorException e) {
            throw new CSErrorException(70112, "getUpstreamSuitableTable error ", (Throwable)e);
        }
        return csTable;
    }

    @Override
    public List<ContextKeyValue> searchUpstreamTableKeyValue(String contextIDStr, String nodeName) throws CSErrorException {
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            if (contextID instanceof CombinedNodeIDContextID) {
                contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
            }
            return this.searchService.searchUpstreamKeyValue(contextID, nodeName, Integer.MAX_VALUE, CSTable.class);
        }
        catch (ErrorException e) {
            throw new CSErrorException(70112, "Failed to searchUpstreamTableKeyValue ", (Throwable)e);
        }
    }

    @Override
    public void putCSTable(String contextIDStr, String contextKeyStr, CSTable csTable) throws CSErrorException {
        ContextClient contextClient = ContextClientFactory.getOrCreateContextClient();
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            CommonContextValue contextValue = new CommonContextValue();
            contextValue.setKeywords("");
            contextValue.setValue((Object)csTable);
            if (contextID instanceof CombinedNodeIDContextID) {
                contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
            }
            contextClient.update(contextID, contextKey, (ContextValue)contextValue);
            logger.info("contextID: {} , contextKeyStr: {} succeed to putCSTable tableName {}", new Object[]{contextID.getContextId(), contextKeyStr, csTable.getName()});
        }
        catch (ErrorException e) {
            throw new CSErrorException(70112, "putCSTable error ", (Throwable)e);
        }
    }

    @Override
    public CSTable getCSTable(String contextIDStr, String contextKeyStr) throws CSErrorException {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)contextKeyStr)) {
            return null;
        }
        try {
            ContextID contextID = SerializeHelper.deserializeContextID(contextIDStr);
            ContextKey contextKey = SerializeHelper.deserializeContextKey(contextKeyStr);
            if (contextID instanceof CombinedNodeIDContextID) {
                contextID = ((CombinedNodeIDContextID)contextID).getLinkisHaWorkFlowContextID();
            }
            return this.getCSTable(contextID, contextKey);
        }
        catch (ErrorException e) {
            throw new CSErrorException(70112, "getCSTable error ", (Throwable)e);
        }
    }

    @Override
    public void registerCSTable(String contextIDStr, String nodeName, String alias, CSTable csTable) throws CSErrorException {
        if (StringUtils.isBlank((CharSequence)contextIDStr) || StringUtils.isBlank((CharSequence)nodeName)) {
            return;
        }
        String tableName = "";
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            tableName = "cs_tmp_" + nodeName + "_" + alias;
        } else {
            for (int i = 1; i < 10; ++i) {
                String tmpTable = "cs_tmp_" + nodeName + "_rs" + i;
                try {
                    CommonContextKey contextKey = new CommonContextKey();
                    contextKey.setContextScope(ContextScope.PUBLIC);
                    contextKey.setContextType(ContextType.METADATA);
                    contextKey.setKey(CSCommonUtils.getTableKey((String)nodeName, (String)tmpTable));
                    CSTable oldCsTable = this.getCSTable(contextIDStr, SerializeHelper.serializeContextKey((ContextKey)contextKey));
                    if (null != oldCsTable) continue;
                    tableName = tmpTable;
                }
                catch (Exception e) {
                    tableName = tmpTable;
                    logger.warn("Failed to build tmp tableName", (Throwable)e);
                }
                break;
            }
        }
        try {
            csTable.setName(tableName);
            CommonContextKey contextKey = new CommonContextKey();
            contextKey.setContextScope(ContextScope.PUBLIC);
            contextKey.setContextType(ContextType.METADATA);
            contextKey.setKey(CSCommonUtils.getTableKey((String)nodeName, (String)tableName));
            this.putCSTable(contextIDStr, SerializeHelper.serializeContextKey((ContextKey)contextKey), csTable);
        }
        catch (ErrorException e) {
            throw new CSErrorException(70112, "Failed to register cs tmp table ", (Throwable)e);
        }
    }
}

