/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.registry;

import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsAsgUtil;
import com.netflix.eureka.cluster.PeerEurekaNodes;
import com.netflix.eureka.registry.PeerAwareInstanceRegistryImpl;
import com.netflix.eureka.registry.rule.AsgEnabledRule;
import com.netflix.eureka.registry.rule.DownOrStartingRule;
import com.netflix.eureka.registry.rule.FirstMatchWinsCompositeRule;
import com.netflix.eureka.registry.rule.InstanceStatusOverrideRule;
import com.netflix.eureka.registry.rule.LeaseExistsRule;
import com.netflix.eureka.registry.rule.OverrideExistsRule;
import com.netflix.eureka.resources.ServerCodecs;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AwsInstanceRegistry
extends PeerAwareInstanceRegistryImpl {
    private AwsAsgUtil awsAsgUtil;
    private InstanceStatusOverrideRule instanceStatusOverrideRule;

    @Inject
    public AwsInstanceRegistry(EurekaServerConfig serverConfig, EurekaClientConfig clientConfig, ServerCodecs serverCodecs, EurekaClient eurekaClient) {
        super(serverConfig, clientConfig, serverCodecs, eurekaClient);
    }

    @Override
    public void init(PeerEurekaNodes peerEurekaNodes) throws Exception {
        super.init(peerEurekaNodes);
        this.awsAsgUtil = new AwsAsgUtil(this.serverConfig, this.clientConfig, this);
        this.instanceStatusOverrideRule = new FirstMatchWinsCompositeRule(new DownOrStartingRule(), new OverrideExistsRule(this.overriddenInstanceStatusMap), new AsgEnabledRule(this.awsAsgUtil), new LeaseExistsRule());
    }

    @Override
    protected InstanceStatusOverrideRule getInstanceInfoOverrideRule() {
        return this.instanceStatusOverrideRule;
    }

    public AwsAsgUtil getAwsAsgUtil() {
        return this.awsAsgUtil;
    }
}

