/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.utils.alert.ims;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.monitor.constants.Constants$;
import org.apache.linkis.monitor.jobhistory.exception.AnomalyScannerException;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc$;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertLevel$;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertPropFileData;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertWay$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class MonitorAlertUtils$
implements Logging {
    public static MonitorAlertUtils$ MODULE$;
    private final ObjectMapper mapper;
    private final scala.collection.mutable.Map<String, String> properties;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new MonitorAlertUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        MonitorAlertUtils$ monitorAlertUtils$ = this;
        synchronized (monitorAlertUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public scala.collection.mutable.Map<String, String> properties() {
        return this.properties;
    }

    public Map<String, AlertDesc> getAlerts(String prefix, Map<String, String> params) {
        HashMap<String, AlertDesc> ret = new HashMap<String, AlertDesc>();
        Map repaceParams = (Map)Option$.MODULE$.apply(params).getOrElse((Function0 & Serializable & scala.Serializable)() -> new HashMap());
        this.properties().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MonitorAlertUtils$.$anonfun$getAlerts$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k != null) {
                    String string = k;
                    if (v != null) {
                        String string2 = v;
                        if (ret.containsKey(string)) {
                            MODULE$.logger().warn("found duplicate key in alert properties, accept only the first one");
                            return BoxedUnit.UNIT;
                        }
                        if (StringUtils.startsWith((CharSequence)string, (CharSequence)prefix)) {
                            Object object;
                            Object object2;
                            ImsAlertPropFileData data = (ImsAlertPropFileData)MODULE$.mapper().readValue(string2, ImsAlertPropFileData.class);
                            ObjectRef alertInfo = ObjectRef.create((Object)new String(new StringBuilder().append(data.alertInfo()).toString().getBytes(), "utf-8").replace("$name", data.alertReceivers()));
                            for (String key : repaceParams.keySet()) {
                                String value = (String)repaceParams.get(key);
                                alertInfo.elem = ((String)alertInfo.elem).replace(key, value);
                            }
                            HashSet set = new HashSet();
                            Object object3 = StringUtils.isNotBlank((CharSequence)data.alertReceivers()) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.alertReceivers().split(","))).map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)set.add(r)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())) : BoxedUnit.UNIT;
                            if (!repaceParams.containsKey("$alteruser")) {
                                Constants$.MODULE$.ALERT_DEFAULT_RECEIVERS().foreach((Function1 & Serializable & scala.Serializable)e -> {
                                    if (StringUtils.isNotBlank((CharSequence)e)) {
                                        return BoxesRunTime.boxToBoolean((boolean)set.add(e));
                                    }
                                    return BoxedUnit.UNIT;
                                });
                                object2 = BoxedUnit.UNIT;
                            } else {
                                object2 = BoxesRunTime.boxToBoolean((boolean)set.add(repaceParams.get("$alteruser")));
                            }
                            Object object4 = StringUtils.isNotBlank((CharSequence)((CharSequence)repaceParams.get("receiver"))) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)repaceParams.get("receiver")).split(","))).map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)set.add(r)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())) : BoxedUnit.UNIT;
                            HashSet receivers = set;
                            HashSet set2 = new HashSet();
                            Object object5 = StringUtils.isNotBlank((CharSequence)data.eccReceivers()) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.eccReceivers().split(","))).map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)set2.add(r)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())) : BoxedUnit.UNIT;
                            if (!repaceParams.containsKey("$eccAlertUser")) {
                                Constants$.MODULE$.ECC_DEFAULT_RECEIVERS().foreach((Function1 & Serializable & scala.Serializable)e -> {
                                    if (StringUtils.isNotBlank((CharSequence)e)) {
                                        return BoxesRunTime.boxToBoolean((boolean)set2.add(e));
                                    }
                                    return BoxedUnit.UNIT;
                                });
                                object = BoxedUnit.UNIT;
                            } else {
                                object = BoxesRunTime.boxToBoolean((boolean)set2.add(repaceParams.get("$eccAlertUser")));
                            }
                            Object object6 = StringUtils.isNotBlank((CharSequence)((CharSequence)repaceParams.get("eccReceiver"))) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)repaceParams.get("eccReceiver")).split(","))).map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)set2.add(r)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())) : BoxedUnit.UNIT;
                            HashSet eccReceivers = set2;
                            String subSystemId = repaceParams.getOrDefault("subSystemId", Constants$.MODULE$.ALERT_SUB_SYSTEM_ID());
                            String alertTitle = new java.lang.StringBuilder(4).append("\u96c6\u7fa4[").append(Constants$.MODULE$.LINKIS_CLUSTER_NAME()).append("]").append((Object)repaceParams.getOrDefault("title", data.alertTitle())).toString();
                            Enumeration.Value alertLevel = StringUtils.isNotBlank((CharSequence)data.alertLevel()) && StringUtils.isNumeric((CharSequence)data.alertLevel()) ? ImsAlertLevel$.MODULE$.withName(repaceParams.getOrDefault("monitorLevel", data.alertLevel())) : ImsAlertLevel$.MODULE$.withName(repaceParams.getOrDefault("monitorLevel", ImsAlertLevel$.MODULE$.WARN().toString()));
                            ImsAlertDesc alertDesc = (ImsAlertDesc)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> {
                                HashSet<Enumeration.Value> set = new HashSet<Enumeration.Value>();
                                Object object = StringUtils.isNotBlank((CharSequence)data.alertWays()) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.alertWays().split(","))).map((Function1 & Serializable & scala.Serializable)alertWayStr -> BoxesRunTime.boxToBoolean((boolean)set.add(ImsAlertWay$.MODULE$.withName(alertWayStr))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())) : BoxedUnit.UNIT;
                                return new ImsAlertDesc(subSystemId, alertTitle, data.alertObj(), (String)alertInfo$1.elem, alertLevel, null, 0, set, receivers, eccReceivers, ImsAlertDesc$.MODULE$.apply$default$11(), ImsAlertDesc$.MODULE$.apply$default$12());
                            }, MODULE$.logger());
                            String realK = StringUtils.substringAfter((String)string, (String)prefix);
                            return ret.put(realK, alertDesc);
                        }
                        return BoxedUnit.UNIT;
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return ret;
    }

    public static final /* synthetic */ boolean $anonfun$getAlerts$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private MonitorAlertUtils$() {
        void var1_1;
        MODULE$ = this;
        Logging.$init$((Logging)this);
        ObjectMapper ret = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"));
        ret.registerModule((Module)DefaultScalaModule$.MODULE$);
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper = var1_1;
        URL url = this.getClass().getClassLoader().getResource(Constants$.MODULE$.ALERT_PROPS_FILE_PATH());
        if (url == null) {
            throw new AnomalyScannerException(21304, new java.lang.StringBuilder(83).append("Failed to load alerts from alert properties. Alert properties file does not exist: ").append(Constants$.MODULE$.ALERT_PROPS_FILE_PATH()).toString());
        }
        this.logger().info(new java.lang.StringBuilder(31).append("reading alert properties from: ").append(url.getFile()).toString());
        Properties properties = new Properties();
        ObjectRef inputStream = ObjectRef.create(null);
        ObjectRef reader = ObjectRef.create(null);
        ObjectRef buff = ObjectRef.create(null);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            inputStream$1.elem = new FileInputStream(new File(url.getFile()));
            reader$1.elem = new InputStreamReader((InputStream)inputStream$1.elem, "UTF-8");
            buff$1.elem = new BufferedReader((InputStreamReader)reader$1.elem);
            properties.load((BufferedReader)buff$1.elem);
        }, (Function1 & Serializable & scala.Serializable)t -> {
            throw new AnomalyScannerException(21304, new java.lang.StringBuilder(52).append("Failed to load alerts from alert properties. Cause: ").append(ExceptionUtils.getMessage((Throwable)t)).toString());
        }), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IOUtils.closeQuietly((Reader)((BufferedReader)buff$1.elem));
            IOUtils.closeQuietly((Reader)((InputStreamReader)reader$1.elem));
            IOUtils.closeQuietly((InputStream)((InputStream)inputStream$1.elem));
        });
        this.properties = (scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala();
    }
}

