/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.monitor.utils.alert.ims;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.monitor.constants.Constants$;
import org.apache.linkis.monitor.utils.alert.AlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertDesc$;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertLevel$;
import org.apache.linkis.monitor.utils.alert.ims.ImsAlertWay$;
import org.apache.linkis.monitor.utils.alert.ims.PooledImsAlertSender;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.java8.JFunction0;

public final class PooledImsAlertUtils$
implements Logging {
    public static PooledImsAlertUtils$ MODULE$;
    private final PooledImsAlertSender sender;
    private final String localIp;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PooledImsAlertUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PooledImsAlertUtils$ pooledImsAlertUtils$ = this;
        synchronized (pooledImsAlertUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private PooledImsAlertSender sender() {
        return this.sender;
    }

    private String localIp() {
        return this.localIp;
    }

    public void addAlertAndLogException(String message) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.addAlert(message), this.logger());
    }

    public void addAlert(String message) {
        this.addExceptionAlert(message, null, null);
    }

    public void addExceptionAlert(String message, Throwable t) {
        this.addExceptionAlert(message, t, null);
    }

    public void addExceptionAlertAndLogException(String message, Throwable t) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.addExceptionAlert(message, t, null), this.logger());
    }

    public void addExceptionAlert(String message, Throwable t, Set<Enumeration.Value> alertWays) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        HashSet<Enumeration.Value> _alertWays;
        String string;
        if (StringUtils.isEmpty((CharSequence)message) && t != null) {
            string = t.getMessage();
        } else {
            if (StringUtils.isEmpty((CharSequence)message)) {
                throw new NullPointerException("both message and exception are null!");
            }
            string = message;
        }
        String alertObj = string;
        HashSet<Enumeration.Value> hashSet = _alertWays = CollectionUtils.isNotEmpty(alertWays) ? alertWays : new HashSet<Enumeration.Value>();
        if (t != null) {
            _alertWays.add(ImsAlertWay$.MODULE$.Email());
            _alertWays.add(ImsAlertWay$.MODULE$.WXWork());
            _alertWays.add(ImsAlertWay$.MODULE$.WeChat());
            tuple22 = new Tuple2((Object)ExceptionUtils.getRootCauseMessage((Throwable)t), (Object)ImsAlertLevel$.MODULE$.MAJOR());
        } else {
            _alertWays.add(ImsAlertWay$.MODULE$.WXWork());
            tuple22 = tuple2 = new Tuple2((Object)message, (Object)ImsAlertLevel$.MODULE$.WARN());
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String alertInfo = (String)tuple2._1();
        Enumeration.Value alertLevel = (Enumeration.Value)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)alertInfo, (Object)alertLevel);
        String alertInfo2 = (String)tuple23._1();
        Enumeration.Value alertLevel2 = (Enumeration.Value)tuple23._2();
        ImsAlertDesc alertDesc = new ImsAlertDesc(Constants$.MODULE$.ALERT_SUB_SYSTEM_ID(), "BDP Alert", alertObj, alertInfo2, alertLevel2, this.localIp(), 0, _alertWays, ImsAlertDesc$.MODULE$.$lessinit$greater$default$9(), ImsAlertDesc$.MODULE$.$lessinit$greater$default$10(), ImsAlertDesc$.MODULE$.$lessinit$greater$default$11(), ImsAlertDesc$.MODULE$.$lessinit$greater$default$12());
        this.addAlert(alertDesc);
    }

    public void addAlert(AlertDesc alertDesc) {
        if (!(alertDesc instanceof ImsAlertDesc)) {
            this.logger().warn(new StringBuilder(34).append("Ignore wrong alertDesc. DataType: ").append(alertDesc.getClass().getCanonicalName()).toString());
            return;
        }
        this.sender().addAlertToPool(alertDesc);
        this.logger().info("successfully added alert");
    }

    public void addAlertAndLogException(ImsAlertDesc alertDesc) {
        Utils$.MODULE$.tryAndError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.addAlert(alertDesc), this.logger());
    }

    public void clearAlert(ImsAlertDesc alertDesc) {
        Predef$.MODULE$.assert(alertDesc.canRecover() == 1);
        Enumeration.Value value = alertDesc.alertLevel();
        Enumeration.Value value2 = ImsAlertLevel$.MODULE$.CLEAR();
        Predef$.MODULE$.assert(!(value != null ? !value.equals(value2) : value2 != null));
        this.sender().addAlertToPool(alertDesc);
    }

    public void shutDown(boolean waitComplete, long timeoutMs) {
        this.sender().shutdown(waitComplete, timeoutMs);
    }

    public boolean shutDown$default$1() {
        return true;
    }

    public long shutDown$default$2() {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private PooledImsAlertUtils$() {
        void var1_1;
        MODULE$ = this;
        Logging.$init$((Logging)this);
        PooledImsAlertSender ret = new PooledImsAlertSender(Constants$.MODULE$.ALERT_IMS_URL());
        ret.start();
        this.sender = var1_1;
        this.localIp = InetAddress.getLocalHost().getHostAddress();
    }
}

