/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasource.client.request;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.linkis.datasource.client.config.DatasourceClientConfig$;
import org.apache.linkis.datasource.client.errorcode.DatasourceClientErrorCodeSummary;
import org.apache.linkis.datasource.client.exception.DataSourceClientBuilderException;
import org.apache.linkis.datasource.client.request.DataSourceAction;
import org.apache.linkis.datasource.client.request.GetConnectParamsByDataSourceNameAction$;
import org.apache.linkis.httpclient.dws.request.DWSHttpAction;
import org.apache.linkis.httpclient.request.GetAction;
import scala.Enumeration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u0010 \u00011BQ\u0001\u000f\u0001\u0005\u0002eB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001f\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0013Y\u0005\"\u0003*\u0001\u0001\u0004\u0005\t\u0015)\u0003>\u0011%\u0019\u0006\u00011AA\u0002\u0013%A\bC\u0005U\u0001\u0001\u0007\t\u0019!C\u0005+\"Iq\u000b\u0001a\u0001\u0002\u0003\u0006K!\u0010\u0005\u00061\u0002!\t%\u0017\u0005\u0006;\u0002!\tE\u0018\u0005\u0006A\u0002!\t\u0005P\u0004\u0006C~A\tA\u0019\u0004\u0006=}A\ta\u0019\u0005\u0006q1!\ta\u001a\u0005\u0006Q2!\t!\u001b\u0004\u0005Y2\u0001Q\u000e\u0003\u00049\u001f\u0011\u0005A\"\u001b\u0005\nw=\u0001\r\u00111A\u0005\nqB\u0011BS\bA\u0002\u0003\u0007I\u0011\u00028\t\u0013I{\u0001\u0019!A!B\u0013i\u0004\"\u00039\u0010\u0001\u0004\u0005\r\u0011\"\u0003=\u0011%\tx\u00021AA\u0002\u0013%!\u000fC\u0005u\u001f\u0001\u0007\t\u0011)Q\u0005{!I1k\u0004a\u0001\u0002\u0004%I\u0001\u0010\u0005\n)>\u0001\r\u00111A\u0005\nUD\u0011bV\bA\u0002\u0003\u0005\u000b\u0015B\u001f\t\u000bu{A\u0011A<\t\u000be|A\u0011\u0001>\t\u000bq|A\u0011A?\t\u000b}|A\u0011A\u001d\u0003M\u001d+GoQ8o]\u0016\u001cG\u000fU1sC6\u001c()\u001f#bi\u0006\u001cv.\u001e:dK:\u000bW.Z!di&|gN\u0003\u0002!C\u00059!/Z9vKN$(B\u0001\u0012$\u0003\u0019\u0019G.[3oi*\u0011A%J\u0001\u000bI\u0006$\u0018m]8ve\u000e,'B\u0001\u0014(\u0003\u0019a\u0017N\\6jg*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00175!\tq#'D\u00010\u0015\t\u0001\u0003G\u0003\u00022K\u0005Q\u0001\u000e\u001e;qG2LWM\u001c;\n\u0005Mz#!C$fi\u0006\u001bG/[8o!\t)d'D\u0001 \u0013\t9tD\u0001\tECR\f7k\\;sG\u0016\f5\r^5p]\u00061A(\u001b8jiz\"\u0012A\u000f\t\u0003k\u0001\ta\u0002Z1uCN{WO]2f\u001d\u0006lW-F\u0001>!\tqtI\u0004\u0002@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!iK\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u000e\u000b!\u0003Z1uCN{WO]2f\u001d\u0006lWm\u0018\u0013fcR\u0011A\n\u0015\t\u0003\u001b:k\u0011aQ\u0005\u0003\u001f\u000e\u0013A!\u00168ji\"9\u0011kAA\u0001\u0002\u0004i\u0014a\u0001=%c\u0005yA-\u0019;b'>,(oY3OC6,\u0007%\u0001\u0003vg\u0016\u0014\u0018\u0001C;tKJ|F%Z9\u0015\u000513\u0006bB)\u0007\u0003\u0003\u0005\r!P\u0001\u0006kN,'\u000fI\u0001\u000bgV4g-\u001b=V%2\u001bX#\u0001.\u0011\u00075[V(\u0003\u0002]\u0007\n)\u0011I\u001d:bs\u000691/\u001a;Vg\u0016\u0014HC\u0001'`\u0011\u0015\u0019\u0016\u00021\u0001>\u0003\u001d9W\r^+tKJ\faeR3u\u0007>tg.Z2u!\u0006\u0014\u0018-\\:Cs\u0012\u000bG/Y*pkJ\u001cWMT1nK\u0006\u001bG/[8o!\t)Db\u0005\u0002\rIB\u0011Q*Z\u0005\u0003M\u000e\u0013a!\u00118z%\u00164G#\u00012\u0002\u000f\t,\u0018\u000e\u001c3feR\t!\u000e\u0005\u0002l\u001f5\tABA\u0004Ck&dG-\u001a:\u0014\u0005=!GC\u0001'p\u0011\u001d\t&#!AA\u0002u\naa]=ti\u0016l\u0017AC:zgR,Wn\u0018\u0013fcR\u0011Aj\u001d\u0005\b#V\t\t\u00111\u0001>\u0003\u001d\u0019\u0018p\u001d;f[\u0002\"\"\u0001\u0014<\t\u000fEC\u0012\u0011!a\u0001{Q\u0011!\u000e\u001f\u0005\u0006'j\u0001\r!P\u0001\u0012g\u0016$H)\u0019;b'>,(oY3OC6,GC\u00016|\u0011\u0015Y4\u00041\u0001>\u0003%\u0019X\r^*zgR,W\u000e\u0006\u0002k}\")\u0001\u000f\ba\u0001{\u0005)!-^5mI\u0002")
public class GetConnectParamsByDataSourceNameAction
extends GetAction
implements DataSourceAction {
    private String org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName;
    private String user;
    private String org$apache$linkis$httpclient$dws$request$DWSHttpAction$$dwsVersion;

    public static Builder builder() {
        return GetConnectParamsByDataSourceNameAction$.MODULE$.builder();
    }

    public void setDWSVersion(String dwsVersion) {
        DWSHttpAction.setDWSVersion$((DWSHttpAction)this, (String)dwsVersion);
    }

    public String getPrefixURL() {
        return DWSHttpAction.getPrefixURL$((DWSHttpAction)this);
    }

    public Enumeration.Value getRestType() {
        return DWSHttpAction.getRestType$((DWSHttpAction)this);
    }

    public String getURL() {
        return DWSHttpAction.getURL$((DWSHttpAction)this);
    }

    public String org$apache$linkis$httpclient$dws$request$DWSHttpAction$$dwsVersion() {
        return this.org$apache$linkis$httpclient$dws$request$DWSHttpAction$$dwsVersion;
    }

    public void org$apache$linkis$httpclient$dws$request$DWSHttpAction$$dwsVersion_$eq(String x$1) {
        this.org$apache$linkis$httpclient$dws$request$DWSHttpAction$$dwsVersion = x$1;
    }

    private String org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName() {
        return this.org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName;
    }

    public void org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName_$eq(String x$1) {
        this.org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName = x$1;
    }

    private String user() {
        return this.user;
    }

    private void user_$eq(String x$1) {
        this.user = x$1;
    }

    public String[] suffixURLs() {
        return (String[])((Object[])new String[]{(String)DatasourceClientConfig$.MODULE$.DATA_SOURCE_SERVICE_MODULE().getValue(), "name", this.org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName(), "connect-params"});
    }

    public void setUser(String user) {
        this.user_$eq(user);
    }

    public String getUser() {
        return this.user();
    }

    public GetConnectParamsByDataSourceNameAction() {
        DWSHttpAction.$init$((DWSHttpAction)this);
    }

    public static class Builder {
        private String dataSourceName;
        private String system;
        private String user;

        private String dataSourceName() {
            return this.dataSourceName;
        }

        private void dataSourceName_$eq(String x$1) {
            this.dataSourceName = x$1;
        }

        private String system() {
            return this.system;
        }

        private void system_$eq(String x$1) {
            this.system = x$1;
        }

        private String user() {
            return this.user;
        }

        private void user_$eq(String x$1) {
            this.user = x$1;
        }

        public Builder setUser(String user) {
            this.user_$eq(user);
            return this;
        }

        public Builder setDataSourceName(String dataSourceName) {
            this.dataSourceName_$eq(dataSourceName);
            return this;
        }

        public Builder setSystem(String system) {
            this.system_$eq(system);
            return this;
        }

        public GetConnectParamsByDataSourceNameAction build() {
            if (this.dataSourceName() == null) {
                throw new DataSourceClientBuilderException(DatasourceClientErrorCodeSummary.DATASOURCENAME_NEEDED.getErrorDesc());
            }
            if (this.system() == null) {
                throw new DataSourceClientBuilderException(DatasourceClientErrorCodeSummary.SYSTEM_NEEDED.getErrorDesc());
            }
            if (this.user() == null) {
                throw new DataSourceClientBuilderException(DatasourceClientErrorCodeSummary.USER_NEEDED.getErrorDesc());
            }
            String requestDataSourceName = this.dataSourceName();
            try {
                requestDataSourceName = URLEncoder.encode(this.dataSourceName(), StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                throw new DataSourceClientBuilderException(MessageFormat.format(DatasourceClientErrorCodeSummary.CANNOT_SOURCE.getErrorDesc(), this.dataSourceName()), e);
            }
            GetConnectParamsByDataSourceNameAction getConnectParamsByDataSourceNameAction = new GetConnectParamsByDataSourceNameAction();
            getConnectParamsByDataSourceNameAction.org$apache$linkis$datasource$client$request$GetConnectParamsByDataSourceNameAction$$dataSourceName_$eq(requestDataSourceName);
            getConnectParamsByDataSourceNameAction.setParameter("system", this.system());
            getConnectParamsByDataSourceNameAction.setUser(this.user());
            return getConnectParamsByDataSourceNameAction;
        }
    }
}

