/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.node;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.druid.pool.ha.node.NodeEvent;
import com.alibaba.druid.pool.ha.node.NodeEventTypeEnum;
import com.alibaba.druid.pool.ha.node.NodeListener;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.RetryForever;

public class ZookeeperNodeListener
extends NodeListener {
    private static final Log LOG = LogFactory.getLog(ZookeeperNodeListener.class);
    private final Lock lock = new ReentrantLock();
    private String zkConnectString;
    private String path = "/ha-druid-datasources";
    private boolean privateZkClient;
    private PathChildrenCache cache;
    private CuratorFramework client;
    private String urlTemplate;

    @Override
    public void init() {
        this.checkParameters();
        super.init();
        if (this.client == null) {
            this.client = CuratorFrameworkFactory.builder().canBeReadOnly(true).connectionTimeoutMs(5000).connectString(this.zkConnectString).retryPolicy((RetryPolicy)new RetryForever(10000)).sessionTimeoutMs(30000).build();
            this.client.start();
            this.privateZkClient = true;
        }
        this.cache = new PathChildrenCache(this.client, this.path, true);
        this.cache.getListenable().addListener((Object)new PathChildrenCacheListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                try {
                    LOG.info("Receive an event: " + event.getType());
                    ZookeeperNodeListener.this.lock.lock();
                    PathChildrenCacheEvent.Type eventType = event.getType();
                    switch (eventType) {
                        case CHILD_REMOVED: {
                            ZookeeperNodeListener.this.updateSingleNode(event, NodeEventTypeEnum.DELETE);
                            return;
                        }
                        case CHILD_ADDED: {
                            ZookeeperNodeListener.this.updateSingleNode(event, NodeEventTypeEnum.ADD);
                            return;
                        }
                        case CONNECTION_RECONNECTED: {
                            ZookeeperNodeListener.this.refreshAllNodes();
                            return;
                        }
                        default: {
                            LOG.info("Received a PathChildrenCacheEvent, IGNORE it: " + event);
                            return;
                        }
                    }
                }
                finally {
                    ZookeeperNodeListener.this.lock.unlock();
                    LOG.info("Finish the processing of event: " + event.getType());
                }
            }
        });
        try {
            this.cache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
        }
        catch (Exception e) {
            LOG.error("Can't start PathChildrenCache", e);
        }
    }

    @Override
    public void destroy() {
        if (this.cache != null) {
            try {
                this.cache.close();
            }
            catch (IOException e) {
                LOG.error("IOException occurred while closing PathChildrenCache.", e);
            }
        }
        if (this.client != null && this.privateZkClient) {
            this.client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeEvent> refresh() {
        this.lock.lock();
        try {
            Properties properties = this.getPropertiesFromCache();
            List<NodeEvent> events = NodeEvent.getEventsByDiffProperties(this.getProperties(), properties);
            if (events != null && !events.isEmpty()) {
                this.setProperties(properties);
            }
            List<NodeEvent> list = events;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkParameters() {
        if (this.client == null && StringUtils.isEmpty(this.zkConnectString)) {
            throw new DruidRuntimeException("ZK Client is NULL, Please set the zkConnectString.");
        }
        if (StringUtils.isEmpty(this.path)) {
            throw new DruidRuntimeException("Please set the ZooKeeper node path.");
        }
        if (StringUtils.isEmpty(this.urlTemplate)) {
            throw new DruidRuntimeException("Please set the urlTemplate.");
        }
    }

    private void updateSingleNode(PathChildrenCacheEvent event, NodeEventTypeEnum type) {
        ChildData data = event.getData();
        String nodeName = this.getNodeName(data);
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.getPrefix() + "." + nodeName);
        Properties properties = this.getPropertiesFromChildData(data);
        List<NodeEvent> events = NodeEvent.generateEvents(properties, names, type);
        if (events.isEmpty()) {
            return;
        }
        if (type == NodeEventTypeEnum.ADD) {
            this.getProperties().putAll((Map<?, ?>)properties);
        } else {
            for (String n : properties.stringPropertyNames()) {
                this.getProperties().remove(n);
            }
        }
        super.update(events);
    }

    private void refreshAllNodes() {
        try {
            if (this.client.checkExists().forPath(this.path) == null) {
                LOG.warn("PATH[" + this.path + "] is NOT existed, can NOT refresh nodes.");
                return;
            }
            this.cache.rebuild();
            Properties properties = this.getPropertiesFromCache();
            List<NodeEvent> events = NodeEvent.getEventsByDiffProperties(this.getProperties(), properties);
            if (events != null && !events.isEmpty()) {
                this.setProperties(properties);
                super.update(events);
            }
        }
        catch (Exception e) {
            LOG.error("Can NOT refresh Cache Nodes.", e);
        }
    }

    private Properties getPropertiesFromCache() {
        List data = this.cache.getCurrentData();
        Properties properties = new Properties();
        for (ChildData c : data) {
            properties.putAll((Map<?, ?>)this.getPropertiesFromChildData(c));
        }
        return properties;
    }

    private Properties getPropertiesFromChildData(ChildData data) {
        String dataPrefix = this.getPrefix();
        Properties properties = new Properties();
        if (data == null) {
            return properties;
        }
        String nodeName = this.getNodeName(data);
        String str = new String(data.getData());
        Properties full = new Properties();
        try {
            full.load(new StringReader(str));
        }
        catch (IOException e) {
            LOG.error("Can't load Properties from String. " + str, e);
        }
        Properties filtered = PropertiesUtils.filterPrefix(full, dataPrefix);
        for (String n : filtered.stringPropertyNames()) {
            properties.setProperty(n.replaceFirst(dataPrefix, dataPrefix + "\\." + nodeName), filtered.getProperty(n));
        }
        if (!properties.containsKey(dataPrefix + "." + nodeName + ".url")) {
            properties.setProperty(dataPrefix + "." + nodeName + ".url", this.formatUrl(filtered));
        }
        return properties;
    }

    private String formatUrl(Properties properties) {
        String url = this.urlTemplate;
        String dataPrefix = this.getPrefix();
        if (properties.containsKey(dataPrefix + ".host")) {
            url = url.replace("${host}", properties.getProperty(dataPrefix + ".host"));
            url = url.replace("#{host}", properties.getProperty(dataPrefix + ".host"));
            url = url.replace("#host#", properties.getProperty(dataPrefix + ".host"));
        }
        if (properties.containsKey(dataPrefix + ".port")) {
            url = url.replace("${port}", properties.getProperty(dataPrefix + ".port"));
            url = url.replace("#{port}", properties.getProperty(dataPrefix + ".port"));
            url = url.replace("#port#", properties.getProperty(dataPrefix + ".port"));
        }
        if (properties.containsKey(dataPrefix + ".database")) {
            url = url.replace("${database}", properties.getProperty(dataPrefix + ".database"));
            url = url.replace("#{database}", properties.getProperty(dataPrefix + ".database"));
            url = url.replace("#database#", properties.getProperty(dataPrefix + ".database"));
        }
        return url;
    }

    private String getNodeName(ChildData data) {
        String eventZkPath = data.getPath();
        if (eventZkPath.startsWith(this.path + "/")) {
            return eventZkPath.substring(this.path.length() + 1);
        }
        return eventZkPath;
    }

    public void setClient(CuratorFramework client) {
        if (client != null) {
            this.client = client;
            this.privateZkClient = false;
        }
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public String getZkConnectString() {
        return this.zkConnectString;
    }

    public void setZkConnectString(String zkConnectString) {
        this.zkConnectString = zkConnectString;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }
}

