/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.upstream;

import java.util.List;
import org.apache.linkis.engineconn.computation.executor.entity.EngineConnTask;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.upstream.SingleThreadUpstreamConnectionMonitor;
import org.apache.linkis.engineconn.computation.executor.upstream.access.ConnectionInfoAccessRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.access.ECTaskEntranceInfoAccess;
import org.apache.linkis.engineconn.computation.executor.upstream.access.ECTaskEntranceInfoAccessRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.ECTaskKillHandler;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.ECTaskKillHandlerRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.handler.MonitorHandlerRequest;
import org.apache.linkis.engineconn.computation.executor.upstream.wrapper.ConnectionInfoWrapper;
import org.apache.linkis.engineconn.computation.executor.upstream.wrapper.ECTaskEntranceConnectionWrapper;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154AAB\u0004\u0001-!)1\u0005\u0001C\u0001I!)a\u0005\u0001C\u0001O!)Q\b\u0001C\u0001}!)A\n\u0001C!\u001b\")A\r\u0001C!K\n)Ri\u0011+bg.,e\u000e\u001e:b]\u000e,Wj\u001c8ji>\u0014(B\u0001\u0005\n\u0003!)\bo\u001d;sK\u0006l'B\u0001\u0006\f\u0003!)\u00070Z2vi>\u0014(B\u0001\u0007\u000e\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\u000b\u00059y\u0011AC3oO&tWmY8o]*\u0011\u0001#E\u0001\u0007Y&t7.[:\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\u0007\t\u00031ei\u0011aB\u0005\u00035\u001d\u0011QeU5oO2,G\u000b\u001b:fC\u0012,\u0006o\u001d;sK\u0006l7i\u001c8oK\u000e$\u0018n\u001c8N_:LGo\u001c:\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012!B;uS2\u001c(B\u0001\u0011\u0010\u0003\u0019\u0019w.\\7p]&\u0011!%\b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002\u0019\u0001\u0005A!/Z4jgR,'\u000fF\u0002)]Y\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012A!\u00168ji\")qF\u0001a\u0001a\u0005!A/Y:l!\t\tD'D\u00013\u0015\t\u0019\u0014\"\u0001\u0004f]RLG/_\u0005\u0003kI\u0012a\"\u00128hS:,7i\u001c8o)\u0006\u001c8\u000eC\u0003\u000b\u0005\u0001\u0007q\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;\u0013\u00059Q\r_3dkR,\u0017B\u0001\u001f:\u0005M\u0019u.\u001c9vi\u0006$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u0003))hN]3hSN$XM\u001d\u000b\u0003Q}BQ\u0001Q\u0002A\u0002\u0005\u000ba\u0001^1tW&#\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002EU5\tQI\u0003\u0002G+\u00051AH]8pizJ!\u0001\u0013\u0016\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011*\n\u0011dZ3oKJ\fG/Z%oM>\f5mY3tgJ+\u0017/^3tiR\u0011a\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u001e\ta!Y2dKN\u001c\u0018BA*Q\u0005m\u0019uN\u001c8fGRLwN\\%oM>\f5mY3tgJ+\u0017/^3ti\")Q\u000b\u0002a\u0001-\u0006YqO]1qa\u0016\u0014H*[:u!\r9FLX\u0007\u00021*\u0011\u0011LW\u0001\u0005kRLGNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&\u0001\u0002'jgR\u0004\"a\u00182\u000e\u0003\u0001T!!Y\u0004\u0002\u000f]\u0014\u0018\r\u001d9fe&\u00111\r\u0019\u0002\u0016\u0007>tg.Z2uS>t\u0017J\u001c4p/J\f\u0007\u000f]3s\u0003Y9WM\\3sCR,\u0007*\u00198eY\u0016\u0014(+Z9vKN$HC\u00014m!\t9'.D\u0001i\u0015\tIw!A\u0004iC:$G.\u001a:\n\u0005-D'!F'p]&$xN\u001d%b]\u0012dWM\u001d*fcV,7\u000f\u001e\u0005\u0006+\u0016\u0001\rA\u0016")
public class ECTaskEntranceMonitor
extends SingleThreadUpstreamConnectionMonitor {
    public void register(EngineConnTask task, ComputationExecutor executor) {
        this.panicIfNull(task, "engineConnTask should not be null");
        this.panicIfNull((Object)executor, "executor should not be null");
        String taskID = task.getTaskId();
        if (this.wrapperMap().containsKey(taskID)) {
            this.logger().error(new StringBuilder(47).append("registered duplicate EngineConnTask!! task-id: ").append(taskID).toString());
        }
        this.wrapperMap().putIfAbsent(taskID, new ECTaskEntranceConnectionWrapper(taskID, task, executor));
    }

    public void unregister(String taskID) {
        if (!this.wrapperMap().containsKey(taskID)) {
            this.logger().warn(new StringBuilder(63).append("attempted to unregister non-existing EngineConnTask!! task-id: ").append(taskID).toString());
        }
        this.wrapperMap().remove(taskID);
    }

    @Override
    public ConnectionInfoAccessRequest generateInfoAccessRequest(List<ConnectionInfoWrapper> wrapperList) {
        this.panicIfNull(wrapperList, "wrapperList cannot be null");
        return new ECTaskEntranceInfoAccessRequest(wrapperList);
    }

    @Override
    public MonitorHandlerRequest generateHandlerRequest(List<ConnectionInfoWrapper> wrapperList) {
        this.panicIfNull(wrapperList, "wrapperList cannot be null");
        return new ECTaskKillHandlerRequest(wrapperList);
    }

    public ECTaskEntranceMonitor() {
        super("ECTask-upstream-connection-monitor", new ECTaskEntranceInfoAccess(), new ECTaskKillHandler());
    }
}

