/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.httpclient;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.httpclient.Client;
import org.apache.linkis.httpclient.ResultListener;
import org.apache.linkis.httpclient.authentication.AbstractAuthenticationStrategy;
import org.apache.linkis.httpclient.authentication.AuthenticationAction;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.authentication.HttpAuthentication;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.config.HttpClientConstant$;
import org.apache.linkis.httpclient.discovery.AbstractDiscovery;
import org.apache.linkis.httpclient.discovery.Discovery;
import org.apache.linkis.httpclient.discovery.HeartbeatAction;
import org.apache.linkis.httpclient.exception.HttpClientResultException;
import org.apache.linkis.httpclient.exception.HttpClientRetryException;
import org.apache.linkis.httpclient.exception.HttpMessageParseException;
import org.apache.linkis.httpclient.exception.HttpMethodNotSupportException;
import org.apache.linkis.httpclient.loadbalancer.AbstractLoadBalancer;
import org.apache.linkis.httpclient.loadbalancer.DefaultLoadbalancerStrategy$;
import org.apache.linkis.httpclient.loadbalancer.LoadBalancer;
import org.apache.linkis.httpclient.request.Action;
import org.apache.linkis.httpclient.request.DeleteAction;
import org.apache.linkis.httpclient.request.DownloadAction;
import org.apache.linkis.httpclient.request.GetAction;
import org.apache.linkis.httpclient.request.HttpAction;
import org.apache.linkis.httpclient.request.POSTAction;
import org.apache.linkis.httpclient.request.PutAction;
import org.apache.linkis.httpclient.request.ServerUrlAction;
import org.apache.linkis.httpclient.request.UploadAction;
import org.apache.linkis.httpclient.request.UserAction;
import org.apache.linkis.httpclient.response.HttpMetric;
import org.apache.linkis.httpclient.response.MetricResult;
import org.apache.linkis.httpclient.response.Result;
import org.apache.linkis.httpclient.response.Result$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u001dc!\u0002\u0013&\u0003\u0003q\u0003\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011)\u0003!\u0011!Q\u0001\n-CQ\u0001\u0017\u0001\u0005\u0002eCq!\u0018\u0001C\u0002\u0013Ea\f\u0003\u0004d\u0001\u0001\u0006Ia\u0018\u0005\bI\u0002\u0011\r\u0011\"\u0005f\u0011\u0019\u0001\b\u0001)A\u0005M\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0004x\u0001\t\u0007I\u0011\u0003=\t\rq\u0004\u0001\u0015!\u0003z\u0011)i\b\u0001%A\u0001\u0004\u0003\u0006IA \u0005\n\u0003\u001f\u0001!\u0019!C\t\u0003GA\u0001\"!\n\u0001A\u0003%\u00111\u0001\u0005\n\u0003O\u0001!\u0019!C\t\u0003SA\u0001\"a\u000b\u0001A\u0003%\u0011Q\u0003\u0005\b\u0003[\u0001a\u0011CA\u0018\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\r\u0001\t\u0003\n\t\u0006C\u0004\u00022\u0001!\t%a\u0018\t\u000f\u0005M\u0004\u0001\"\u0005\u0002v!9\u0011q\u0010\u0001\u0005\u0012\u0005\u0005\u0005bBAF\u0001\u0011E\u0011Q\u0012\u0005\b\u0003?\u0003A\u0011CAQ\u0011\u001d\tY\u000b\u0001C\t\u0003[Cq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002t\u0001!I!!2\t\u000f\u0005%\u0007\u0001\"\u0005\u0002L\"9\u0011Q\u001c\u0001\u0007\u0012\u0005}\u0007bBA~\u0001\u0011E\u0011Q \u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\tY\u0010\u0001C\t\u0005+AqA!\n\u0001\t#\u00119\u0003C\u0004\u00036\u00011\tBa\u000e\t\u000f\t\r\u0003\u0001\"\u0011\u0003F\t\u0011\u0012IY:ue\u0006\u001cG\u000f\u0013;ua\u000ec\u0017.\u001a8u\u0015\t1s%\u0001\u0006iiR\u00048\r\\5f]RT!\u0001K\u0015\u0002\r1Lgn[5t\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M!\u0001aL\u001c<!\t\u0001T'D\u00012\u0015\t\u00114'\u0001\u0003mC:<'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012aa\u00142kK\u000e$\bC\u0001\u001d:\u001b\u0005)\u0013B\u0001\u001e&\u0005\u0019\u0019E.[3oiB\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006kRLGn\u001d\u0006\u0003\u0001\u001e\naaY8n[>t\u0017B\u0001\">\u0005\u001daunZ4j]\u001e\fAb\u00197jK:$8i\u001c8gS\u001e\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u0013\u0002\r\r|gNZ5h\u0013\tIeI\u0001\u0007DY&,g\u000e^\"p]\u001aLw-\u0001\u0006dY&,g\u000e\u001e(b[\u0016\u0004\"\u0001T+\u000f\u00055\u001b\u0006C\u0001(R\u001b\u0005y%B\u0001).\u0003\u0019a$o\\8u})\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\u00061\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!\u0016+\u0001\u0004=S:LGO\u0010\u000b\u00045nc\u0006C\u0001\u001d\u0001\u0011\u0015\u00195\u00011\u0001E\u0011\u0015Q5\u00011\u0001L\u0003A\u0019uJ\u0014(F\u0007R{F+S'F?>+F+F\u0001`!\t\u0001\u0017-D\u0001R\u0013\t\u0011\u0017KA\u0002J]R\f\u0011cQ(O\u001d\u0016\u001bEk\u0018+J\u001b\u0016{v*\u0016+!\u0003-\u0019wn\\6jKN#xN]3\u0016\u0003\u0019\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\r\rd\u0017.\u001a8u\u0015\tYG.\u0001\u0003j[Bd'BA7*\u0003\u0011AG\u000f\u001e9\n\u0005=D'\u0001\u0005\"bg&\u001c7i\\8lS\u0016\u001cFo\u001c:f\u00031\u0019wn\\6jKN#xN]3!\u0003EAG\u000f\u001e9DY&,g\u000e\u001e\"vS2$WM]\u000b\u0002gB\u0011q\r^\u0005\u0003k\"\u0014\u0011\u0003\u0013;ua\u000ec\u0017.\u001a8u\u0005VLG\u000eZ3s\u0003IAG\u000f\u001e9DY&,g\u000e\u001e\"vS2$WM\u001d\u0011\u0002\u0015!$H\u000f]\"mS\u0016tG/F\u0001z!\t9'0\u0003\u0002|Q\n\u00192\t\\8tK\u0006\u0014G.\u001a%uiB\u001cE.[3oi\u0006Y\u0001\u000e\u001e;q\u00072LWM\u001c;!\u0003\rAHE\r\t\u0007A~\f\u0019!!\u0006\n\u0007\u0005\u0005\u0011K\u0001\u0004UkBdWM\r\t\u0006A\u0006\u0015\u0011\u0011B\u0005\u0004\u0003\u000f\t&AB(qi&|g\u000e\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty!J\u0001\nI&\u001c8m\u001c<fefLA!a\u0005\u0002\u000e\tIA)[:d_Z,'/\u001f\t\u0006A\u0006\u0015\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD\u0013\u0002\u00191|\u0017\r\u001a2bY\u0006t7-\u001a:\n\t\u0005\u0005\u00121\u0004\u0002\r\u0019>\fGMQ1mC:\u001cWM]\u000b\u0003\u0003\u0007\t!\u0002Z5tG>4XM]=!\u00031aw.\u00193CC2\fgnY3s+\t\t)\"A\u0007m_\u0006$')\u00197b]\u000e,'\u000fI\u0001\u0010GJ,\u0017\r^3ESN\u001cwN^3ssR\u0011\u0011\u0011B\u0001\bKb,7-\u001e;f)\u0011\t)$!\u0011\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f&\u0003!\u0011Xm\u001d9p]N,\u0017\u0002BA \u0003s\u0011aAU3tk2$\bbBA\"%\u0001\u0007\u0011QI\u0001\u000ee\u0016\fX/Z:u\u0003\u000e$\u0018n\u001c8\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013&\u0003\u001d\u0011X-];fgRLA!a\u0014\u0002J\t1\u0011i\u0019;j_:$b!!\u000e\u0002T\u0005U\u0003bBA\"'\u0001\u0007\u0011Q\t\u0005\b\u0003/\u001a\u0002\u0019AA-\u0003!9\u0018-\u001b;US6,\u0007c\u00011\u0002\\%\u0019\u0011QL)\u0003\t1{gn\u001a\u000b\u0007\u0003C\n9'!\u001b\u0011\u0007\u0001\f\u0019'C\u0002\u0002fE\u0013A!\u00168ji\"9\u00111\t\u000bA\u0002\u0005\u0015\u0003bBA6)\u0001\u0007\u0011QN\u0001\u000fe\u0016\u001cX\u000f\u001c;MSN$XM\\3s!\rA\u0014qN\u0005\u0004\u0003c*#A\u0004*fgVdG\u000fT5ti\u0016tWM]\u0001\u000eO\u0016$(+Z9vKN$XK\u001d7\u0015\u000b-\u000b9(a\u001f\t\r\u0005eT\u00031\u0001L\u0003%\u0019XO\u001a4jqV\u0013H\u000e\u0003\u0004\u0002~U\u0001\raS\u0001\fe\u0016\fX/Z:u\u0005>$\u00170\u0001\u0006d_:tWm\u0019;Ve2$RaSAB\u0003\u000fCa!!\"\u0017\u0001\u0004Y\u0015A\u00029sK\u001aL\u0007\u0010\u0003\u0004\u0002\nZ\u0001\raS\u0001\u0007gV4g-\u001b=\u0002\u0019\u001d,GoU3sm\u0016\u0014XK\u001d7\u0015\u0007-\u000by\tC\u0004\u0002\u0012^\u0001\r!a%\u0002\u0007U\u0014\u0018\u000e\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIjM\u0001\u0004]\u0016$\u0018\u0002BAO\u0003/\u00131!\u0016*J\u00035\u0001(/\u001a9be\u0016\f5\r^5p]R!\u00111UAU!\u0011\t9%!*\n\t\u0005\u001d\u0016\u0011\n\u0002\u000b\u0011R$\b/Q2uS>t\u0007bBA\"1\u0001\u0007\u00111U\u0001\u000eaJ,\u0007/\u0019:f\u0007>|7.[3\u0015\t\u0005\u0005\u0014q\u0016\u0005\b\u0003\u0007J\u0002\u0019AAR\u0003!!(/\u001f'pO&tG\u0003CA1\u0003k\u000b9,a/\t\u000f\u0005\r#\u00041\u0001\u0002$\"1\u0011\u0011\u0018\u000eA\u0002-\u000bqA]3bYV\u0013F\nC\u0004\u0002>j\u0001\r!a0\u0002\u000f%\u001chi\u001c:dKB\u0019\u0001-!1\n\u0007\u0005\r\u0017KA\u0004C_>dW-\u00198\u0015\u0007-\u000b9\rC\u0004\u0002Dm\u0001\r!a)\u0002\u0015A\u0014X\r]1sKJ+\u0017\u000f\u0006\u0003\u0002N\u0006m\u0007\u0003BAh\u0003/l!!!5\u000b\t\u0005M\u0017Q[\u0001\b[\u0016$\bn\u001c3t\u0015\tIG.\u0003\u0003\u0002Z\u0006E'a\u0004%uiB\u0014V-];fgR\u0014\u0015m]3\t\u000f\u0005\rC\u00041\u0001\u0002$\u0006Yq-\u001a;Gg\nKXk]3s)\u0019\t\t/!<\u0002rB!\u00111]Au\u001b\t\t)OC\u0002\u0002h~\n!![8\n\t\u0005-\u0018Q\u001d\u0002\u0003\rNDa!a<\u001e\u0001\u0004Y\u0015\u0001B;tKJDq!a=\u001e\u0001\u0004\t)0\u0001\u0003qCRD\u0007\u0003BAr\u0003oLA!!?\u0002f\n1ai\u001d)bi\"\fa\"\u001a=fGV$XMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0000\n\u0015!\u0011\u0002\t\u0005\u0003\u001f\u0014\t!\u0003\u0003\u0003\u0004\u0005E'!F\"m_N,\u0017M\u00197f\u0011R$\bOU3ta>t7/\u001a\u0005\b\u0005\u000fq\u0002\u0019AAg\u0003\r\u0011X-\u001d\u0005\b\u0003/r\u0002\u0019\u0001B\u0006!\u0015\u0001\u0017QAA-\u0003i\tG\rZ+o\u0011\u0016\fG\u000e\u001e5z+JdGk\u001c#jg\u000e|g/\u001a:z)\u0011\t\tG!\u0005\t\r\tMq\u00041\u0001L\u0003%\u0019XM\u001d<feV\u0013H\u000e\u0006\u0005\u0002\u0000\n]!\u0011\u0004B\u000e\u0011\u001d\u00119\u0001\ta\u0001\u0003\u001bDq!a\u0016!\u0001\u0004\u0011Y\u0001\u0003\u0004eA\u0001\u0007!Q\u0004\t\u0005\u0005?\u0011\t#\u0004\u0002\u0002V&!!1EAk\u0005-\u0019un\\6jKN#xN]3\u0002!I,7\u000f]8og\u0016$vNU3tk2$HCBA\u001b\u0005S\u0011\u0019\u0004C\u0004\u0002<\u0005\u0002\rAa\u000b\u0011\t\t5\"qF\u0007\u0002Y&\u0019!\u0011\u00077\u0003\u0019!#H\u000f\u001d*fgB|gn]3\t\u000f\u0005\r\u0013\u00051\u0001\u0002F\u0005!\u0002\u000e\u001e;q%\u0016\u001c\bo\u001c8tKR{'+Z:vYR$\u0002B!\u000f\u0003<\tu\"q\b\t\u0006A\u0006\u0015\u0011Q\u0007\u0005\b\u0003w\u0011\u0003\u0019\u0001B\u0016\u0011\u001d\t\u0019E\ta\u0001\u0003GCaA!\u0011#\u0001\u0004Y\u0015\u0001\u0004:fgB|gn]3C_\u0012L\u0018!B2m_N,GCAA1\u0001")
public abstract class AbstractHttpClient
implements Client,
Logging {
    private final ClientConfig clientConfig;
    private final int CONNECT_TIME_OUT;
    private final BasicCookieStore cookieStore;
    private final HttpClientBuilder httpClientBuilder;
    private final CloseableHttpClient httpClient;
    private final /* synthetic */ Tuple2 x$2;
    private final Option<Discovery> discovery;
    private final Option<LoadBalancer> loadBalancer;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public int CONNECT_TIME_OUT() {
        return this.CONNECT_TIME_OUT;
    }

    public BasicCookieStore cookieStore() {
        return this.cookieStore;
    }

    private HttpClientBuilder httpClientBuilder() {
        return this.httpClientBuilder;
    }

    public CloseableHttpClient httpClient() {
        return this.httpClient;
    }

    public Option<Discovery> discovery() {
        return this.discovery;
    }

    public Option<LoadBalancer> loadBalancer() {
        return this.loadBalancer;
    }

    public abstract Discovery createDiscovery();

    @Override
    public Result execute(Action requestAction) {
        return this.execute(requestAction, -1L);
    }

    @Override
    public Result execute(Action requestAction, long waitTime) {
        if (!(requestAction instanceof HttpAction)) {
            throw new UnsupportedOperationException(new StringBuilder(43).append("only HttpAction supported, but the fact is ").append(requestAction.getClass()).toString());
        }
        HttpAction action = this.prepareAction((HttpAction)requestAction);
        long startTime = System.currentTimeMillis();
        long prepareReqTime = System.currentTimeMillis() - startTime;
        this.prepareCookie(action);
        ArrayList<Object> attempts = new ArrayList<Object>();
        CloseableHttpResponse response = !this.clientConfig.isRetryEnabled() ? this.addAttempt$1(action, waitTime, attempts) : (CloseableHttpResponse)this.clientConfig.getRetryHandler().retry((Function0 & Serializable & scala.Serializable)() -> this.addAttempt$1(action, waitTime, attempts), new StringBuilder(11).append(action.getClass().getSimpleName()).append("HttpRequest").toString());
        long beforeDeserializeTime = System.currentTimeMillis();
        Result result = this.responseToResult((HttpResponse)response, action);
        if (result instanceof MetricResult) {
            Result result2 = result;
            if (((MetricResult)((Object)result2)).getMetric() == null) {
                ((MetricResult)((Object)result2)).setMetric(new HttpMetric());
            }
            ((MetricResult)((Object)result2)).getMetric().setPrepareReqTime(prepareReqTime);
            ((MetricResult)((Object)result2)).getMetric().addRetries(attempts);
            ((MetricResult)((Object)result2)).getMetric().setDeserializeTime(System.currentTimeMillis() - beforeDeserializeTime);
            ((MetricResult)((Object)result2)).getMetric().setExecuteTotalTime(System.currentTimeMillis() - startTime);
            return result2;
        }
        if (result != null) {
            Result result3 = result;
            return result3;
        }
        throw new MatchError((Object)result);
    }

    @Override
    public void execute(Action requestAction, ResultListener resultListener) {
        throw new HttpMethodNotSupportException("Not supported client method!");
    }

    public String getRequestUrl(String suffixUrl, String requestBody) {
        String urlPrefix;
        String chooseUrlPrefix = (String)this.loadBalancer().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.chooseServerUrl(requestBody)).orNull(Predef$.MODULE$.$conforms());
        String string = urlPrefix = chooseUrlPrefix == null ? this.clientConfig.getDefaultServerUrl() : chooseUrlPrefix;
        if (suffixUrl.contains(urlPrefix)) {
            return suffixUrl;
        }
        return this.connectUrl(urlPrefix, suffixUrl);
    }

    public String connectUrl(String prefix, String suffix) {
        boolean prefixEnd = prefix.endsWith(HttpClientConstant$.MODULE$.PATH_SPLIT_TOKEN());
        boolean suffixStart = suffix.startsWith(HttpClientConstant$.MODULE$.PATH_SPLIT_TOKEN());
        if (prefixEnd && suffixStart) {
            return new StringBuilder(0).append(prefix.substring(0, prefix.length() - 1)).append(suffix).toString();
        }
        if (!prefixEnd && !suffixStart) {
            return new StringBuilder(0).append(prefix).append(HttpClientConstant$.MODULE$.PATH_SPLIT_TOKEN()).append(suffix).toString();
        }
        return new StringBuilder(0).append(prefix).append(suffix).toString();
    }

    public String getServerUrl(URI uri) {
        return new StringBuilder(4).append(uri.getScheme()).append("://").append(uri.getHost()).append(":").append(uri.getPort()).toString();
    }

    public HttpAction prepareAction(HttpAction requestAction) {
        return requestAction;
    }

    public void prepareCookie(HttpAction requestAction) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requestAction.getCookies())).nonEmpty()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requestAction.getCookies())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                AbstractHttpClient.$anonfun$prepareCookie$1(this, x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tryLogin(HttpAction requestAction, String realURL, boolean isForce) {
        block5: {
            if (this.clientConfig.getAuthenticationStrategy() == null) break block5;
            var7_4 = this.clientConfig.getAuthenticationStrategy();
            if (!(var7_4 instanceof AbstractAuthenticationStrategy)) ** GOTO lbl-1000
            var8_5 = (AbstractAuthenticationStrategy)var7_4;
            if (isForce) {
                v0 = var8_5.enforceLogin(requestAction, realURL.replaceAll(requestAction.getURL(), ""));
            } else lbl-1000:
            // 2 sources

            {
                v0 = this.clientConfig.getAuthenticationStrategy().login(requestAction, realURL.replaceAll(requestAction.getURL(), ""));
            }
            var9_7 = authentication = v0;
            if (var9_7 instanceof HttpAuthentication) {
                var10_8 = (HttpAuthentication)var9_7;
                cookies = var10_8.authToCookies();
                if (cookies != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).nonEmpty()) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cookies)).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$tryLogin$1$adapted(org.apache.linkis.httpclient.request.HttpAction org.apache.http.cookie.Cookie ), (Lorg/apache/http/cookie/Cookie;)Ljava/lang/Object;)((HttpAction)requestAction));
                }
                if ((headers = var10_8.authToHeaders()) != null && !headers.isEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(headers).asScala()).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$tryLogin$2$adapted(org.apache.linkis.httpclient.request.HttpAction scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((HttpAction)requestAction));
                    return;
                }
                return;
            }
            return;
        }
    }

    private String getRequestUrl(HttpAction requestAction) {
        HttpAction httpAction = requestAction;
        if (httpAction instanceof ServerUrlAction) {
            HttpAction httpAction2 = httpAction;
            return this.connectUrl(((ServerUrlAction)((Object)httpAction2)).serverUrl(), requestAction.getURL());
        }
        return this.getRequestUrl(requestAction.getURL(), requestAction.getRequestBody());
    }

    public HttpRequestBase prepareReq(HttpAction requestAction) {
        HttpDelete httpDelete;
        String realURL = this.getRequestUrl(requestAction);
        this.tryLogin(requestAction, realURL, false);
        HttpAction httpAction = requestAction;
        if (httpAction instanceof DeleteAction) {
            DeleteAction deleteAction = (DeleteAction)httpAction;
            URIBuilder builder = new URIBuilder(realURL);
            if (!deleteAction.getParameters().isEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(deleteAction.getParameters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (k != null && v != null) {
                            return builder.addParameter(k.toString(), v.toString());
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            HttpDelete httpDelete2 = new HttpDelete(builder.build());
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).nonEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    AbstractHttpClient.$anonfun$prepareReq$2(httpDelete2, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
            httpDelete = httpDelete2;
        } else if (httpAction instanceof PutAction) {
            PutAction putAction = (PutAction)httpAction;
            HttpPut httpPut = new HttpPut(realURL);
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(putAction.getParameters()).asScala()).nonEmpty() || ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(putAction.getFormParams()).asScala()).nonEmpty()) {
                ArrayList nameValuePairs = new ArrayList();
                if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(putAction.getParameters()).asScala()).nonEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(putAction.getParameters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            Object v = tuple2._2();
                            if (v != null) {
                                return BoxesRunTime.boxToBoolean((boolean)nameValuePairs.add(new BasicNameValuePair(k, v.toString())));
                            }
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(putAction.getFormParams()).asScala()).nonEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(putAction.getFormParams()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple2 tuple2 = x0$4;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            if (v != null) {
                                return BoxesRunTime.boxToBoolean((boolean)nameValuePairs.add(new BasicNameValuePair(k, v.toString())));
                            }
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, Charset.defaultCharset()));
            }
            if (StringUtils.isNotBlank((CharSequence)putAction.getRequestPayload())) {
                StringEntity stringEntity = new StringEntity(putAction.getRequestPayload(), "UTF-8");
                stringEntity.setContentEncoding((String)Configuration$.MODULE$.BDP_ENCODING().getValue());
                stringEntity.setContentType("application/json");
                httpPut.setEntity((HttpEntity)stringEntity);
            }
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).nonEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                    AbstractHttpClient.$anonfun$prepareReq$5(httpPut, x0$5);
                    return BoxedUnit.UNIT;
                });
            }
            httpDelete = httpPut;
        } else if (httpAction instanceof UploadAction) {
            HttpAction httpAction2 = httpAction;
            HttpPost httpPost = new HttpPost(realURL);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (((UploadAction)((Object)httpAction2)).inputStreams() != null) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((UploadAction)((Object)httpAction2)).inputStreams()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                    Tuple2 tuple2 = x0$6;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        InputStream v = (InputStream)tuple2._2();
                        return builder.addBinaryBody(k, v, ContentType.create((String)"multipart/form-data"), k);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((UploadAction)((Object)httpAction2)).binaryBodies()).asScala()).foreach((Function1 & Serializable & scala.Serializable)binaryBody -> builder.addBinaryBody(binaryBody.parameterName(), binaryBody.inputStream(), binaryBody.contentType(), binaryBody.fileName()));
            HttpAction httpAction3 = httpAction2;
            if (httpAction3 instanceof GetAction) {
                GetAction getAction = (GetAction)httpAction3;
                ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(getAction.getParameters()).asScala()).retain((Function2 & Serializable & scala.Serializable)(k, v) -> BoxesRunTime.boxToBoolean((boolean)AbstractHttpClient.$anonfun$prepareReq$8(k, v))).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                    Tuple2 tuple2 = x0$7;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (k != null && v != null) {
                            return builder.addTextBody(k, v.toString());
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            HttpAction httpAction4 = httpAction2;
            if (httpAction4 instanceof GetAction) {
                GetAction getAction = (GetAction)httpAction4;
                ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(getAction.getHeaders()).asScala()).retain((Function2 & Serializable & scala.Serializable)(k, v) -> BoxesRunTime.boxToBoolean((boolean)AbstractHttpClient.$anonfun$prepareReq$10(k, v))).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                    AbstractHttpClient.$anonfun$prepareReq$11(httpPost, x0$8);
                    return BoxedUnit.UNIT;
                });
            }
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            httpDelete = httpPost;
        } else if (httpAction instanceof POSTAction) {
            POSTAction pOSTAction = (POSTAction)httpAction;
            HttpPost httpPost = new HttpPost(realURL);
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pOSTAction.getParameters()).asScala()).nonEmpty() || ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pOSTAction.getFormParams()).asScala()).nonEmpty()) {
                ArrayList nvps = new ArrayList();
                if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pOSTAction.getParameters()).asScala()).nonEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pOSTAction.getParameters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                        Tuple2 tuple2 = x0$9;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            Object v = tuple2._2();
                            if (v != null) {
                                return BoxesRunTime.boxToBoolean((boolean)nvps.add(new BasicNameValuePair(k, v.toString())));
                            }
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, Charset.defaultCharset()));
                } else if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(pOSTAction.getFormParams()).asScala()).nonEmpty()) {
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pOSTAction.getFormParams()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
                        Tuple2 tuple2 = x0$10;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            if (v != null) {
                                return BoxesRunTime.boxToBoolean((boolean)nvps.add(new BasicNameValuePair(k, v.toString())));
                            }
                            return BoxedUnit.UNIT;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    HttpEntity entity = EntityBuilder.create().setContentType(ContentType.create((String)"application/x-www-form-urlencoded", (Charset)Consts.UTF_8)).setParameters(nvps).build();
                    httpPost.setEntity(entity);
                }
            } else if (StringUtils.isNotBlank((CharSequence)pOSTAction.getRequestPayload())) {
                StringEntity stringEntity = new StringEntity(pOSTAction.getRequestPayload(), "UTF-8");
                stringEntity.setContentEncoding((String)Configuration$.MODULE$.BDP_ENCODING().getValue());
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
            }
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).nonEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
                    AbstractHttpClient.$anonfun$prepareReq$14(httpPost, x0$11);
                    return BoxedUnit.UNIT;
                });
            }
            httpDelete = httpPost;
        } else if (httpAction instanceof GetAction) {
            GetAction getAction = (GetAction)httpAction;
            URIBuilder builder = new URIBuilder(realURL);
            if (!getAction.getParameters().isEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(getAction.getParameters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
                    Tuple2 tuple2 = x0$12;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        if (k != null && v != null) {
                            return builder.addParameter(k.toString(), v.toString());
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            HttpGet httpGet = new HttpGet(builder.build());
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).nonEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$13 -> {
                    AbstractHttpClient.$anonfun$prepareReq$16(httpGet, x0$13);
                    return BoxedUnit.UNIT;
                });
            }
            httpDelete = httpGet;
        } else {
            HttpPost httpost = new HttpPost(realURL);
            StringEntity stringEntity = new StringEntity(requestAction.getRequestBody(), "UTF-8");
            stringEntity.setContentEncoding((String)Configuration$.MODULE$.BDP_ENCODING().getValue());
            stringEntity.setContentType("application/json");
            httpost.setEntity((HttpEntity)stringEntity);
            if (((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).nonEmpty()) {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requestAction.getHeaders()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$14 -> {
                    AbstractHttpClient.$anonfun$prepareReq$17(httpost, x0$14);
                    return BoxedUnit.UNIT;
                });
            }
            httpDelete = httpost;
        }
        HttpDelete request = httpDelete;
        return request;
    }

    public abstract Fs getFsByUser(String var1, FsPath var2);

    public CloseableHttpResponse executeRequest(HttpRequestBase req, Option<Object> waitTime) {
        CloseableHttpResponse closeableHttpResponse;
        long readTimeOut = BoxesRunTime.unboxToLong((Object)waitTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.clientConfig.getReadTimeout()));
        long connectTimeOut = this.clientConfig.getConnectTimeout() > 1000L || this.clientConfig.getConnectTimeout() < 0L ? this.clientConfig.getConnectTimeout() : (long)this.CONNECT_TIME_OUT();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)connectTimeOut).setConnectionRequestTimeout((int)connectTimeOut).setSocketTimeout((int)readTimeOut).build();
        req.setConfig(requestConfig);
        try {
            closeableHttpResponse = this.httpClient().execute((HttpUriRequest)req);
        }
        catch (ConnectionPoolTimeoutException connectionPoolTimeOutException) {
            String serverUrl = this.getServerUrl(req.getURI());
            this.addUnHealthyUrlToDiscovery(serverUrl);
            this.logger().warn("will be server url add unhealthy for connectionPoolTimeOutException");
            throw new HttpClientRetryException("connectionPoolTimeOutException", connectionPoolTimeOutException);
        }
        catch (ConnectTimeoutException connectionTimeOutException) {
            String serverUrl = this.getServerUrl(req.getURI());
            this.addUnHealthyUrlToDiscovery(serverUrl);
            this.logger().warn("will be server url add unhealthy for connectionTimeOutException");
            throw new HttpClientRetryException("connectionTimeOutException", connectionTimeOutException);
        }
        catch (HttpHostConnectException httpHostConnectException) {
            String serverUrl = this.getServerUrl(req.getURI());
            this.addUnHealthyUrlToDiscovery(serverUrl);
            this.logger().warn("will be server url add unhealthy for httpHostConnectException");
            throw new HttpClientRetryException("httpHostConnectException", httpHostConnectException);
        }
        catch (Throwable t) {
            throw t;
        }
        CloseableHttpResponse response = closeableHttpResponse;
        return response;
    }

    private void addUnHealthyUrlToDiscovery(String serverUrl) {
        this.discovery().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractHttpClient.$anonfun$addUnHealthyUrlToDiscovery$1(serverUrl, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public CloseableHttpResponse executeRequest(HttpRequestBase req, Option<Object> waitTime, CookieStore cookieStore) {
        long readTimeOut = BoxesRunTime.unboxToLong((Object)waitTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.clientConfig.getReadTimeout()));
        long connectTimeOut = this.clientConfig.getConnectTimeout() > 1000L || this.clientConfig.getConnectTimeout() < 0L ? this.clientConfig.getConnectTimeout() : (long)this.CONNECT_TIME_OUT();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)connectTimeOut).setConnectionRequestTimeout((int)connectTimeOut).setSocketTimeout((int)readTimeOut).build();
        req.setConfig(requestConfig);
        CloseableHttpResponse response = this.httpClient().execute((HttpUriRequest)req);
        return response;
    }

    public Result responseToResult(HttpResponse response, Action requestAction) {
        return (Result)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
            Result result;
            Result result2;
            HttpEntity entity = response.getEntity();
            Action action = requestAction;
            if (action instanceof DownloadAction) {
                InputStream inputStream;
                Action action2 = action;
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    HttpResponse httpResponse;
                    String responseBody = null;
                    if (entity != null) {
                        responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                    if (!((httpResponse = response) instanceof CloseableHttpResponse)) throw new HttpClientResultException(new StringBuilder(33).append("request failed! ResponseBody is ").append(responseBody).append(".").toString());
                    CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)httpResponse;
                    IOUtils.closeQuietly((Closeable)closeableHttpResponse);
                    throw new HttpClientResultException(new StringBuilder(33).append("request failed! ResponseBody is ").append(responseBody).append(".").toString());
                }
                if (entity.getContentEncoding() != null && StringUtils.isNotBlank((CharSequence)entity.getContentEncoding().getValue())) {
                    String string = entity.getContentEncoding().getValue().toLowerCase(Locale.getDefault());
                    if ("gzip".equals(string)) {
                        inputStream = new GzipDecompressingEntity(entity).getContent();
                    } else {
                        if (!"deflate".equals(string)) throw new HttpClientResultException(new StringBuilder(53).append("request failed! Reason: not support decompress type ").append(string).append(".").toString());
                        inputStream = new DeflateDecompressingEntity(entity).getContent();
                    }
                } else {
                    inputStream = entity.getContent();
                }
                InputStream inputStream2 = inputStream;
                ((DownloadAction)((Object)action2)).write(inputStream2, response);
                result2 = Result$.MODULE$.apply();
            } else if (action instanceof HeartbeatAction) {
                HeartbeatAction heartbeatAction = (HeartbeatAction)action;
                result2 = (Result)this.discovery().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Discovery discovery = x0$1;
                    if (discovery instanceof AbstractDiscovery) {
                        AbstractDiscovery abstractDiscovery = (AbstractDiscovery)discovery;
                        return abstractDiscovery.getHeartbeatResult(response, heartbeatAction);
                    }
                    throw new MatchError((Object)discovery);
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new HttpMessageParseException("Discovery is not enable, HeartbeatAction is not needed!");
                });
            } else if (action instanceof AuthenticationAction) {
                AuthenticationAction authenticationAction = (AuthenticationAction)action;
                AuthenticationStrategy authenticationStrategy = $this.clientConfig.getAuthenticationStrategy();
                if (!(authenticationStrategy instanceof AbstractAuthenticationStrategy)) throw new HttpMessageParseException("AuthenticationStrategy is not enable, login is not needed!");
                AbstractAuthenticationStrategy abstractAuthenticationStrategy = (AbstractAuthenticationStrategy)authenticationStrategy;
                result2 = abstractAuthenticationStrategy.getAuthenticationResult(response, authenticationAction);
            } else {
                if (!(action instanceof HttpAction)) throw new MatchError((Object)action);
                HttpAction httpAction = (HttpAction)action;
                ObjectRef responseBody = ObjectRef.create(null);
                if (entity != null) {
                    responseBody.elem = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                result2 = (Result)this.httpResponseToResult(response, httpAction, (String)responseBody.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new HttpMessageParseException(new StringBuilder(22).append("cannot parse message: ").append((String)responseBody$1.elem).toString());
                });
            }
            Result result3 = result = result2;
            if (!(result3 instanceof UserAction)) return result;
            Result result4 = result3;
            Action action3 = requestAction;
            if (!(action3 instanceof UserAction)) return result;
            Action action4 = action3;
            ((UserAction)((Object)result4)).setUser(((UserAction)((Object)action4)).getUser());
            return result;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!(requestAction instanceof DownloadAction)) {
                HttpResponse httpResponse = response;
                if (httpResponse instanceof CloseableHttpResponse) {
                    CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)httpResponse;
                    IOUtils.closeQuietly((Closeable)closeableHttpResponse);
                    return;
                }
                return;
            }
        });
    }

    public abstract Option<Result> httpResponseToResult(HttpResponse var1, HttpAction var2, String var3);

    @Override
    public void close() {
        this.discovery().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractHttpClient.$anonfun$close$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.httpClient().close();
    }

    public static final /* synthetic */ void $anonfun$x$2$1(AbstractHttpClient $this, Discovery x0$1) {
        Discovery discovery = x0$1;
        if (discovery instanceof AbstractDiscovery) {
            AbstractDiscovery abstractDiscovery = (AbstractDiscovery)discovery;
            abstractDiscovery.setServerUrl($this.clientConfig.getServerUrl());
            abstractDiscovery.setClient($this);
            abstractDiscovery.setSchedule($this.clientConfig.getDiscoveryPeriod(), $this.clientConfig.getDiscoveryTimeUnit());
            return;
        }
        discovery.setServerUrl($this.clientConfig.getServerUrl());
    }

    private final CloseableHttpResponse addAttempt$1(HttpAction action$1, long waitTime$1, ArrayList attempts$1) {
        CloseableHttpResponse response;
        block1: {
            String msg;
            while (true) {
                HttpRequestBase req = this.prepareReq(action$1);
                long startTime = System.currentTimeMillis();
                response = this.executeRequest(req, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)waitTime$1)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0L));
                long taken = System.currentTimeMillis() - startTime;
                attempts$1.add(BoxesRunTime.boxToLong((long)taken));
                String costTime = ByteTimeUtils.msDurationToString((long)taken);
                this.logger().info(new StringBuilder(28).append("invoke ").append(req.getURI()).append(" get status ").append(response.getStatusLine().getStatusCode()).append(" taken: ").append(costTime).append(".").toString());
                if (response.getStatusLine().getStatusCode() != 401) break block1;
                msg = (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> EntityUtils.toString((HttpEntity)response.getEntity()), (Function1 & Serializable & scala.Serializable)t -> {
                    this.logger().warn("failed to parse entity", t);
                    return "";
                });
                IOUtils.closeQuietly((Closeable)response);
                this.tryLogin(action$1, this.getRequestUrl(action$1), true);
                if (attempts$1.size() > 1) break;
                this.logger().info("The user is not logged in, default retry once");
            }
            this.logger().info("The user is not logged in, you can set a retry");
            throw new HttpClientRetryException(new StringBuilder(78).append("The user is not logged in, please log in first, you can set a retry, message: ").append(msg).toString());
        }
        return response;
    }

    public static final /* synthetic */ void $anonfun$prepareCookie$1(AbstractHttpClient $this, Cookie x$1) {
        $this.cookieStore().addCookie(x$1);
    }

    public static final /* synthetic */ void $anonfun$tryLogin$2(HttpAction requestAction$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                requestAction$1.addHeader(k.toString(), v.toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareReq$2(HttpDelete httpDelete$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                httpDelete$1.addHeader(k.toString(), v.toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareReq$5(HttpPut httpPut$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                httpPut$1.addHeader(k.toString(), v.toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$prepareReq$8(String k, Object v) {
        return v != null && k != null;
    }

    public static final /* synthetic */ boolean $anonfun$prepareReq$10(String k, String v) {
        return v != null && k != null;
    }

    public static final /* synthetic */ void $anonfun$prepareReq$11(HttpPost httpPost$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                httpPost$1.addHeader(k, v);
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareReq$14(HttpPost httpPost$2, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                httpPost$2.addHeader(k.toString(), v.toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareReq$16(HttpGet httpGet$1, Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                httpGet$1.addHeader(k.toString(), v.toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$prepareReq$17(HttpPost httpost$1, Tuple2 x0$14) {
        Tuple2 tuple2 = x0$14;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                httpost$1.addHeader(k.toString(), v.toString());
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$addUnHealthyUrlToDiscovery$1(String serverUrl$1, Discovery x0$1) {
        Discovery discovery = x0$1;
        if (discovery instanceof AbstractDiscovery) {
            AbstractDiscovery abstractDiscovery = (AbstractDiscovery)discovery;
            abstractDiscovery.addUnhealthyServerInstances(serverUrl$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$close$1(Discovery x0$1) {
        Discovery discovery = x0$1;
        if (discovery instanceof AbstractDiscovery) {
            AbstractDiscovery abstractDiscovery = (AbstractDiscovery)discovery;
            IOUtils.closeQuietly((Closeable)abstractDiscovery);
            return;
        }
    }

    public AbstractHttpClient(ClientConfig clientConfig, String clientName) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        CloseableHttpClient closeableHttpClient;
        this.clientConfig = clientConfig;
        Logging.$init$((Logging)this);
        this.CONNECT_TIME_OUT = BoxesRunTime.unboxToInt((Object)CommonVars$.MODULE$.apply("wds.linkis.httpclient.default.connect.timeOut", (Object)BoxesRunTime.boxToInteger((int)50000)).getValue());
        this.cookieStore = new BasicCookieStore();
        this.httpClientBuilder = HttpClients.custom().setDefaultCookieStore((CookieStore)this.cookieStore()).setMaxConnTotal(clientConfig.getMaxConnection()).setMaxConnPerRoute(clientConfig.getMaxConnection() / 2);
        if (clientConfig.isSSL()) {
            SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(null){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            closeableHttpClient = this.httpClientBuilder().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).build();
        } else {
            closeableHttpClient = this.httpClient = this.httpClientBuilder().build();
        }
        if (clientConfig.getAuthenticationStrategy() != null) {
            AuthenticationStrategy authenticationStrategy = clientConfig.getAuthenticationStrategy();
            if (authenticationStrategy instanceof AbstractAuthenticationStrategy) {
                AbstractAuthenticationStrategy abstractAuthenticationStrategy = (AbstractAuthenticationStrategy)authenticationStrategy;
                abstractAuthenticationStrategy.setClient(this);
            }
        }
        if (clientConfig.isDiscoveryEnabled()) {
            Some some;
            LoadBalancer lb;
            None$ loadBalancer;
            Some discovery = new Some((Object)this.createDiscovery());
            discovery.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                AbstractHttpClient.$anonfun$x$2$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            None$ none$ = loadBalancer = clientConfig.isLoadbalancerEnabled() && clientConfig.getLoadbalancerStrategy() != null ? new Some((Object)clientConfig.getLoadbalancerStrategy().createLoadBalancer()) : (clientConfig.isLoadbalancerEnabled() ? new Some((Object)DefaultLoadbalancerStrategy$.MODULE$.createLoadBalancer()) : None$.MODULE$);
            if (none$ instanceof Some && (lb = (LoadBalancer)(some = (Some)none$).value()) instanceof AbstractLoadBalancer) {
                AbstractLoadBalancer abstractLoadBalancer = (AbstractLoadBalancer)lb;
                discovery.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.addDiscoveryListener(abstractLoadBalancer);
                    return BoxedUnit.UNIT;
                });
            }
            tuple22 = new Tuple2((Object)discovery, (Object)loadBalancer);
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option discovery = (Option)tuple2._1();
        Option loadBalancer = (Option)tuple2._2();
        this.x$2 = new Tuple2((Object)discovery, (Object)loadBalancer);
        this.discovery = (Option)this.x$2._1();
        this.loadBalancer = (Option)this.x$2._2();
        this.discovery().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.start();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Object $anonfun$tryLogin$1$adapted(HttpAction requestAction$1, Cookie cookie) {
        requestAction$1.addCookie(cookie);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$tryLogin$2$adapted(HttpAction requestAction$1, Tuple2 x0$1) {
        AbstractHttpClient.$anonfun$tryLogin$2(requestAction$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

